/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.StringHelper;

public final class PropertiesHelper {
    private static final String PLACEHOLDER_START = "${";

    public static boolean getBoolean(String property, Properties properties) {
        String setting = properties.getProperty(property);
        return setting != null && Boolean.valueOf(setting.trim()) != false;
    }

    public static boolean getBoolean(String property, Properties properties, boolean defaultValue) {
        String setting = properties.getProperty(property);
        return setting == null ? defaultValue : Boolean.valueOf(setting.trim());
    }

    public static int getInt(String property, Properties properties, int defaultValue) {
        String propValue = properties.getProperty(property);
        return propValue == null ? defaultValue : Integer.parseInt(propValue.trim());
    }

    public static String getString(String property, Properties properties, String defaultValue) {
        String propValue = properties.getProperty(property);
        return propValue == null ? defaultValue : propValue;
    }

    public static Integer getInteger(String property, Properties properties) {
        String propValue = properties.getProperty(property);
        return propValue == null ? null : Integer.valueOf(propValue.trim());
    }

    public static Map toMap(String property, String delim, Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        String propValue = properties.getProperty(property);
        if (propValue != null) {
            StringTokenizer tokens = new StringTokenizer(propValue, delim);
            while (tokens.hasMoreTokens()) {
                map.put(tokens.nextToken(), tokens.hasMoreElements() ? tokens.nextToken() : "");
            }
        }
        return map;
    }

    public static String[] toStringArray(String property, String delim, Properties properties) {
        return PropertiesHelper.toStringArray(properties.getProperty(property), delim);
    }

    public static String[] toStringArray(String propValue, String delim) {
        if (propValue != null) {
            return StringHelper.split(delim, propValue);
        }
        return ArrayHelper.EMPTY_STRING_ARRAY;
    }

    public static Properties maskOut(Properties props, String key) {
        Properties clone = (Properties)props.clone();
        if (clone.get(key) != null) {
            clone.setProperty(key, "****");
        }
        return clone;
    }

    public static void resolvePlaceHolders(Properties properties) {
        Iterator<Map.Entry<Object, Object>> itr = properties.entrySet().iterator();
        while (itr.hasNext()) {
            String resolved;
            Map.Entry<Object, Object> entry = itr.next();
            Object value = entry.getValue();
            if (value == null || !String.class.isInstance(value) || value.equals(resolved = PropertiesHelper.resolvePlaceHolder((String)value))) continue;
            if (resolved == null) {
                itr.remove();
                continue;
            }
            entry.setValue(resolved);
        }
    }

    public static String resolvePlaceHolder(String property) {
        String rtn;
        if (property.indexOf(PLACEHOLDER_START) < 0) {
            return property;
        }
        StringBuffer buff = new StringBuffer();
        char[] chars = property.toCharArray();
        for (int pos = 0; pos < chars.length; ++pos) {
            if (chars[pos] == '$' && chars[pos + 1] == '{') {
                int x;
                String systemPropertyName = "";
                for (x = pos + 2; x < chars.length && chars[x] != '}'; ++x) {
                    systemPropertyName = systemPropertyName + chars[x];
                    if (x != chars.length - 1) continue;
                    throw new IllegalArgumentException("unmatched placeholder start [" + property + "]");
                }
                String systemProperty = PropertiesHelper.extractFromSystem(systemPropertyName);
                buff.append(systemProperty == null ? "" : systemProperty);
                pos = x + 1;
                if (pos >= chars.length) break;
            }
            buff.append(chars[pos]);
        }
        return StringHelper.isEmpty(rtn = buff.toString()) ? null : rtn;
    }

    private static String extractFromSystem(String systemPropertyName) {
        try {
            return System.getProperty(systemPropertyName);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private PropertiesHelper() {
    }
}

