/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionRecreateAction;
import org.hibernate.action.CollectionRemoveAction;
import org.hibernate.action.CollectionUpdateAction;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.ActionQueue;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.Collections;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.EventSource;
import org.hibernate.event.FlushEntityEvent;
import org.hibernate.event.FlushEntityEventListener;
import org.hibernate.event.FlushEvent;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.Printer;
import org.hibernate.util.IdentityMap;
import org.hibernate.util.LazyIterator;

public abstract class AbstractFlushingEventListener
implements Serializable {
    private static final Log log = LogFactory.getLog(AbstractFlushingEventListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushEverythingToExecutions(FlushEvent event) throws HibernateException {
        log.trace((Object)"flushing session");
        EventSource session = event.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        session.getInterceptor().preFlush(new LazyIterator(persistenceContext.getEntitiesByKey()));
        this.prepareEntityFlushes(session);
        this.prepareCollectionFlushes(session);
        persistenceContext.setFlushing(true);
        try {
            this.flushEntities(event);
            this.flushCollections(session);
        }
        finally {
            persistenceContext.setFlushing(false);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Flushed: " + session.getActionQueue().numberOfInsertions() + " insertions, " + session.getActionQueue().numberOfUpdates() + " updates, " + session.getActionQueue().numberOfDeletions() + " deletions to " + persistenceContext.getEntityEntries().size() + " objects"));
            log.debug((Object)("Flushed: " + session.getActionQueue().numberOfCollectionCreations() + " (re)creations, " + session.getActionQueue().numberOfCollectionUpdates() + " updates, " + session.getActionQueue().numberOfCollectionRemovals() + " removals to " + persistenceContext.getCollectionEntries().size() + " collections"));
            new Printer(session.getFactory()).toString(persistenceContext.getEntitiesByKey().values().iterator(), session.getEntityMode());
        }
    }

    private void prepareEntityFlushes(EventSource session) throws HibernateException {
        log.debug((Object)"processing flush-time cascades");
        Map.Entry[] list = IdentityMap.concurrentEntries(session.getPersistenceContext().getEntityEntries());
        int size = list.length;
        Object anything = this.getAnything();
        for (int i = 0; i < size; ++i) {
            Map.Entry me = list[i];
            EntityEntry entry = (EntityEntry)me.getValue();
            Status status = entry.getStatus();
            if (status != Status.MANAGED && status != Status.SAVING) continue;
            this.cascadeOnFlush(session, entry.getPersister(), me.getKey(), anything);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeOnFlush(EventSource session, EntityPersister persister, Object object, Object anything) throws HibernateException {
        session.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadingAction(), 0, session).cascade(persister, object, anything);
        }
        finally {
            session.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected Object getAnything() {
        return null;
    }

    protected CascadingAction getCascadingAction() {
        return CascadingAction.SAVE_UPDATE;
    }

    private void prepareCollectionFlushes(SessionImplementor session) throws HibernateException {
        log.debug((Object)"dirty checking collections");
        List list = IdentityMap.entries(session.getPersistenceContext().getCollectionEntries());
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map.Entry e = (Map.Entry)list.get(i);
            ((CollectionEntry)e.getValue()).preFlush((PersistentCollection)e.getKey());
        }
    }

    private void flushEntities(FlushEvent event) throws HibernateException {
        log.trace((Object)"Flushing entities and processing referenced collections");
        EventSource source = event.getSession();
        for (Map.Entry me : IdentityMap.concurrentEntries(source.getPersistenceContext().getEntityEntries())) {
            EntityEntry entry = (EntityEntry)me.getValue();
            Status status = entry.getStatus();
            if (status == Status.LOADING || status == Status.GONE) continue;
            FlushEntityEvent entityEvent = new FlushEntityEvent(source, me.getKey(), entry);
            FlushEntityEventListener[] listeners = source.getListeners().getFlushEntityEventListeners();
            for (int j = 0; j < listeners.length; ++j) {
                listeners[j].onFlushEntity(entityEvent);
            }
        }
        source.getActionQueue().sortActions();
    }

    private void flushCollections(EventSource session) throws HibernateException {
        log.trace((Object)"Processing unreferenced collections");
        List list = IdentityMap.entries(session.getPersistenceContext().getCollectionEntries());
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map.Entry me = (Map.Entry)list.get(i);
            CollectionEntry ce = (CollectionEntry)me.getValue();
            if (ce.isReached() || ce.isIgnore()) continue;
            Collections.processUnreachableCollection((PersistentCollection)me.getKey(), session);
        }
        log.trace((Object)"Scheduling collection removes/(re)creates/updates");
        list = IdentityMap.entries(session.getPersistenceContext().getCollectionEntries());
        size = list.size();
        ActionQueue actionQueue = session.getActionQueue();
        for (int i = 0; i < size; ++i) {
            Map.Entry me = (Map.Entry)list.get(i);
            PersistentCollection coll = (PersistentCollection)me.getKey();
            CollectionEntry ce = (CollectionEntry)me.getValue();
            if (ce.isDorecreate()) {
                session.getInterceptor().onCollectionRecreate(coll, ce.getCurrentKey());
                actionQueue.addAction(new CollectionRecreateAction(coll, ce.getCurrentPersister(), ce.getCurrentKey(), (SessionImplementor)session));
            }
            if (ce.isDoremove()) {
                session.getInterceptor().onCollectionRemove(coll, ce.getLoadedKey());
                actionQueue.addAction(new CollectionRemoveAction(coll, ce.getLoadedPersister(), ce.getLoadedKey(), ce.isSnapshotEmpty(coll), (SessionImplementor)session));
            }
            if (!ce.isDoupdate()) continue;
            session.getInterceptor().onCollectionUpdate(coll, ce.getLoadedKey());
            actionQueue.addAction(new CollectionUpdateAction(coll, ce.getLoadedPersister(), ce.getLoadedKey(), ce.isSnapshotEmpty(coll), session));
        }
        actionQueue.sortCollectionActions();
    }

    protected void performExecutions(EventSource session) throws HibernateException {
        log.trace((Object)"executing flush");
        try {
            session.getJDBCContext().getConnectionManager().flushBeginning();
            session.getActionQueue().prepareActions();
            session.getActionQueue().executeActions();
        }
        catch (HibernateException he) {
            log.error((Object)"Could not synchronize database state with session", (Throwable)he);
            throw he;
        }
        finally {
            session.getJDBCContext().getConnectionManager().flushEnding();
        }
    }

    protected void postFlush(SessionImplementor session) throws HibernateException {
        log.trace((Object)"post flush");
        PersistenceContext persistenceContext = session.getPersistenceContext();
        persistenceContext.getCollectionsByKey().clear();
        persistenceContext.getBatchFetchQueue().clearSubselects();
        for (Map.Entry me : persistenceContext.getCollectionEntries().entrySet()) {
            CollectionEntry collectionEntry = (CollectionEntry)me.getValue();
            PersistentCollection persistentCollection = (PersistentCollection)me.getKey();
            collectionEntry.postFlush(persistentCollection);
            if (collectionEntry.getLoadedPersister() == null) {
                persistenceContext.getCollectionEntries().remove(persistentCollection);
                continue;
            }
            CollectionKey collectionKey = new CollectionKey(collectionEntry.getLoadedPersister(), collectionEntry.getLoadedKey(), session.getEntityMode());
            persistenceContext.getCollectionsByKey().put(collectionKey, persistentCollection);
        }
        session.getInterceptor().postFlush(new LazyIterator(persistenceContext.getEntitiesByKey()));
    }
}

