/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.cglib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.ProtectionDomain;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.AbstractClassTransformerImpl;
import org.hibernate.bytecode.util.ClassFilter;
import org.hibernate.bytecode.util.FieldFilter;
import org.hibernate.repackage.cglib.asm.Attribute;
import org.hibernate.repackage.cglib.asm.ClassReader;
import org.hibernate.repackage.cglib.asm.ClassWriter;
import org.hibernate.repackage.cglib.asm.Type;
import org.hibernate.repackage.cglib.asm.attrs.Attributes;
import org.hibernate.repackage.cglib.core.ClassNameReader;
import org.hibernate.repackage.cglib.core.DebuggingClassWriter;
import org.hibernate.repackage.cglib.transform.ClassReaderGenerator;
import org.hibernate.repackage.cglib.transform.ClassTransformer;
import org.hibernate.repackage.cglib.transform.TransformingClassGenerator;
import org.hibernate.repackage.cglib.transform.impl.InterceptFieldFilter;
import org.hibernate.repackage.cglib.transform.impl.InterceptFieldTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CglibClassTransformer
extends AbstractClassTransformerImpl {
    private static Logger log = LoggerFactory.getLogger((String)CglibClassTransformer.class.getName());
    static /* synthetic */ Class class$org$hibernate$repackage$cglib$transform$impl$InterceptFieldEnabled;

    public CglibClassTransformer(ClassFilter classFilter, FieldFilter fieldFilter) {
        super(classFilter, fieldFilter);
    }

    protected byte[] doTransform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        ClassReader reader;
        try {
            reader = new ClassReader(new ByteArrayInputStream(classfileBuffer));
        }
        catch (IOException e) {
            log.error("Unable to read class", (Throwable)e);
            throw new HibernateException("Unable to read class: " + e.getMessage());
        }
        String[] names = ClassNameReader.getClassInfo(reader);
        DebuggingClassWriter w = new DebuggingClassWriter(true);
        ClassTransformer t = this.getClassTransformer(names);
        if (t != null) {
            byte[] result;
            if (log.isDebugEnabled()) {
                log.debug("Enhancing " + className);
            }
            try {
                reader = new ClassReader(new ByteArrayInputStream(classfileBuffer));
                new TransformingClassGenerator(new ClassReaderGenerator(reader, this.attributes(), this.skipDebug()), t).generateClass(w);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                out.write(((ClassWriter)w).toByteArray());
                result = out.toByteArray();
                out.close();
            }
            catch (Exception e) {
                log.error("Unable to transform class", (Throwable)e);
                throw new HibernateException("Unable to transform class: " + e.getMessage());
            }
            return result;
        }
        return classfileBuffer;
    }

    private Attribute[] attributes() {
        return Attributes.getDefaultAttributes();
    }

    private boolean skipDebug() {
        return false;
    }

    private ClassTransformer getClassTransformer(final String[] classInfo) {
        if (this.isAlreadyInstrumented(classInfo)) {
            return null;
        }
        return new InterceptFieldTransformer(new InterceptFieldFilter(){

            public boolean acceptRead(Type owner, String name) {
                return CglibClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classInfo[0], owner.getClassName(), name);
            }

            public boolean acceptWrite(Type owner, String name) {
                return CglibClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classInfo[0], owner.getClassName(), name);
            }
        });
    }

    private boolean isAlreadyInstrumented(String[] classInfo) {
        for (int i = 1; i < classInfo.length; ++i) {
            if (!(class$org$hibernate$repackage$cglib$transform$impl$InterceptFieldEnabled == null ? CglibClassTransformer.class$("org.hibernate.repackage.cglib.transform.impl.InterceptFieldEnabled") : class$org$hibernate$repackage$cglib$transform$impl$InterceptFieldEnabled).getName().equals(classInfo[i])) continue;
            return true;
        }
        return false;
    }
}

