/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc2.access;

import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.jbc2.TransactionalDataRegionAdapter;
import org.hibernate.cache.jbc2.access.TransactionalAccessDelegate;
import org.hibernate.cache.jbc2.util.CacheHelper;
import org.hibernate.cache.jbc2.util.DataVersionAdapter;
import org.hibernate.cache.jbc2.util.NonLockingDataVersion;
import org.jboss.cache.config.Option;
import org.jboss.cache.optimistic.DataVersion;

public class OptimisticTransactionalAccessDelegate
extends TransactionalAccessDelegate {
    protected final CacheDataDescription dataDescription;

    public OptimisticTransactionalAccessDelegate(TransactionalDataRegionAdapter region) {
        super(region);
        this.dataDescription = region.getCacheDataDescription();
    }

    public void evict(Object key) throws CacheException {
        this.region.ensureRegionRootExists();
        Option opt = NonLockingDataVersion.getInvocationOption();
        CacheHelper.remove(this.cache, this.regionFqn, key, opt);
    }

    public void evictAll() throws CacheException {
        this.evictOrRemoveAll();
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        this.region.ensureRegionRootExists();
        return CacheHelper.get(this.cache, this.regionFqn, key);
    }

    public boolean insert(Object key, Object value, Object version) throws CacheException {
        this.region.ensureRegionRootExists();
        Option opt = this.getDataVersionOption(version, null);
        CacheHelper.put(this.cache, this.regionFqn, key, value, opt);
        return true;
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        this.region.ensureRegionRootExists();
        Option opt = this.getDataVersionOption(version, version);
        return CacheHelper.putForExternalRead(this.cache, this.regionFqn, key, value, opt);
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) throws CacheException {
        this.region.ensureRegionRootExists();
        Option opt = this.getDataVersionOption(version, version);
        return CacheHelper.putForExternalRead(this.cache, this.regionFqn, key, value, opt);
    }

    public void remove(Object key) throws CacheException {
        this.region.ensureRegionRootExists();
        Option opt = NonLockingDataVersion.getInvocationOption();
        CacheHelper.remove(this.cache, this.regionFqn, key, opt);
    }

    public void removeAll() throws CacheException {
        this.evictOrRemoveAll();
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        this.region.ensureRegionRootExists();
        Option opt = this.getDataVersionOption(currentVersion, previousVersion);
        CacheHelper.put(this.cache, this.regionFqn, key, value, opt);
        return true;
    }

    private Option getDataVersionOption(Object currentVersion, Object previousVersion) {
        DataVersion dv = this.dataDescription != null && this.dataDescription.isVersioned() ? new DataVersionAdapter(currentVersion, previousVersion, this.dataDescription.getVersionComparator(), this.dataDescription.toString()) : NonLockingDataVersion.INSTANCE;
        Option opt = new Option();
        opt.setDataVersion(dv);
        return opt;
    }

    private void evictOrRemoveAll() {
        Option opt = NonLockingDataVersion.getInvocationOption();
        CacheHelper.removeAll(this.cache, this.regionFqn, opt);
    }
}

