/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.embedded.api;

import org.jboss.embedded.api.server.JBossASEmbeddedServer;

/**
 * DeploymentException
 *
 * Indicates a problem encountered during deployment to the target 
 * {@link JBossASEmbeddedServer}.  The underlying error may be obtained via 
 * {@link DeploymentException#getCause()}.
 *
 * @author <a href="mailto:andrew.rubinger@jboss.org">ALR</a>
 * @version $Revision: $
 */
public class DeploymentException extends Exception
{
   //-------------------------------------------------------------------------------------||
   // Class Members ----------------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /**
    * serialVersionUID
    */
   private static final long serialVersionUID = 1L;

   //-------------------------------------------------------------------------------------||
   // Constructors -----------------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /**
    * Constructs a new {@link DeploymentException} using the specified
    * message and cause
    * 
    * @param message
    * @param cause
    * @throws IllegalArgumentException If the cause is not specified
    */
   public DeploymentException(final String message, final Throwable cause)
   {
      super(message, cause);

      // Perform assertions
      this.assertCause(cause);
   }

   /**
    * Constructs a new {@link DeploymentException} using the specified
    * cause
    * 
    * @param cause
    * @throws IllegalArgumentException If the cause is not specified
    */
   public DeploymentException(final Throwable cause)
   {
      super(cause);

      // Perform assertions
      this.assertCause(cause);
   }

   //-------------------------------------------------------------------------------------||
   // Internal Helper Methods ------------------------------------------------------------||
   //-------------------------------------------------------------------------------------||

   /**
    * Ensures that a cause is specified, else throws
    * {@link IllegalArgumentException}
    */
   private void assertCause(final Throwable cause)
   {
      if (cause == null)
      {
         throw new IllegalArgumentException("Cause must be specified");
      }
   }
}
