/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.jta;

import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;

public class UserTransactionHelper {
    public static final String DEFAULT_USER_TX_LOCATION = "java:comp/UserTransaction";
    private InitialContext ctxt;
    private UserTransaction ut;
    private String userTxURL;

    public UserTransactionHelper(String userTxURL) throws SchedulerConfigException {
        try {
            this.ctxt = new InitialContext();
        }
        catch (Exception e) {
            throw new SchedulerConfigException("JTAJobRunShellFactory initialization failed.", e);
        }
        this.setUserTxLocation(userTxURL);
    }

    public String getUserTxLocation() {
        return this.userTxURL;
    }

    public void setUserTxLocation(String userTxURL) {
        if (userTxURL == null) {
            userTxURL = DEFAULT_USER_TX_LOCATION;
        }
        this.userTxURL = userTxURL;
    }

    public UserTransaction lookup() throws SchedulerException {
        try {
            return (UserTransaction)this.ctxt.lookup(this.userTxURL);
        }
        catch (Exception nse) {
            throw new SchedulerException("UserTransactionHelper could not lookup/create UserTransaction.", nse);
        }
    }
}

