/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.calendar;

import java.io.Serializable;
import java.util.Date;
import org.quartz.Calendar;

public class BaseCalendar
implements Calendar,
Serializable {
    private Calendar baseCalendar;
    private String description;

    public BaseCalendar() {
    }

    public BaseCalendar(Calendar baseCalendar) {
        this.setBaseCalendar(baseCalendar);
    }

    public void setBaseCalendar(Calendar baseCalendar) {
        this.baseCalendar = baseCalendar;
    }

    public Calendar getBaseCalendar() {
        return this.baseCalendar;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isTimeIncluded(long timeStamp) {
        if (timeStamp <= 0L) {
            throw new IllegalArgumentException("timeStamp must be greater 0");
        }
        return this.baseCalendar == null || this.baseCalendar.isTimeIncluded(timeStamp);
    }

    public long getNextIncludedTime(long timeStamp) {
        if (timeStamp <= 0L) {
            throw new IllegalArgumentException("timeStamp must be greater 0");
        }
        if (this.baseCalendar != null) {
            return this.baseCalendar.getNextIncludedTime(timeStamp);
        }
        return timeStamp;
    }

    public static Date buildHoliday(Date excludedDate) {
        java.util.Calendar cl = java.util.Calendar.getInstance();
        java.util.Calendar clEx = java.util.Calendar.getInstance();
        clEx.setTime(excludedDate);
        cl.setLenient(false);
        cl.clear();
        cl.set(clEx.get(1), clEx.get(2), clEx.get(5));
        return cl.getTime();
    }

    public static long buildHoliday(long timeStamp) {
        return BaseCalendar.buildHoliday(new Date(timeStamp)).getTime();
    }

    public static java.util.Calendar getJavaCalendar(long timeStamp) {
        java.util.Calendar cl = java.util.Calendar.getInstance();
        cl.setTime(new Date(timeStamp));
        return cl;
    }
}

