/*    */ package EDU.oswego.cs.dl.util.concurrent;
/*    */ 
/*    */ public class PrioritySemaphore extends QueuedSemaphore
/*    */ {
/*    */   public PrioritySemaphore(long initialPermits)
/*    */   {
/* 43 */     super(new PriorityWaitQueue(), initialPermits);
/*    */   }
/*    */ 
/*    */   protected static class PriorityWaitQueue extends QueuedSemaphore.WaitQueue
/*    */   {
/* 51 */     protected final FIFOSemaphore.FIFOWaitQueue[] cells_ = new FIFOSemaphore.FIFOWaitQueue[10];
/*    */ 
/* 59 */     protected int maxIndex_ = -1;
/*    */ 
/*    */     protected PriorityWaitQueue() {
/* 62 */       for (int i = 0; i < this.cells_.length; i++)
/* 63 */         this.cells_[i] = new FIFOSemaphore.FIFOWaitQueue();
/*    */     }
/*    */ 
/*    */     protected void insert(QueuedSemaphore.WaitQueue.WaitNode w) {
/* 67 */       int idx = Thread.currentThread().getPriority() - 1;
/* 68 */       this.cells_[idx].insert(w);
/* 69 */       if (idx > this.maxIndex_) this.maxIndex_ = idx; 
/*    */     }
/*    */ 
/*    */     protected QueuedSemaphore.WaitQueue.WaitNode extract()
/*    */     {
/*    */       while (true) {
/* 74 */         int idx = this.maxIndex_;
/* 75 */         if (idx < 0)
/* 76 */           return null;
/* 77 */         QueuedSemaphore.WaitQueue.WaitNode w = this.cells_[idx].extract();
/* 78 */         if (w != null) {
/* 79 */           return w;
/*    */         }
/* 81 */         this.maxIndex_ -= 1;
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.PrioritySemaphore
 * JD-Core Version:    0.6.0
 */