/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class ReentrantLock
/*     */   implements Sync
/*     */ {
/*  29 */   protected Thread owner_ = null;
/*  30 */   protected long holds_ = 0L;
/*     */ 
/*     */   public void acquire() throws InterruptedException {
/*  33 */     if (Thread.interrupted()) throw new InterruptedException();
/*  34 */     Thread caller = Thread.currentThread();
/*  35 */     synchronized (this) {
/*  36 */       if (caller == this.owner_)
/*  37 */         this.holds_ += 1L;
/*     */       else
/*     */         try {
/*     */           do wait(); while (this.owner_ != null);
/*  41 */           this.owner_ = caller;
/*  42 */           this.holds_ = 1L;
/*     */         }
/*     */         catch (InterruptedException ex) {
/*  45 */           notify();
/*  46 */           throw ex;
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean attempt(long msecs)
/*     */     throws InterruptedException
/*     */   {
/*  54 */     if (Thread.interrupted()) throw new InterruptedException();
/*  55 */     Thread caller = Thread.currentThread();
/*  56 */     synchronized (this) {
/*  57 */       if (caller == this.owner_) {
/*  58 */         this.holds_ += 1L;
/*  59 */         return true;
/*     */       }
/*  61 */       if (this.owner_ == null) {
/*  62 */         this.owner_ = caller;
/*  63 */         this.holds_ = 1L;
/*  64 */         return true;
/*     */       }
/*  66 */       if (msecs <= 0L) {
/*  67 */         return false;
/*     */       }
/*  69 */       long waitTime = msecs;
/*  70 */       long start = System.currentTimeMillis();
/*     */       try {
/*     */         do {
/*  73 */           wait(waitTime);
/*  74 */           if (caller == this.owner_) {
/*  75 */             this.holds_ += 1L;
/*  76 */             return true;
/*     */           }
/*  78 */           if (this.owner_ == null) {
/*  79 */             this.owner_ = caller;
/*  80 */             this.holds_ = 1L;
/*  81 */             return true;
/*     */           }
/*     */ 
/*  84 */           waitTime = msecs - (System.currentTimeMillis() - start);
/*  85 */         }while (waitTime > 0L);
/*  86 */         return false;
/*     */       }
/*     */       catch (InterruptedException ex)
/*     */       {
/*  91 */         notify();
/*  92 */         throw ex;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void release()
/*     */   {
/* 103 */     if (Thread.currentThread() != this.owner_) {
/* 104 */       throw new Error("Illegal Lock usage");
/*     */     }
/* 106 */     if (--this.holds_ == 0L) {
/* 107 */       this.owner_ = null;
/* 108 */       notify();
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void release(long n)
/*     */   {
/* 123 */     if ((Thread.currentThread() != this.owner_) || (n > this.holds_)) {
/* 124 */       throw new Error("Illegal Lock usage");
/*     */     }
/* 126 */     this.holds_ -= n;
/* 127 */     if (this.holds_ == 0L) {
/* 128 */       this.owner_ = null;
/* 129 */       notify();
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized long holds()
/*     */   {
/* 140 */     if (Thread.currentThread() != this.owner_) return 0L;
/* 141 */     return this.holds_;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.ReentrantLock
 * JD-Core Version:    0.6.0
 */