/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ 
/*     */ public abstract class SemaphoreControlledChannel
/*     */   implements BoundedChannel
/*     */ {
/*     */   protected final Semaphore putGuard_;
/*     */   protected final Semaphore takeGuard_;
/*     */   protected int capacity_;
/*     */ 
/*     */   public SemaphoreControlledChannel(int capacity)
/*     */     throws IllegalArgumentException
/*     */   {
/*  38 */     if (capacity <= 0) throw new IllegalArgumentException();
/*  39 */     this.capacity_ = capacity;
/*  40 */     this.putGuard_ = new Semaphore(capacity);
/*  41 */     this.takeGuard_ = new Semaphore(0L);
/*     */   }
/*     */ 
/*     */   public SemaphoreControlledChannel(int capacity, Class semaphoreClass)
/*     */     throws IllegalArgumentException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException
/*     */   {
/*  65 */     if (capacity <= 0) throw new IllegalArgumentException();
/*  66 */     this.capacity_ = capacity;
/*  67 */     Class[] longarg = { Long.TYPE };
/*  68 */     Constructor ctor = semaphoreClass.getDeclaredConstructor(longarg);
/*  69 */     Long[] cap = { new Long(capacity) };
/*  70 */     this.putGuard_ = ((Semaphore)ctor.newInstance(cap));
/*  71 */     Long[] zero = { new Long(0L) };
/*  72 */     this.takeGuard_ = ((Semaphore)ctor.newInstance(zero));
/*     */   }
/*     */ 
/*     */   public int capacity()
/*     */   {
/*  77 */     return this.capacity_;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/*  85 */     return (int)this.takeGuard_.permits();
/*     */   }
/*     */ 
/*     */   protected abstract void insert(Object paramObject);
/*     */ 
/*     */   protected abstract Object extract();
/*     */ 
/*     */   public void put(Object x)
/*     */     throws InterruptedException
/*     */   {
/*  98 */     if (x == null) throw new IllegalArgumentException();
/*  99 */     if (Thread.interrupted()) throw new InterruptedException();
/* 100 */     this.putGuard_.acquire();
/*     */     try {
/* 102 */       insert(x);
/* 103 */       this.takeGuard_.release();
/*     */     }
/*     */     catch (ClassCastException ex) {
/* 106 */       this.putGuard_.release();
/* 107 */       throw ex;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean offer(Object x, long msecs) throws InterruptedException {
/* 112 */     if (x == null) throw new IllegalArgumentException();
/* 113 */     if (Thread.interrupted()) throw new InterruptedException();
/* 114 */     if (!this.putGuard_.attempt(msecs))
/* 115 */       return false;
/*     */     try
/*     */     {
/* 118 */       insert(x);
/* 119 */       this.takeGuard_.release();
/* 120 */       return true;
/*     */     }
/*     */     catch (ClassCastException ex) {
/* 123 */       this.putGuard_.release();
/* 124 */     }throw ex;
/*     */   }
/*     */ 
/*     */   public Object take()
/*     */     throws InterruptedException
/*     */   {
/* 130 */     if (Thread.interrupted()) throw new InterruptedException();
/* 131 */     this.takeGuard_.acquire();
/*     */     try {
/* 133 */       Object x = extract();
/* 134 */       this.putGuard_.release();
/* 135 */       return x;
/*     */     }
/*     */     catch (ClassCastException ex) {
/* 138 */       this.takeGuard_.release();
/* 139 */     }throw ex;
/*     */   }
/*     */ 
/*     */   public Object poll(long msecs) throws InterruptedException
/*     */   {
/* 144 */     if (Thread.interrupted()) throw new InterruptedException();
/* 145 */     if (!this.takeGuard_.attempt(msecs))
/* 146 */       return null;
/*     */     try
/*     */     {
/* 149 */       Object x = extract();
/* 150 */       this.putGuard_.release();
/* 151 */       return x;
/*     */     }
/*     */     catch (ClassCastException ex) {
/* 154 */       this.takeGuard_.release();
/* 155 */     }throw ex;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.SemaphoreControlledChannel
 * JD-Core Version:    0.6.0
 */