/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class SyncMap
/*     */   implements Map
/*     */ {
/*     */   protected final Map c_;
/*     */   protected final Sync rd_;
/*     */   protected final Sync wr_;
/*  50 */   protected final SynchronizedLong syncFailures_ = new SynchronizedLong(0L);
/*     */ 
/* 264 */   private transient Set keySet_ = null;
/* 265 */   private transient Set entrySet_ = null;
/* 266 */   private transient Collection values_ = null;
/*     */ 
/*     */   public SyncMap(Map map, Sync sync)
/*     */   {
/*  59 */     this(map, sync, sync);
/*     */   }
/*     */ 
/*     */   public SyncMap(Map map, ReadWriteLock rwl)
/*     */   {
/*  68 */     this(map, rwl.readLock(), rwl.writeLock());
/*     */   }
/*     */ 
/*     */   public SyncMap(Map map, Sync readLock, Sync writeLock)
/*     */   {
/*  76 */     this.c_ = map;
/*  77 */     this.rd_ = readLock;
/*  78 */     this.wr_ = writeLock;
/*     */   }
/*     */ 
/*     */   public Sync readerSync()
/*     */   {
/*  86 */     return this.rd_;
/*     */   }
/*     */ 
/*     */   public Sync writerSync()
/*     */   {
/*  94 */     return this.wr_;
/*     */   }
/*     */ 
/*     */   public long syncFailures()
/*     */   {
/* 101 */     return this.syncFailures_.get();
/*     */   }
/*     */ 
/*     */   protected boolean beforeRead()
/*     */   {
/*     */     try
/*     */     {
/* 108 */       this.rd_.acquire();
/* 109 */       return false;
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 112 */       this.syncFailures_.increment();
/* 113 */     }return true;
/*     */   }
/*     */ 
/*     */   protected void afterRead(boolean wasInterrupted)
/*     */   {
/* 119 */     if (wasInterrupted) {
/* 120 */       Thread.currentThread().interrupt();
/*     */     }
/*     */     else
/* 123 */       this.rd_.release();
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 129 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 131 */       int i = this.c_.hashCode();
/*     */       return i;
/*     */     }
/*     */     finally {
/* 134 */       afterRead(wasInterrupted);
/* 135 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o) {
/* 139 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 141 */       boolean bool1 = this.c_.equals(o);
/*     */       return bool1;
/*     */     }
/*     */     finally {
/* 144 */       afterRead(wasInterrupted);
/* 145 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public int size() {
/* 149 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 151 */       int i = this.c_.size();
/*     */       return i;
/*     */     }
/*     */     finally {
/* 154 */       afterRead(wasInterrupted);
/* 155 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty() {
/* 159 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 161 */       boolean bool1 = this.c_.isEmpty();
/*     */       return bool1;
/*     */     }
/*     */     finally {
/* 164 */       afterRead(wasInterrupted);
/* 165 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object o) {
/* 169 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 171 */       boolean bool1 = this.c_.containsKey(o);
/*     */       return bool1;
/*     */     }
/*     */     finally {
/* 174 */       afterRead(wasInterrupted);
/* 175 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public boolean containsValue(Object o) {
/* 179 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 181 */       boolean bool1 = this.c_.containsValue(o);
/*     */       return bool1;
/*     */     }
/*     */     finally {
/* 184 */       afterRead(wasInterrupted);
/* 185 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public Object get(Object key) {
/* 189 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 191 */       Object localObject2 = this.c_.get(key);
/*     */       return localObject2;
/*     */     }
/*     */     finally {
/* 194 */       afterRead(wasInterrupted);
/* 195 */     }throw localObject1;
/*     */   }
/*     */ 
/*     */   public Object put(Object key, Object value)
/*     */   {
/*     */     try {
/* 201 */       this.wr_.acquire();
/*     */       try {
/* 203 */         Object localObject2 = this.c_.put(key, value);
/*     */         return localObject2;
/*     */       }
/*     */       finally {
/* 206 */         this.wr_.release();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 210 */       Thread.currentThread().interrupt();
/* 211 */     }throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public Object remove(Object key)
/*     */   {
/*     */     try {
/* 217 */       this.wr_.acquire();
/*     */       try {
/* 219 */         Object localObject2 = this.c_.remove(key);
/*     */         return localObject2;
/*     */       }
/*     */       finally {
/* 222 */         this.wr_.release();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 226 */       Thread.currentThread().interrupt();
/* 227 */     }throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void putAll(Map coll)
/*     */   {
/*     */     try {
/* 233 */       this.wr_.acquire();
/*     */       try {
/* 235 */         this.c_.putAll(coll);
/*     */       }
/*     */       finally {
/* 238 */         this.wr_.release();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 242 */       Thread.currentThread().interrupt();
/* 243 */       throw new UnsupportedOperationException();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*     */     try {
/* 250 */       this.wr_.acquire();
/*     */       try {
/* 252 */         this.c_.clear();
/*     */       }
/*     */       finally {
/* 255 */         this.wr_.release();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ex) {
/* 259 */       Thread.currentThread().interrupt();
/* 260 */       throw new UnsupportedOperationException();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Set keySet()
/*     */   {
/* 269 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 271 */       if (this.keySet_ == null)
/* 272 */         this.keySet_ = new SyncSet(this.c_.keySet(), this.rd_, this.wr_);
/* 273 */       Set localSet = this.keySet_;
/*     */       return localSet;
/*     */     }
/*     */     finally {
/* 276 */       afterRead(wasInterrupted);
/* 277 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public Set entrySet() {
/* 281 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 283 */       if (this.entrySet_ == null)
/* 284 */         this.entrySet_ = new SyncSet(this.c_.entrySet(), this.rd_, this.wr_);
/* 285 */       Set localSet = this.entrySet_;
/*     */       return localSet;
/*     */     }
/*     */     finally {
/* 288 */       afterRead(wasInterrupted);
/* 289 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public Collection values()
/*     */   {
/* 294 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 296 */       if (this.values_ == null)
/* 297 */         this.values_ = new SyncCollection(this.c_.values(), this.rd_, this.wr_);
/* 298 */       Collection localCollection = this.values_;
/*     */       return localCollection;
/*     */     }
/*     */     finally {
/* 301 */       afterRead(wasInterrupted);
/* 302 */     }throw localObject;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.SyncMap
 * JD-Core Version:    0.6.0
 */