/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ import java.util.Comparator;
/*     */ import java.util.SortedMap;
/*     */ 
/*     */ public class SyncSortedMap extends SyncMap
/*     */   implements SortedMap
/*     */ {
/*     */   public SyncSortedMap(SortedMap map, Sync sync)
/*     */   {
/*  35 */     this(map, sync, sync);
/*     */   }
/*     */ 
/*     */   public SyncSortedMap(SortedMap map, ReadWriteLock rwl)
/*     */   {
/*  43 */     super(map, rwl.readLock(), rwl.writeLock());
/*     */   }
/*     */ 
/*     */   public SyncSortedMap(SortedMap map, Sync readLock, Sync writeLock)
/*     */   {
/*  51 */     super(map, readLock, writeLock);
/*     */   }
/*     */ 
/*     */   protected SortedMap baseSortedMap()
/*     */   {
/*  56 */     return (SortedMap)this.c_;
/*     */   }
/*     */ 
/*     */   public Comparator comparator() {
/*  60 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/*  62 */       Comparator localComparator = baseSortedMap().comparator();
/*     */       return localComparator;
/*     */     }
/*     */     finally {
/*  65 */       afterRead(wasInterrupted);
/*  66 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public Object firstKey() {
/*  70 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/*  72 */       Object localObject2 = baseSortedMap().firstKey();
/*     */       return localObject2;
/*     */     }
/*     */     finally {
/*  75 */       afterRead(wasInterrupted);
/*  76 */     }throw localObject1;
/*     */   }
/*     */ 
/*     */   public Object lastKey() {
/*  80 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/*  82 */       Object localObject2 = baseSortedMap().lastKey();
/*     */       return localObject2;
/*     */     }
/*     */     finally {
/*  85 */       afterRead(wasInterrupted);
/*  86 */     }throw localObject1;
/*     */   }
/*     */ 
/*     */   public SortedMap subMap(Object fromElement, Object toElement)
/*     */   {
/*  91 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/*  93 */       SyncSortedMap localSyncSortedMap = new SyncSortedMap(baseSortedMap().subMap(fromElement, toElement), 
/*  94 */         this.rd_, this.wr_);
/*     */       return localSyncSortedMap;
/*     */     }
/*     */     finally
/*     */     {
/*  97 */       afterRead(wasInterrupted);
/*  98 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public SortedMap headMap(Object toElement) {
/* 102 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 104 */       SyncSortedMap localSyncSortedMap = new SyncSortedMap(baseSortedMap().headMap(toElement), 
/* 105 */         this.rd_, this.wr_);
/*     */       return localSyncSortedMap;
/*     */     }
/*     */     finally
/*     */     {
/* 108 */       afterRead(wasInterrupted);
/* 109 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public SortedMap tailMap(Object fromElement) {
/* 113 */     boolean wasInterrupted = beforeRead();
/*     */     try {
/* 115 */       SyncSortedMap localSyncSortedMap = new SyncSortedMap(baseSortedMap().tailMap(fromElement), 
/* 116 */         this.rd_, this.wr_);
/*     */       return localSyncSortedMap;
/*     */     }
/*     */     finally
/*     */     {
/* 119 */       afterRead(wasInterrupted);
/* 120 */     }throw localObject;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.SyncSortedMap
 * JD-Core Version:    0.6.0
 */