/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class SynchronizedBoolean extends SynchronizedVariable
/*     */   implements Comparable, Cloneable
/*     */ {
/*     */   protected boolean value_;
/*     */ 
/*     */   public SynchronizedBoolean(boolean initialValue)
/*     */   {
/*  31 */     this.value_ = initialValue;
/*     */   }
/*     */ 
/*     */   public SynchronizedBoolean(boolean initialValue, Object lock)
/*     */   {
/*  39 */     super(lock);
/*  40 */     this.value_ = initialValue;
/*     */   }
/*     */ 
/*     */   public final boolean get()
/*     */   {
/*  46 */     synchronized (this.lock_) { return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean set(boolean newValue)
/*     */   {
/*  54 */     synchronized (this.lock_) {
/*  55 */       boolean old = this.value_;
/*  56 */       this.value_ = newValue;
/*  57 */       return old;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean commit(boolean assumedValue, boolean newValue)
/*     */   {
/*  66 */     synchronized (this.lock_) {
/*  67 */       boolean success = assumedValue == this.value_;
/*  68 */       if (success) this.value_ = newValue;
/*  69 */       return success;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean swap(SynchronizedBoolean other)
/*     */   {
/*  84 */     if (other == this) return get();
/*  85 */     SynchronizedBoolean fst = this;
/*  86 */     SynchronizedBoolean snd = other;
/*  87 */     if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
/*  88 */       fst = other;
/*  89 */       snd = this;
/*     */     }
/*  91 */     synchronized (fst.lock_) {
/*  92 */       synchronized (snd.lock_) {
/*  93 */         fst.set(snd.set(fst.get()));
/*  94 */         return get();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean complement()
/*     */   {
/* 104 */     synchronized (this.lock_) {
/* 105 */       this.value_ = (!this.value_);
/* 106 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean and(boolean b)
/*     */   {
/* 115 */     synchronized (this.lock_) {
/* 116 */       this.value_ &= b;
/* 117 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean or(boolean b)
/*     */   {
/* 126 */     synchronized (this.lock_) {
/* 127 */       this.value_ |= b;
/* 128 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean xor(boolean b)
/*     */   {
/* 138 */     synchronized (this.lock_) {
/* 139 */       this.value_ ^= b;
/* 140 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int compareTo(boolean other)
/*     */   {
/* 146 */     boolean val = get();
/* 147 */     return val ? 1 : val == other ? 0 : -1;
/*     */   }
/*     */ 
/*     */   public int compareTo(SynchronizedBoolean other) {
/* 151 */     return compareTo(other.get());
/*     */   }
/*     */ 
/*     */   public int compareTo(Object other) {
/* 155 */     return compareTo((SynchronizedBoolean)other);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/* 160 */     if ((other != null) && 
/* 161 */       ((other instanceof SynchronizedBoolean))) {
/* 162 */       return get() == ((SynchronizedBoolean)other).get();
/*     */     }
/* 164 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 168 */     boolean b = get();
/* 169 */     return b ? 3412688 : 8319343;
/*     */   }
/*     */   public String toString() {
/* 172 */     return String.valueOf(get());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean
 * JD-Core Version:    0.6.0
 */