/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class SynchronizedLong extends SynchronizedVariable
/*     */   implements Comparable, Cloneable
/*     */ {
/*     */   protected long value_;
/*     */ 
/*     */   public SynchronizedLong(long initialValue)
/*     */   {
/*  34 */     this.value_ = initialValue;
/*     */   }
/*     */ 
/*     */   public SynchronizedLong(long initialValue, Object lock)
/*     */   {
/*  42 */     super(lock);
/*  43 */     this.value_ = initialValue;
/*     */   }
/*     */ 
/*     */   public final long get()
/*     */   {
/*  49 */     synchronized (this.lock_) { return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long set(long newValue)
/*     */   {
/*  57 */     synchronized (this.lock_) {
/*  58 */       long old = this.value_;
/*  59 */       this.value_ = newValue;
/*  60 */       return old;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean commit(long assumedValue, long newValue)
/*     */   {
/*  69 */     synchronized (this.lock_) {
/*  70 */       boolean success = assumedValue == this.value_;
/*  71 */       if (success) this.value_ = newValue;
/*  72 */       return success;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long swap(SynchronizedLong other)
/*     */   {
/*  84 */     if (other == this) return get();
/*  85 */     SynchronizedLong fst = this;
/*  86 */     SynchronizedLong snd = other;
/*  87 */     if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
/*  88 */       fst = other;
/*  89 */       snd = this;
/*     */     }
/*  91 */     synchronized (fst.lock_) {
/*  92 */       synchronized (snd.lock_) {
/*  93 */         fst.set(snd.set(fst.get()));
/*  94 */         return get();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public long increment()
/*     */   {
/* 104 */     synchronized (this.lock_) {
/* 105 */       return ++this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long decrement()
/*     */   {
/* 114 */     synchronized (this.lock_) {
/* 115 */       return --this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long add(long amount)
/*     */   {
/* 124 */     synchronized (this.lock_) {
/* 125 */       return this.value_ += amount;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long subtract(long amount)
/*     */   {
/* 134 */     synchronized (this.lock_) {
/* 135 */       return this.value_ -= amount;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long multiply(long factor)
/*     */   {
/* 144 */     synchronized (this.lock_) {
/* 145 */       return this.value_ *= factor;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long divide(long factor)
/*     */   {
/* 154 */     synchronized (this.lock_) {
/* 155 */       return this.value_ /= factor;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long negate()
/*     */   {
/* 164 */     synchronized (this.lock_) {
/* 165 */       this.value_ = (-this.value_);
/* 166 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long complement()
/*     */   {
/* 175 */     synchronized (this.lock_) {
/* 176 */       this.value_ ^= -1L;
/* 177 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long and(long b)
/*     */   {
/* 186 */     synchronized (this.lock_) {
/* 187 */       this.value_ &= b;
/* 188 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long or(long b)
/*     */   {
/* 197 */     synchronized (this.lock_) {
/* 198 */       this.value_ |= b;
/* 199 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public long xor(long b)
/*     */   {
/* 209 */     synchronized (this.lock_) {
/* 210 */       this.value_ ^= b;
/* 211 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int compareTo(long other)
/*     */   {
/* 217 */     long val = get();
/* 218 */     return val == other ? 0 : val < other ? -1 : 1;
/*     */   }
/*     */ 
/*     */   public int compareTo(SynchronizedLong other) {
/* 222 */     return compareTo(other.get());
/*     */   }
/*     */ 
/*     */   public int compareTo(Object other) {
/* 226 */     return compareTo((SynchronizedLong)other);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other) {
/* 230 */     if ((other != null) && 
/* 231 */       ((other instanceof SynchronizedLong))) {
/* 232 */       return get() == ((SynchronizedLong)other).get();
/*     */     }
/* 234 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 238 */     long v = get();
/* 239 */     return (int)(v ^ v >> 32);
/*     */   }
/*     */   public String toString() {
/* 242 */     return String.valueOf(get());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.SynchronizedLong
 * JD-Core Version:    0.6.0
 */