/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class SynchronizedShort extends SynchronizedVariable
/*     */   implements Comparable, Cloneable
/*     */ {
/*     */   protected short value_;
/*     */ 
/*     */   public SynchronizedShort(short initialValue)
/*     */   {
/*  33 */     this.value_ = initialValue;
/*     */   }
/*     */ 
/*     */   public SynchronizedShort(short initialValue, Object lock)
/*     */   {
/*  41 */     super(lock);
/*  42 */     this.value_ = initialValue;
/*     */   }
/*     */ 
/*     */   public final short get()
/*     */   {
/*  48 */     synchronized (this.lock_) { return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public short set(short newValue)
/*     */   {
/*  56 */     synchronized (this.lock_) {
/*  57 */       short old = this.value_;
/*  58 */       this.value_ = newValue;
/*  59 */       return old;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean commit(short assumedValue, short newValue)
/*     */   {
/*  68 */     synchronized (this.lock_) {
/*  69 */       boolean success = assumedValue == this.value_;
/*  70 */       if (success) this.value_ = newValue;
/*  71 */       return success;
/*     */     }
/*     */   }
/*     */ 
/*     */   public short swap(SynchronizedShort other)
/*     */   {
/*  87 */     if (other == this) return get();
/*  88 */     SynchronizedShort fst = this;
/*  89 */     SynchronizedShort snd = other;
/*  90 */     if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
/*  91 */       fst = other;
/*  92 */       snd = this;
/*     */     }
/*  94 */     synchronized (fst.lock_) {
/*  95 */       synchronized (snd.lock_) {
/*  96 */         fst.set(snd.set(fst.get()));
/*  97 */         return get();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public short increment()
/*     */   {
/* 108 */     synchronized (this.lock_) {
/* 109 */       return this.value_ = (short)(this.value_ + 1);
/*     */     }
/*     */   }
/*     */ 
/*     */   public short decrement()
/*     */   {
/* 118 */     synchronized (this.lock_) {
/* 119 */       return this.value_ = (short)(this.value_ - 1);
/*     */     }
/*     */   }
/*     */ 
/*     */   public short add(short amount)
/*     */   {
/* 128 */     synchronized (this.lock_) {
/* 129 */       return this.value_ = (short)(this.value_ + amount);
/*     */     }
/*     */   }
/*     */ 
/*     */   public short subtract(short amount)
/*     */   {
/* 138 */     synchronized (this.lock_) {
/* 139 */       return this.value_ = (short)(this.value_ - amount);
/*     */     }
/*     */   }
/*     */ 
/*     */   public short multiply(short factor)
/*     */   {
/* 148 */     synchronized (this.lock_) {
/* 149 */       return this.value_ = (short)(this.value_ * factor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public short divide(short factor)
/*     */   {
/* 158 */     synchronized (this.lock_) {
/* 159 */       return this.value_ = (short)(this.value_ / factor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public short negate()
/*     */   {
/* 168 */     synchronized (this.lock_) {
/* 169 */       this.value_ = (short)(-this.value_);
/* 170 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public short complement()
/*     */   {
/* 179 */     synchronized (this.lock_) {
/* 180 */       this.value_ = (short)(this.value_ ^ 0xFFFFFFFF);
/* 181 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public short and(short b)
/*     */   {
/* 190 */     synchronized (this.lock_) {
/* 191 */       this.value_ = (short)(this.value_ & b);
/* 192 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public short or(short b)
/*     */   {
/* 201 */     synchronized (this.lock_) {
/* 202 */       this.value_ = (short)(this.value_ | b);
/* 203 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public short xor(short b)
/*     */   {
/* 213 */     synchronized (this.lock_) {
/* 214 */       this.value_ = (short)(this.value_ ^ b);
/* 215 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int compareTo(short other) {
/* 220 */     short val = get();
/* 221 */     return val == other ? 0 : val < other ? -1 : 1;
/*     */   }
/*     */ 
/*     */   public int compareTo(SynchronizedShort other) {
/* 225 */     return compareTo(other.get());
/*     */   }
/*     */ 
/*     */   public int compareTo(Object other) {
/* 229 */     return compareTo((SynchronizedShort)other);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other) {
/* 233 */     if ((other != null) && 
/* 234 */       ((other instanceof SynchronizedShort))) {
/* 235 */       return get() == ((SynchronizedShort)other).get();
/*     */     }
/* 237 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 241 */     return get();
/*     */   }
/*     */   public String toString() {
/* 244 */     return String.valueOf(get());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.SynchronizedShort
 * JD-Core Version:    0.6.0
 */