/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class WaitableFloat extends SynchronizedFloat
/*     */ {
/*     */   public WaitableFloat(float initialValue)
/*     */   {
/*  29 */     super(initialValue);
/*     */   }
/*     */ 
/*     */   public WaitableFloat(float initialValue, Object lock)
/*     */   {
/*  37 */     super(initialValue, lock);
/*     */   }
/*     */ 
/*     */   public float set(float newValue)
/*     */   {
/*  42 */     synchronized (this.lock_) {
/*  43 */       this.lock_.notifyAll();
/*  44 */       return super.set(newValue);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean commit(float assumedValue, float newValue) {
/*  49 */     synchronized (this.lock_) {
/*  50 */       boolean success = super.commit(assumedValue, newValue);
/*  51 */       if (success) this.lock_.notifyAll();
/*  52 */       return success;
/*     */     }
/*     */   }
/*     */ 
/*     */   public float add(float amount)
/*     */   {
/*  58 */     synchronized (this.lock_) {
/*  59 */       this.lock_.notifyAll();
/*  60 */       return super.add(amount);
/*     */     }
/*     */   }
/*     */ 
/*     */   public float subtract(float amount) {
/*  65 */     synchronized (this.lock_) {
/*  66 */       this.lock_.notifyAll();
/*  67 */       return super.subtract(amount);
/*     */     }
/*     */   }
/*     */ 
/*     */   public float multiply(float factor) {
/*  72 */     synchronized (this.lock_) {
/*  73 */       this.lock_.notifyAll();
/*  74 */       return super.multiply(factor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public float divide(float factor) {
/*  79 */     synchronized (this.lock_) {
/*  80 */       this.lock_.notifyAll();
/*  81 */       return super.divide(factor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenEqual(float c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/*  92 */     synchronized (this.lock_) {
/*  93 */       while (this.value_ != c) this.lock_.wait();
/*  94 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenNotEqual(float c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 103 */     synchronized (this.lock_) {
/* 104 */       while (this.value_ == c) this.lock_.wait();
/* 105 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenLessEqual(float c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 114 */     synchronized (this.lock_) {
/* 115 */       while (this.value_ > c) this.lock_.wait();
/* 116 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenLess(float c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 125 */     synchronized (this.lock_) {
/* 126 */       while (this.value_ >= c) this.lock_.wait();
/* 127 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenGreaterEqual(float c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 136 */     synchronized (this.lock_) {
/* 137 */       while (this.value_ < c) this.lock_.wait();
/* 138 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void whenGreater(float c, Runnable action)
/*     */     throws InterruptedException
/*     */   {
/* 147 */     synchronized (this.lock_) {
/* 148 */       while (this.value_ <= c) this.lock_.wait();
/* 149 */       if (action != null) action.run();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.WaitableFloat
 * JD-Core Version:    0.6.0
 */