/*     */ package EDU.oswego.cs.dl.util.concurrent.misc;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class Fraction
/*     */   implements Cloneable, Comparable, Serializable
/*     */ {
/*     */   protected final long numerator_;
/*     */   protected final long denominator_;
/*     */ 
/*     */   public final long numerator()
/*     */   {
/*  27 */     return this.numerator_;
/*     */   }
/*     */   public final long denominator() {
/*  30 */     return this.denominator_;
/*     */   }
/*     */ 
/*     */   public Fraction(long num, long den)
/*     */   {
/*  35 */     boolean numNonnegative = num >= 0L;
/*  36 */     boolean denNonnegative = den >= 0L;
/*  37 */     long a = numNonnegative ? num : -num;
/*  38 */     long b = denNonnegative ? den : -den;
/*  39 */     long g = gcd(a, b);
/*  40 */     this.numerator_ = (numNonnegative == denNonnegative ? a / g : -a / g);
/*  41 */     this.denominator_ = (b / g);
/*     */   }
/*     */ 
/*     */   public Fraction(Fraction f)
/*     */   {
/*  46 */     this.numerator_ = f.numerator();
/*  47 */     this.denominator_ = f.denominator();
/*     */   }
/*     */ 
/*     */   public String toString() {
/*  51 */     if (denominator() == 1L) {
/*  52 */       return numerator();
/*     */     }
/*  54 */     return numerator() + "/" + denominator();
/*     */   }
/*     */   public Object clone() {
/*  57 */     return new Fraction(this);
/*     */   }
/*     */ 
/*     */   public double asDouble() {
/*  61 */     return numerator() / denominator();
/*     */   }
/*     */ 
/*     */   public static long gcd(long a, long b)
/*     */   {
/*  73 */     if (a < 0L) a = -a;
/*  74 */     if (b < 0L) b = -b;
/*  76 */     long y;
/*     */     long x;
/*     */     long y;
/*  76 */     if (a >= b) { long x = a; y = b; } else {
/*  77 */       x = b; y = a;
/*     */     }
/*  79 */     while (y != 0L) {
/*  80 */       long t = x % y;
/*  81 */       x = y;
/*  82 */       y = t;
/*     */     }
/*  84 */     return x;
/*     */   }
/*     */ 
/*     */   public Fraction negative()
/*     */   {
/*  89 */     long an = numerator();
/*  90 */     long ad = denominator();
/*  91 */     return new Fraction(-an, ad);
/*     */   }
/*     */ 
/*     */   public Fraction inverse()
/*     */   {
/*  96 */     long an = numerator();
/*  97 */     long ad = denominator();
/*  98 */     return new Fraction(ad, an);
/*     */   }
/*     */ 
/*     */   public Fraction plus(Fraction b)
/*     */   {
/* 104 */     long an = numerator();
/* 105 */     long ad = denominator();
/* 106 */     long bn = b.numerator();
/* 107 */     long bd = b.denominator();
/* 108 */     return new Fraction(an * bd + bn * ad, ad * bd);
/*     */   }
/*     */ 
/*     */   public Fraction plus(long n)
/*     */   {
/* 113 */     long an = numerator();
/* 114 */     long ad = denominator();
/* 115 */     long bn = n;
/* 116 */     long bd = 1L;
/* 117 */     return new Fraction(an * bd + bn * ad, ad * bd);
/*     */   }
/*     */ 
/*     */   public Fraction minus(Fraction b)
/*     */   {
/* 122 */     long an = numerator();
/* 123 */     long ad = denominator();
/* 124 */     long bn = b.numerator();
/* 125 */     long bd = b.denominator();
/* 126 */     return new Fraction(an * bd - bn * ad, ad * bd);
/*     */   }
/*     */ 
/*     */   public Fraction minus(long n)
/*     */   {
/* 131 */     long an = numerator();
/* 132 */     long ad = denominator();
/* 133 */     long bn = n;
/* 134 */     long bd = 1L;
/* 135 */     return new Fraction(an * bd - bn * ad, ad * bd);
/*     */   }
/*     */ 
/*     */   public Fraction times(Fraction b)
/*     */   {
/* 141 */     long an = numerator();
/* 142 */     long ad = denominator();
/* 143 */     long bn = b.numerator();
/* 144 */     long bd = b.denominator();
/* 145 */     return new Fraction(an * bn, ad * bd);
/*     */   }
/*     */ 
/*     */   public Fraction times(long n)
/*     */   {
/* 150 */     long an = numerator();
/* 151 */     long ad = denominator();
/* 152 */     long bn = n;
/* 153 */     long bd = 1L;
/* 154 */     return new Fraction(an * bn, ad * bd);
/*     */   }
/*     */ 
/*     */   public Fraction dividedBy(Fraction b)
/*     */   {
/* 159 */     long an = numerator();
/* 160 */     long ad = denominator();
/* 161 */     long bn = b.numerator();
/* 162 */     long bd = b.denominator();
/* 163 */     return new Fraction(an * bd, ad * bn);
/*     */   }
/*     */ 
/*     */   public Fraction dividedBy(long n)
/*     */   {
/* 168 */     long an = numerator();
/* 169 */     long ad = denominator();
/* 170 */     long bn = n;
/* 171 */     long bd = 1L;
/* 172 */     return new Fraction(an * bd, ad * bn);
/*     */   }
/*     */ 
/*     */   public int compareTo(Object other)
/*     */   {
/* 180 */     Fraction b = (Fraction)other;
/* 181 */     long an = numerator();
/* 182 */     long ad = denominator();
/* 183 */     long bn = b.numerator();
/* 184 */     long bd = b.denominator();
/* 185 */     long l = an * bd;
/* 186 */     long r = bn * ad;
/* 187 */     return l == r ? 0 : l < r ? -1 : 1;
/*     */   }
/*     */ 
/*     */   public int compareTo(long n)
/*     */   {
/* 195 */     long an = numerator();
/* 196 */     long ad = denominator();
/* 197 */     long bn = n;
/* 198 */     long bd = 1L;
/* 199 */     long l = an * bd;
/* 200 */     long r = bn * ad;
/* 201 */     return l == r ? 0 : l < r ? -1 : 1;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other) {
/* 205 */     return compareTo((Fraction)other) == 0;
/*     */   }
/*     */ 
/*     */   public boolean equals(long n) {
/* 209 */     return compareTo(n) == 0;
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 213 */     return (int)(this.numerator_ ^ this.denominator_);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.misc.Fraction
 * JD-Core Version:    0.6.0
 */