/*     */ package EDU.oswego.cs.dl.util.concurrent.misc;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.SemaphoreControlledChannel;
/*     */ import java.io.IOException;
/*     */ import java.io.InterruptedIOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.PipedInputStream;
/*     */ import java.io.PipedOutputStream;
/*     */ 
/*     */ public class PipedChannel extends SemaphoreControlledChannel
/*     */ {
/*     */   protected ObjectInputStream in_;
/*     */   protected ObjectOutputStream out_;
/*     */   protected final PipedOutputStream outp_;
/*     */   protected final PipedInputStream inp_;
/*     */ 
/*     */   public PipedChannel()
/*     */   {
/*  35 */     super(1);
/*     */     try
/*     */     {
/*  38 */       this.outp_ = new PipedOutputStream();
/*  39 */       this.inp_ = new PipedInputStream();
/*  40 */       this.inp_.connect(this.outp_);
/*     */     }
/*     */     catch (IOException ex) {
/*  43 */       ex.printStackTrace();
/*  44 */       throw new Error("Cannot construct Pipe?");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected synchronized ObjectInputStream in()
/*     */   {
/*     */     try
/*     */     {
/*  56 */       if (this.in_ == null) this.in_ = new ObjectInputStream(this.inp_);
/*  57 */       return this.in_;
/*     */     }
/*     */     catch (IOException ex) {
/*  60 */       ex.printStackTrace();
/*  61 */     }throw new Error("IO exception during open");
/*     */   }
/*     */ 
/*     */   protected synchronized ObjectOutputStream out()
/*     */   {
/*     */     try
/*     */     {
/*  71 */       if (this.out_ == null) this.out_ = new ObjectOutputStream(this.outp_);
/*  72 */       return this.out_;
/*     */     }
/*     */     catch (IOException ex) {
/*  75 */       ex.printStackTrace();
/*  76 */     }throw new Error("IO exception during open");
/*     */   }
/*     */ 
/*     */   protected void insert(Object x)
/*     */   {
/*     */     try
/*     */     {
/*  84 */       out().writeObject(x);
/*     */     }
/*     */     catch (InterruptedIOException ex) {
/*  87 */       Thread.currentThread().interrupt();
/*     */     }
/*     */     catch (IOException ex) {
/*  90 */       ex.printStackTrace();
/*  91 */       throw new Error("IO exception during put");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Object extract()
/*     */   {
/*     */     try {
/*  98 */       return in().readObject();
/*     */     }
/*     */     catch (InterruptedIOException ex) {
/* 101 */       Thread.currentThread().interrupt();
/* 102 */       return null;
/*     */     }
/*     */     catch (IOException ex) {
/* 105 */       ex.printStackTrace();
/* 106 */       throw new Error("IO exception during take");
/*     */     }
/*     */     catch (ClassNotFoundException ex) {
/* 109 */       ex.printStackTrace();
/* 110 */     }throw new Error("Serialization exception during take");
/*     */   }
/*     */ 
/*     */   public Object peek()
/*     */   {
/* 115 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.misc.PipedChannel
 * JD-Core Version:    0.6.0
 */