/*      */ package EDU.oswego.cs.dl.util.concurrent.misc;
/*      */ 
/*      */ import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
/*      */ import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
/*      */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
/*      */ 
/*      */ class TestLoop
/*      */ {
/*      */   final RNG shared;
/*      */   final RNG primary;
/*      */   final int iters;
/*      */   final Fraction pshared;
/*      */   final CyclicBarrier barrier;
/*      */   final boolean[] useShared;
/*      */   final int firstidx;
/*      */ 
/*      */   public TestLoop(RNG sh, RNG pri, Fraction pshr, int it, CyclicBarrier br)
/*      */   {
/* 1483 */     this.shared = sh;
/* 1484 */     this.primary = pri;
/* 1485 */     this.pshared = pshr;
/* 1486 */     this.iters = it;
/* 1487 */     this.barrier = br;
/*      */ 
/* 1489 */     this.firstidx = (int)this.primary.get();
/*      */ 
/* 1491 */     int num = (int)this.pshared.numerator();
/* 1492 */     int denom = (int)this.pshared.denominator();
/*      */ 
/* 1494 */     if ((num == 0) || (this.primary == this.shared)) {
/* 1495 */       this.useShared = new boolean[1];
/* 1496 */       this.useShared[0] = false;
/*      */     }
/* 1498 */     else if (num >= denom) {
/* 1499 */       this.useShared = new boolean[1];
/* 1500 */       this.useShared[0] = true;
/*      */     }
/*      */     else
/*      */     {
/* 1507 */       int xfactor = 1024 / denom;
/* 1508 */       if (xfactor < 1) xfactor = 1;
/* 1509 */       this.useShared = new boolean[denom * xfactor];
/* 1510 */       for (int i = 0; i < num * xfactor; i++)
/* 1511 */         this.useShared[i] = true;
/* 1512 */       for (int i = num * xfactor; i < denom * xfactor; i++) {
/* 1513 */         this.useShared[i] = false;
/*      */       }
/* 1515 */       for (int i = 1; i < this.useShared.length; i++) {
/* 1516 */         int j = (int)(this.shared.next() & 0x7FFFFFFF) % (i + 1);
/* 1517 */         boolean tmp = this.useShared[i];
/* 1518 */         this.useShared[i] = this.useShared[j];
/* 1519 */         this.useShared[j] = tmp;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Runnable testLoop() {
/* 1525 */     return new Runnable() {
/*      */       public void run() {
/* 1527 */         int itersPerBarrier = RNG.itersPerBarrier.get();
/*      */         try {
/* 1529 */           int delta = -1;
/* 1530 */           if (TestLoop.this.primary.getClass().equals(PrioritySemRNG.class)) {
/* 1531 */             delta = 2 - (int)(TestLoop.this.primary.get() % 5L);
/*      */           }
/* 1533 */           Thread.currentThread().setPriority(5 + delta);
/*      */ 
/* 1535 */           int nshared = (int)(TestLoop.this.iters * TestLoop.this.pshared.asDouble());
/* 1536 */           int nprimary = TestLoop.this.iters - nshared;
/* 1537 */           int idx = TestLoop.this.firstidx;
/*      */ 
/* 1539 */           TestLoop.this.barrier.barrier();
/*      */ 
/* 1541 */           for (int i = TestLoop.this.iters; i > 0; i--) {
/* 1542 */             idx++;
/* 1543 */             if (i % itersPerBarrier == 0) {
/* 1544 */               TestLoop.this.primary.exchange();
/*      */             }
/*      */             else
/*      */             {
/*      */               RNG r;
/*      */               RNG r;
/* 1549 */               if ((nshared > 0) && (TestLoop.this.useShared[(idx % TestLoop.this.useShared.length)] != 0)) {
/* 1550 */                 nshared--;
/* 1551 */                 r = TestLoop.this.shared;
/*      */               }
/*      */               else {
/* 1554 */                 nprimary--;
/* 1555 */                 r = TestLoop.this.primary;
/*      */               }
/* 1557 */               long rnd = r.next();
/* 1558 */               if ((rnd % 2L == 0L) && (Thread.currentThread().isInterrupted()))
/*      */                 break;
/*      */             }
/*      */           }
/*      */         }
/*      */         catch (BrokenBarrierException localBrokenBarrierException) {
/*      */         }
/*      */         catch (InterruptedException ex) {
/* 1566 */           Thread.currentThread().interrupt();
/*      */         }
/*      */         finally {
/*      */           try {
/* 1570 */             TestLoop.this.barrier.barrier();
/*      */           }
/*      */           catch (BrokenBarrierException localBrokenBarrierException3) {
/*      */           }
/*      */           catch (InterruptedException ex) {
/* 1575 */             Thread.currentThread().interrupt();
/*      */           }
/*      */           finally {
/* 1578 */             Thread.currentThread().setPriority(5);
/*      */           }
/*      */         }
/*      */       }
/*      */     };
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.misc.TestLoop
 * JD-Core Version:    0.6.0
 */