package antlr;

import antlr.collections.impl.BitSet;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;

public class ANTLRLexer extends CharScanner
  implements ANTLRTokenTypes, TokenStream
{
  public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
  public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
  public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
  public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
  public static final BitSet _tokenSet_4 = new BitSet(mk_tokenSet_4());
  public static final BitSet _tokenSet_5 = new BitSet(mk_tokenSet_5());

  public static int escapeCharValue(String paramString)
  {
    if (paramString.charAt(1) != '\\')
      return 0;
    switch (paramString.charAt(2))
    {
    case 'b':
      return 8;
    case 'r':
      return 13;
    case 't':
      return 9;
    case 'n':
      return 10;
    case 'f':
      return 12;
    case '"':
      return 34;
    case '\'':
      return 39;
    case '\\':
      return 92;
    case 'u':
      if (paramString.length() != 8)
        return 0;
      return Character.digit(paramString.charAt(3), 16) * 16 * 16 * 16 + Character.digit(paramString.charAt(4), 16) * 16 * 16 + Character.digit(paramString.charAt(5), 16) * 16 + Character.digit(paramString.charAt(6), 16);
    case '0':
    case '1':
    case '2':
    case '3':
      if ((paramString.length() > 5) && (Character.isDigit(paramString.charAt(4))))
        return (paramString.charAt(2) - '0') * 8 * 8 + (paramString.charAt(3) - '0') * 8 + (paramString.charAt(4) - '0');
      if ((paramString.length() > 4) && (Character.isDigit(paramString.charAt(3))))
        return (paramString.charAt(2) - '0') * 8 + (paramString.charAt(3) - '0');
      return paramString.charAt(2) - '0';
    case '4':
    case '5':
    case '6':
    case '7':
      if ((paramString.length() > 4) && (Character.isDigit(paramString.charAt(3))))
        return (paramString.charAt(2) - '0') * 8 + (paramString.charAt(3) - '0');
      return paramString.charAt(2) - '0';
    }
    return 0;
  }

  public static int tokenTypeForCharLiteral(String paramString)
  {
    if (paramString.length() > 3)
      return escapeCharValue(paramString);
    return paramString.charAt(1);
  }

  public ANTLRLexer(InputStream paramInputStream)
  {
    this(new ByteBuffer(paramInputStream));
  }

  public ANTLRLexer(Reader paramReader)
  {
    this(new CharBuffer(paramReader));
  }

  public ANTLRLexer(InputBuffer paramInputBuffer)
  {
    this(new LexerSharedInputState(paramInputBuffer));
  }

  public ANTLRLexer(LexerSharedInputState paramLexerSharedInputState)
  {
    super(paramLexerSharedInputState);
    this.caseSensitiveLiterals = true;
    setCaseSensitive(true);
    this.literals = new Hashtable();
    this.literals.put(new ANTLRHashString("public", this), new Integer(31));
    this.literals.put(new ANTLRHashString("class", this), new Integer(10));
    this.literals.put(new ANTLRHashString("header", this), new Integer(5));
    this.literals.put(new ANTLRHashString("throws", this), new Integer(37));
    this.literals.put(new ANTLRHashString("lexclass", this), new Integer(9));
    this.literals.put(new ANTLRHashString("catch", this), new Integer(40));
    this.literals.put(new ANTLRHashString("private", this), new Integer(32));
    this.literals.put(new ANTLRHashString("options", this), new Integer(51));
    this.literals.put(new ANTLRHashString("extends", this), new Integer(11));
    this.literals.put(new ANTLRHashString("protected", this), new Integer(30));
    this.literals.put(new ANTLRHashString("TreeParser", this), new Integer(13));
    this.literals.put(new ANTLRHashString("Parser", this), new Integer(29));
    this.literals.put(new ANTLRHashString("Lexer", this), new Integer(12));
    this.literals.put(new ANTLRHashString("returns", this), new Integer(35));
    this.literals.put(new ANTLRHashString("charVocabulary", this), new Integer(18));
    this.literals.put(new ANTLRHashString("tokens", this), new Integer(4));
    this.literals.put(new ANTLRHashString("exception", this), new Integer(39));
  }

  public Token nextToken()
    throws TokenStreamException
  {
    Token localToken = null;
    while (true)
    {
      Object localObject = null;
      int i = 0;
      resetText();
      try
      {
        switch (LA(1))
        {
        case '\t':
        case '\n':
        case '\r':
        case ' ':
          mWS(true);
          localToken = this._returnToken;
          break;
        case '/':
          mCOMMENT(true);
          localToken = this._returnToken;
          break;
        case '<':
          mOPEN_ELEMENT_OPTION(true);
          localToken = this._returnToken;
          break;
        case '>':
          mCLOSE_ELEMENT_OPTION(true);
          localToken = this._returnToken;
          break;
        case ',':
          mCOMMA(true);
          localToken = this._returnToken;
          break;
        case '?':
          mQUESTION(true);
          localToken = this._returnToken;
          break;
        case '#':
          mTREE_BEGIN(true);
          localToken = this._returnToken;
          break;
        case '(':
          mLPAREN(true);
          localToken = this._returnToken;
          break;
        case ')':
          mRPAREN(true);
          localToken = this._returnToken;
          break;
        case ':':
          mCOLON(true);
          localToken = this._returnToken;
          break;
        case '*':
          mSTAR(true);
          localToken = this._returnToken;
          break;
        case '+':
          mPLUS(true);
          localToken = this._returnToken;
          break;
        case ';':
          mSEMI(true);
          localToken = this._returnToken;
          break;
        case '^':
          mCARET(true);
          localToken = this._returnToken;
          break;
        case '!':
          mBANG(true);
          localToken = this._returnToken;
          break;
        case '|':
          mOR(true);
          localToken = this._returnToken;
          break;
        case '~':
          mNOT_OP(true);
          localToken = this._returnToken;
          break;
        case '}':
          mRCURLY(true);
          localToken = this._returnToken;
          break;
        case '\'':
          mCHAR_LITERAL(true);
          localToken = this._returnToken;
          break;
        case '"':
          mSTRING_LITERAL(true);
          localToken = this._returnToken;
          break;
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
          mINT(true);
          localToken = this._returnToken;
          break;
        case '[':
          mARG_ACTION(true);
          localToken = this._returnToken;
          break;
        case '{':
          mACTION(true);
          localToken = this._returnToken;
          break;
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
          mTOKEN_REF(true);
          localToken = this._returnToken;
          break;
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':
          mRULE_REF(true);
          localToken = this._returnToken;
          break;
        case '\013':
        case '\f':
        case '\016':
        case '\017':
        case '\020':
        case '\021':
        case '\022':
        case '\023':
        case '\024':
        case '\025':
        case '\026':
        case '\027':
        case '\030':
        case '\031':
        case '\032':
        case '\033':
        case '\034':
        case '\035':
        case '\036':
        case '\037':
        case '$':
        case '%':
        case '&':
        case '-':
        case '.':
        case '=':
        case '@':
        case '\\':
        case ']':
        case '_':
        case '`':
        default:
          if ((LA(1) == '=') && (LA(2) == '>'))
          {
            mIMPLIES(true);
            localToken = this._returnToken;
          }
          else if ((LA(1) == '.') && (LA(2) == '.'))
          {
            mRANGE(true);
            localToken = this._returnToken;
          }
          else if (LA(1) == '=')
          {
            mASSIGN(true);
            localToken = this._returnToken;
          }
          else if (LA(1) == '.')
          {
            mWILDCARD(true);
            localToken = this._returnToken;
          }
          else if (LA(1) == 65535)
          {
            uponEOF();
            this._returnToken = makeToken(1);
          }
          else
          {
            throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
          }
        }
        if (this._returnToken == null)
          continue;
        i = this._returnToken.getType();
        this._returnToken.setType(i);
        return this._returnToken;
      }
      catch (RecognitionException localRecognitionException)
      {
        throw new TokenStreamRecognitionException(localRecognitionException);
      }
      catch (CharStreamException localCharStreamException)
      {
        if (!(localCharStreamException instanceof CharStreamIOException))
          break;
        throw new TokenStreamIOException(((CharStreamIOException)localCharStreamException).io);
      }
    }
    throw new TokenStreamException(localCharStreamException.getMessage());
  }

  public final void mWS(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 52;
    switch (LA(1))
    {
    case ' ':
      match(' ');
      break;
    case '\t':
      match('\t');
      break;
    case '\n':
      match('\n');
      newline();
      break;
    default:
      if ((LA(1) == '\r') && (LA(2) == '\n'))
      {
        match('\r');
        match('\n');
        newline();
      }
      else if (LA(1) == '\r')
      {
        match('\r');
        newline();
      }
      else
      {
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    }
    i = -1;
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mCOMMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken1 = null;
    int j = this.text.length();
    int i = 53;
    Token localToken2 = null;
    if ((LA(1) == '/') && (LA(2) == '/'))
    {
      mSL_COMMENT(false);
    }
    else if ((LA(1) == '/') && (LA(2) == '*'))
    {
      mML_COMMENT(true);
      localToken2 = this._returnToken;
      i = localToken2.getType();
    }
    else
    {
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    if (i != 8)
      i = -1;
    if ((paramBoolean) && (localToken1 == null) && (i != -1))
    {
      localToken1 = makeToken(i);
      localToken1.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken1;
  }

  protected final void mSL_COMMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 54;
    match("//");
    while (_tokenSet_0.member(LA(1)))
      match(_tokenSet_0);
    if ((LA(1) == '\r') && (LA(2) == '\n'))
    {
      match('\r');
      match('\n');
    }
    else if (LA(1) == '\r')
    {
      match('\r');
    }
    else if (LA(1) == '\n')
    {
      match('\n');
    }
    else
    {
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    newline();
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mML_COMMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 55;
    match("/*");
    if ((LA(1) == '*') && (LA(2) >= '\003') && (LA(2) <= 'ÿ') && (LA(2) != '/'))
    {
      match('*');
      i = 8;
    }
    else if ((LA(1) < '\003') || (LA(1) > 'ÿ') || (LA(2) < '\003') || (LA(2) > 'ÿ'))
    {
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    while ((LA(1) != '*') || (LA(2) != '/'))
    {
      if ((LA(1) == '\r') && (LA(2) == '\n'))
      {
        match('\r');
        match('\n');
        newline();
        continue;
      }
      if ((LA(1) == '\r') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        match('\r');
        newline();
        continue;
      }
      if ((_tokenSet_0.member(LA(1))) && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        match(_tokenSet_0);
        continue;
      }
      if (LA(1) != '\n')
        break;
      match('\n');
      newline();
    }
    match("*/");
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mOPEN_ELEMENT_OPTION(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 25;
    match('<');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mCLOSE_ELEMENT_OPTION(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 26;
    match('>');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mCOMMA(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 38;
    match(',');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mQUESTION(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 45;
    match('?');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mTREE_BEGIN(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 44;
    match("#(");
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mLPAREN(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 27;
    match('(');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mRPAREN(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 28;
    match(')');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mCOLON(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 36;
    match(':');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mSTAR(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 46;
    match('*');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mPLUS(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 47;
    match('+');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mASSIGN(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 15;
    match('=');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mIMPLIES(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 48;
    match("=>");
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mSEMI(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 16;
    match(';');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mCARET(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 49;
    match('^');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mBANG(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 33;
    match('!');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mOR(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 21;
    match('|');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mWILDCARD(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 50;
    match('.');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mRANGE(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 22;
    match("..");
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mNOT_OP(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 42;
    match('~');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mRCURLY(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 17;
    match('}');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mCHAR_LITERAL(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 19;
    match('\'');
    if (LA(1) == '\\')
      mESC(false);
    else if (_tokenSet_1.member(LA(1)))
      matchNot('\'');
    else
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    match('\'');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mESC(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 56;
    match('\\');
    switch (LA(1))
    {
    case 'n':
      match('n');
      break;
    case 'r':
      match('r');
      break;
    case 't':
      match('t');
      break;
    case 'b':
      match('b');
      break;
    case 'f':
      match('f');
      break;
    case 'w':
      match('w');
      break;
    case 'a':
      match('a');
      break;
    case '"':
      match('"');
      break;
    case '\'':
      match('\'');
      break;
    case '\\':
      match('\\');
      break;
    case '0':
    case '1':
    case '2':
    case '3':
      matchRange('0', '3');
      if ((LA(1) >= '0') && (LA(1) <= '7') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        matchRange('0', '7');
        if ((LA(1) >= '0') && (LA(1) <= '7') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
        {
          matchRange('0', '7');
        }
        else
        {
          if ((LA(1) >= '\003') && (LA(1) <= 'ÿ'))
            break;
          throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
        }
      }
      else
      {
        if ((LA(1) >= '\003') && (LA(1) <= 'ÿ'))
          break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    case '4':
    case '5':
    case '6':
    case '7':
      matchRange('4', '7');
      if ((LA(1) >= '0') && (LA(1) <= '7') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        matchRange('0', '7');
      }
      else
      {
        if ((LA(1) >= '\003') && (LA(1) <= 'ÿ'))
          break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    case 'u':
      match('u');
      mXDIGIT(false);
      mXDIGIT(false);
      mXDIGIT(false);
      mXDIGIT(false);
      break;
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mSTRING_LITERAL(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 6;
    match('"');
    while (true)
    {
      if (LA(1) == '\\')
      {
        mESC(false);
        continue;
      }
      if (!_tokenSet_2.member(LA(1)))
        break;
      matchNot('"');
    }
    match('"');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mXDIGIT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 58;
    switch (LA(1))
    {
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
      matchRange('0', '9');
      break;
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
      matchRange('a', 'f');
      break;
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
      matchRange('A', 'F');
      break;
    case ':':
    case ';':
    case '<':
    case '=':
    case '>':
    case '?':
    case '@':
    case 'G':
    case 'H':
    case 'I':
    case 'J':
    case 'K':
    case 'L':
    case 'M':
    case 'N':
    case 'O':
    case 'P':
    case 'Q':
    case 'R':
    case 'S':
    case 'T':
    case 'U':
    case 'V':
    case 'W':
    case 'X':
    case 'Y':
    case 'Z':
    case '[':
    case '\\':
    case ']':
    case '^':
    case '_':
    case '`':
    default:
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mDIGIT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 57;
    matchRange('0', '9');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mINT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 20;
    for (int k = 0; ; k++)
      if ((LA(1) >= '0') && (LA(1) <= '9'))
      {
        matchRange('0', '9');
      }
      else
      {
        if (k >= 1)
          break;
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mARG_ACTION(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 34;
    mNESTED_ARG_ACTION(false);
    setText(StringUtils.stripFrontBack(getText(), "[", "]"));
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mNESTED_ARG_ACTION(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 59;
    match('[');
    while (true)
      switch (LA(1))
      {
      case '[':
        mNESTED_ARG_ACTION(false);
        break;
      case '\n':
        match('\n');
        newline();
        break;
      case '\'':
        mCHAR_LITERAL(false);
        break;
      case '"':
        mSTRING_LITERAL(false);
        break;
      default:
        if ((LA(1) == '\r') && (LA(2) == '\n'))
        {
          match('\r');
          match('\n');
          newline();
          continue;
        }
        if ((LA(1) == '\r') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
        {
          match('\r');
          newline();
          continue;
        }
        if (!_tokenSet_3.member(LA(1)))
          break label210;
        matchNot(']');
      }
    label210: match(']');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mACTION(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Object localObject = null;
    int j = this.text.length();
    int i = 7;
    int k = getLine();
    int m = getColumn();
    mNESTED_ACTION(false);
    if (LA(1) == '?')
    {
      match('?');
      i = 43;
    }
    if (i == 7)
      setText(StringUtils.stripFrontBack(getText(), "{", "}"));
    else
      setText(StringUtils.stripFrontBack(getText(), "{", "}?"));
    CommonToken localCommonToken = new CommonToken(i, new String(this.text.getBuffer(), j, this.text.length() - j));
    localCommonToken.setLine(k);
    localCommonToken.setColumn(m);
    localObject = localCommonToken;
    if ((paramBoolean) && (localObject == null) && (i != -1))
    {
      localObject = makeToken(i);
      ((Token)localObject).setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = ((Token)localObject);
  }

  protected final void mNESTED_ACTION(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 60;
    match('{');
    while (LA(1) != '}')
    {
      if (((LA(1) == '\n') || (LA(1) == '\r')) && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        if ((LA(1) == '\r') && (LA(2) == '\n'))
        {
          match('\r');
          match('\n');
          newline();
          continue;
        }
        if ((LA(1) == '\r') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
        {
          match('\r');
          newline();
          continue;
        }
        if (LA(1) == '\n')
        {
          match('\n');
          newline();
          continue;
        }
        throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
      }
      if ((LA(1) == '{') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mNESTED_ACTION(false);
        continue;
      }
      if ((LA(1) == '\'') && (_tokenSet_4.member(LA(2))))
      {
        mCHAR_LITERAL(false);
        continue;
      }
      if ((LA(1) == '/') && ((LA(2) == '*') || (LA(2) == '/')))
      {
        mCOMMENT(false);
        continue;
      }
      if ((LA(1) == '"') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        mSTRING_LITERAL(false);
        continue;
      }
      if ((LA(1) < '\003') || (LA(1) > 'ÿ') || (LA(2) < '\003') || (LA(2) > 'ÿ'))
        break;
      matchNot(65535);
    }
    match('}');
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mTOKEN_REF(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 24;
    matchRange('A', 'Z');
    while (true)
      switch (LA(1))
      {
      case 'a':
      case 'b':
      case 'c':
      case 'd':
      case 'e':
      case 'f':
      case 'g':
      case 'h':
      case 'i':
      case 'j':
      case 'k':
      case 'l':
      case 'm':
      case 'n':
      case 'o':
      case 'p':
      case 'q':
      case 'r':
      case 's':
      case 't':
      case 'u':
      case 'v':
      case 'w':
      case 'x':
      case 'y':
      case 'z':
        matchRange('a', 'z');
        break;
      case 'A':
      case 'B':
      case 'C':
      case 'D':
      case 'E':
      case 'F':
      case 'G':
      case 'H':
      case 'I':
      case 'J':
      case 'K':
      case 'L':
      case 'M':
      case 'N':
      case 'O':
      case 'P':
      case 'Q':
      case 'R':
      case 'S':
      case 'T':
      case 'U':
      case 'V':
      case 'W':
      case 'X':
      case 'Y':
      case 'Z':
        matchRange('A', 'Z');
        break;
      case '_':
        match('_');
        break;
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
        matchRange('0', '9');
      case ':':
      case ';':
      case '<':
      case '=':
      case '>':
      case '?':
      case '@':
      case '[':
      case '\\':
      case ']':
      case '^':
      case '`':
      }
    i = testLiteralsTable(i);
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  public final void mRULE_REF(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 41;
    int k = 0;
    k = mINTERNAL_RULE_REF(false);
    i = k;
    if (k == 51)
    {
      mWS_LOOP(false);
      if (LA(1) == '{')
      {
        match('{');
        i = 14;
      }
    }
    else if (k == 4)
    {
      mWS_LOOP(false);
      if (LA(1) == '{')
      {
        match('{');
        i = 23;
      }
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final int mINTERNAL_RULE_REF(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int k = this.text.length();
    int j = 62;
    int i = 41;
    matchRange('a', 'z');
    while (true)
      switch (LA(1))
      {
      case 'a':
      case 'b':
      case 'c':
      case 'd':
      case 'e':
      case 'f':
      case 'g':
      case 'h':
      case 'i':
      case 'j':
      case 'k':
      case 'l':
      case 'm':
      case 'n':
      case 'o':
      case 'p':
      case 'q':
      case 'r':
      case 's':
      case 't':
      case 'u':
      case 'v':
      case 'w':
      case 'x':
      case 'y':
      case 'z':
        matchRange('a', 'z');
        break;
      case 'A':
      case 'B':
      case 'C':
      case 'D':
      case 'E':
      case 'F':
      case 'G':
      case 'H':
      case 'I':
      case 'J':
      case 'K':
      case 'L':
      case 'M':
      case 'N':
      case 'O':
      case 'P':
      case 'Q':
      case 'R':
      case 'S':
      case 'T':
      case 'U':
      case 'V':
      case 'W':
      case 'X':
      case 'Y':
      case 'Z':
        matchRange('A', 'Z');
        break;
      case '_':
        match('_');
        break;
      case '0':
      case '1':
      case '2':
      case '3':
      case '4':
      case '5':
      case '6':
      case '7':
      case '8':
      case '9':
        matchRange('0', '9');
      case ':':
      case ';':
      case '<':
      case '=':
      case '>':
      case '?':
      case '@':
      case '[':
      case '\\':
      case ']':
      case '^':
      case '`':
      }
    i = testLiteralsTable(i);
    if ((paramBoolean) && (localToken == null) && (j != -1))
    {
      localToken = makeToken(j);
      localToken.setText(new String(this.text.getBuffer(), k, this.text.length() - k));
    }
    this._returnToken = localToken;
    return i;
  }

  protected final void mWS_LOOP(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 61;
    while (true)
      switch (LA(1))
      {
      case '\t':
      case '\n':
      case '\r':
      case ' ':
        mWS(false);
        break;
      case '/':
        mCOMMENT(false);
      }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mWS_OPT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 63;
    if (_tokenSet_5.member(LA(1)))
      mWS(false);
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  private static final long[] mk_tokenSet_0()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -9224L;
    for (int i = 1; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_1()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -549755813896L;
    arrayOfLong[1] = -268435457L;
    for (int i = 2; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_2()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -17179869192L;
    arrayOfLong[1] = -268435457L;
    for (int i = 2; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_3()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -566935692296L;
    arrayOfLong[1] = -671088641L;
    for (int i = 2; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_4()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -549755813896L;
    for (int i = 1; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_5()
  {
    long[] arrayOfLong = { 4294977024L, 0L, 0L, 0L, 0L };
    return arrayOfLong;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.ANTLRLexer
 * JD-Core Version:    0.6.0
 */