package antlr;

import antlr.collections.impl.BitSet;
import java.util.Hashtable;

public class DefineGrammarSymbols
  implements ANTLRGrammarParseBehavior
{
  protected Hashtable grammars = new Hashtable();
  protected Hashtable tokenManagers = new Hashtable();
  protected Grammar grammar;
  protected Tool tool;
  LLkAnalyzer analyzer;
  String[] args;
  static final String DEFAULT_TOKENMANAGER_NAME = "*default";
  protected Hashtable headerActions = new Hashtable();
  Token thePreambleAction = new CommonToken(0, "");
  String language = "Java";
  protected int numLexers = 0;
  protected int numParsers = 0;
  protected int numTreeParsers = 0;

  public DefineGrammarSymbols(Tool paramTool, String[] paramArrayOfString, LLkAnalyzer paramLLkAnalyzer)
  {
    this.tool = paramTool;
    this.args = paramArrayOfString;
    this.analyzer = paramLLkAnalyzer;
  }

  public void _refStringLiteral(Token paramToken1, Token paramToken2, int paramInt, boolean paramBoolean)
  {
    if (!(this.grammar instanceof LexerGrammar))
    {
      String str = paramToken1.getText();
      if (this.grammar.tokenManager.getTokenSymbol(str) != null)
        return;
      StringLiteralSymbol localStringLiteralSymbol = new StringLiteralSymbol(str);
      int i = this.grammar.tokenManager.nextTokenType();
      localStringLiteralSymbol.setTokenType(i);
      this.grammar.tokenManager.define(localStringLiteralSymbol);
    }
  }

  public void _refToken(Token paramToken1, Token paramToken2, Token paramToken3, Token paramToken4, boolean paramBoolean1, int paramInt, boolean paramBoolean2)
  {
    String str = paramToken2.getText();
    if (!this.grammar.tokenManager.tokenDefined(str))
    {
      int i = this.grammar.tokenManager.nextTokenType();
      TokenSymbol localTokenSymbol = new TokenSymbol(str);
      localTokenSymbol.setTokenType(i);
      this.grammar.tokenManager.define(localTokenSymbol);
    }
  }

  public void abortGrammar()
  {
    if ((this.grammar != null) && (this.grammar.getClassName() != null))
      this.grammars.remove(this.grammar.getClassName());
    this.grammar = null;
  }

  public void beginAlt(boolean paramBoolean)
  {
  }

  public void beginChildList()
  {
  }

  public void beginExceptionGroup()
  {
  }

  public void beginExceptionSpec(Token paramToken)
  {
  }

  public void beginSubRule(Token paramToken1, Token paramToken2, boolean paramBoolean)
  {
  }

  public void beginTree(Token paramToken)
    throws SemanticException
  {
  }

  public void defineRuleName(Token paramToken, String paramString1, boolean paramBoolean, String paramString2)
    throws SemanticException
  {
    String str = paramToken.getText();
    if (paramToken.type == 24)
    {
      str = CodeGenerator.encodeLexerRuleName(str);
      if (!this.grammar.tokenManager.tokenDefined(paramToken.getText()))
      {
        int i = this.grammar.tokenManager.nextTokenType();
        TokenSymbol localTokenSymbol = new TokenSymbol(paramToken.getText());
        localTokenSymbol.setTokenType(i);
        this.grammar.tokenManager.define(localTokenSymbol);
      }
    }
    RuleSymbol localRuleSymbol;
    if (this.grammar.isDefined(str))
    {
      localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(str);
      if (localRuleSymbol.isDefined())
        this.tool.error("redefinition of rule " + str, this.grammar.getFilename(), paramToken.getLine(), paramToken.getColumn());
    }
    else
    {
      localRuleSymbol = new RuleSymbol(str);
      this.grammar.define(localRuleSymbol);
    }
    localRuleSymbol.setDefined();
    localRuleSymbol.access = paramString1;
    localRuleSymbol.comment = paramString2;
  }

  public void defineToken(Token paramToken1, Token paramToken2)
  {
    String str1 = null;
    String str2 = null;
    if (paramToken1 != null)
      str1 = paramToken1.getText();
    if (paramToken2 != null)
      str2 = paramToken2.getText();
    if (str2 != null)
    {
      StringLiteralSymbol localStringLiteralSymbol = (StringLiteralSymbol)this.grammar.tokenManager.getTokenSymbol(str2);
      if (localStringLiteralSymbol != null)
      {
        if ((str1 == null) || (localStringLiteralSymbol.getLabel() != null))
        {
          this.tool.warning("Redefinition of literal in tokens {...}: " + str2, this.grammar.getFilename(), paramToken2.getLine(), paramToken2.getColumn());
          return;
        }
        if (str1 != null)
        {
          localStringLiteralSymbol.setLabel(str1);
          this.grammar.tokenManager.mapToTokenSymbol(str1, localStringLiteralSymbol);
        }
      }
      if (str1 != null)
      {
        TokenSymbol localTokenSymbol1 = this.grammar.tokenManager.getTokenSymbol(str1);
        if (localTokenSymbol1 != null)
        {
          if ((localTokenSymbol1 instanceof StringLiteralSymbol))
          {
            this.tool.warning("Redefinition of token in tokens {...}: " + str1, this.grammar.getFilename(), paramToken2.getLine(), paramToken2.getColumn());
            return;
          }
          int k = localTokenSymbol1.getTokenType();
          localStringLiteralSymbol = new StringLiteralSymbol(str2);
          localStringLiteralSymbol.setTokenType(k);
          localStringLiteralSymbol.setLabel(str1);
          this.grammar.tokenManager.define(localStringLiteralSymbol);
          this.grammar.tokenManager.mapToTokenSymbol(str1, localStringLiteralSymbol);
          return;
        }
      }
      localStringLiteralSymbol = new StringLiteralSymbol(str2);
      int j = this.grammar.tokenManager.nextTokenType();
      localStringLiteralSymbol.setTokenType(j);
      localStringLiteralSymbol.setLabel(str1);
      this.grammar.tokenManager.define(localStringLiteralSymbol);
      if (str1 != null)
        this.grammar.tokenManager.mapToTokenSymbol(str1, localStringLiteralSymbol);
    }
    else
    {
      if (this.grammar.tokenManager.tokenDefined(str1))
      {
        this.tool.warning("Redefinition of token in tokens {...}: " + str1, this.grammar.getFilename(), paramToken1.getLine(), paramToken1.getColumn());
        return;
      }
      int i = this.grammar.tokenManager.nextTokenType();
      TokenSymbol localTokenSymbol2 = new TokenSymbol(str1);
      localTokenSymbol2.setTokenType(i);
      this.grammar.tokenManager.define(localTokenSymbol2);
    }
  }

  public void endAlt()
  {
  }

  public void endChildList()
  {
  }

  public void endExceptionGroup()
  {
  }

  public void endExceptionSpec()
  {
  }

  public void endGrammar()
  {
  }

  public void endOptions()
  {
    Object localObject;
    if ((this.grammar.exportVocab == null) && (this.grammar.importVocab == null))
    {
      this.grammar.exportVocab = this.grammar.getClassName();
      if (this.tokenManagers.containsKey("*default"))
      {
        this.grammar.exportVocab = "*default";
        localObject = (TokenManager)this.tokenManagers.get("*default");
        this.grammar.setTokenManager((TokenManager)localObject);
        return;
      }
      localObject = new SimpleTokenManager(this.grammar.exportVocab, this.tool);
      this.grammar.setTokenManager((TokenManager)localObject);
      this.tokenManagers.put(this.grammar.exportVocab, localObject);
      this.tokenManagers.put("*default", localObject);
      return;
    }
    TokenManager localTokenManager;
    if ((this.grammar.exportVocab == null) && (this.grammar.importVocab != null))
    {
      this.grammar.exportVocab = this.grammar.getClassName();
      if (this.grammar.importVocab.equals(this.grammar.exportVocab))
      {
        this.tool.warning("Grammar " + this.grammar.getClassName() + " cannot have importVocab same as default output vocab (grammar name); ignored.");
        this.grammar.importVocab = null;
        endOptions();
        return;
      }
      if (this.tokenManagers.containsKey(this.grammar.importVocab))
      {
        localObject = (TokenManager)this.tokenManagers.get(this.grammar.importVocab);
        localTokenManager = (TokenManager)((TokenManager)localObject).clone();
        localTokenManager.setName(this.grammar.exportVocab);
        localTokenManager.setReadOnly(false);
        this.grammar.setTokenManager(localTokenManager);
        this.tokenManagers.put(this.grammar.exportVocab, localTokenManager);
        return;
      }
      localObject = new ImportVocabTokenManager(this.grammar, this.grammar.importVocab + CodeGenerator.TokenTypesFileSuffix + CodeGenerator.TokenTypesFileExt, this.grammar.exportVocab, this.tool);
      ((ImportVocabTokenManager)localObject).setReadOnly(false);
      this.tokenManagers.put(this.grammar.exportVocab, localObject);
      this.grammar.setTokenManager((TokenManager)localObject);
      if (!this.tokenManagers.containsKey("*default"))
        this.tokenManagers.put("*default", localObject);
      return;
    }
    if ((this.grammar.exportVocab != null) && (this.grammar.importVocab == null))
    {
      if (this.tokenManagers.containsKey(this.grammar.exportVocab))
      {
        localObject = (TokenManager)this.tokenManagers.get(this.grammar.exportVocab);
        this.grammar.setTokenManager((TokenManager)localObject);
        return;
      }
      localObject = new SimpleTokenManager(this.grammar.exportVocab, this.tool);
      this.grammar.setTokenManager((TokenManager)localObject);
      this.tokenManagers.put(this.grammar.exportVocab, localObject);
      if (!this.tokenManagers.containsKey("*default"))
        this.tokenManagers.put("*default", localObject);
      return;
    }
    if ((this.grammar.exportVocab != null) && (this.grammar.importVocab != null))
    {
      if (this.grammar.importVocab.equals(this.grammar.exportVocab))
        this.tool.error("exportVocab of " + this.grammar.exportVocab + " same as importVocab; probably not what you want");
      if (this.tokenManagers.containsKey(this.grammar.importVocab))
      {
        localObject = (TokenManager)this.tokenManagers.get(this.grammar.importVocab);
        localTokenManager = (TokenManager)((TokenManager)localObject).clone();
        localTokenManager.setName(this.grammar.exportVocab);
        localTokenManager.setReadOnly(false);
        this.grammar.setTokenManager(localTokenManager);
        this.tokenManagers.put(this.grammar.exportVocab, localTokenManager);
        return;
      }
      localObject = new ImportVocabTokenManager(this.grammar, this.grammar.importVocab + CodeGenerator.TokenTypesFileSuffix + CodeGenerator.TokenTypesFileExt, this.grammar.exportVocab, this.tool);
      ((ImportVocabTokenManager)localObject).setReadOnly(false);
      this.tokenManagers.put(this.grammar.exportVocab, localObject);
      this.grammar.setTokenManager((TokenManager)localObject);
      if (!this.tokenManagers.containsKey("*default"))
        this.tokenManagers.put("*default", localObject);
      return;
    }
  }

  public void endRule(String paramString)
  {
  }

  public void endSubRule()
  {
  }

  public void endTree()
  {
  }

  public void hasError()
  {
  }

  public void noASTSubRule()
  {
  }

  public void oneOrMoreSubRule()
  {
  }

  public void optionalSubRule()
  {
  }

  public void setUserExceptions(String paramString)
  {
  }

  public void refAction(Token paramToken)
  {
  }

  public void refArgAction(Token paramToken)
  {
  }

  public void refCharLiteral(Token paramToken1, Token paramToken2, boolean paramBoolean1, int paramInt, boolean paramBoolean2)
  {
  }

  public void refCharRange(Token paramToken1, Token paramToken2, Token paramToken3, int paramInt, boolean paramBoolean)
  {
  }

  public void refElementOption(Token paramToken1, Token paramToken2)
  {
  }

  public void refTokensSpecElementOption(Token paramToken1, Token paramToken2, Token paramToken3)
  {
  }

  public void refExceptionHandler(Token paramToken1, Token paramToken2)
  {
  }

  public void refHeaderAction(Token paramToken1, Token paramToken2)
  {
    String str;
    if (paramToken1 == null)
      str = "";
    else
      str = StringUtils.stripFrontBack(paramToken1.getText(), "\"", "\"");
    if (this.headerActions.containsKey(str))
      if (str.equals(""))
        this.tool.error(paramToken2.getLine() + ": header action already defined");
      else
        this.tool.error(paramToken2.getLine() + ": header action '" + str + "' already defined");
    this.headerActions.put(str, paramToken2);
  }

  public String getHeaderAction(String paramString)
  {
    Token localToken = (Token)this.headerActions.get(paramString);
    if (localToken == null)
      return "";
    return localToken.getText();
  }

  public int getHeaderActionLine(String paramString)
  {
    Token localToken = (Token)this.headerActions.get(paramString);
    if (localToken == null)
      return 0;
    return localToken.getLine();
  }

  public void refInitAction(Token paramToken)
  {
  }

  public void refMemberAction(Token paramToken)
  {
  }

  public void refPreambleAction(Token paramToken)
  {
    this.thePreambleAction = paramToken;
  }

  public void refReturnAction(Token paramToken)
  {
  }

  public void refRule(Token paramToken1, Token paramToken2, Token paramToken3, Token paramToken4, int paramInt)
  {
    String str = paramToken2.getText();
    if (paramToken2.type == 24)
      str = CodeGenerator.encodeLexerRuleName(str);
    if (!this.grammar.isDefined(str))
      this.grammar.define(new RuleSymbol(str));
  }

  public void refSemPred(Token paramToken)
  {
  }

  public void refStringLiteral(Token paramToken1, Token paramToken2, int paramInt, boolean paramBoolean)
  {
    _refStringLiteral(paramToken1, paramToken2, paramInt, paramBoolean);
  }

  public void refToken(Token paramToken1, Token paramToken2, Token paramToken3, Token paramToken4, boolean paramBoolean1, int paramInt, boolean paramBoolean2)
  {
    _refToken(paramToken1, paramToken2, paramToken3, paramToken4, paramBoolean1, paramInt, paramBoolean2);
  }

  public void refTokenRange(Token paramToken1, Token paramToken2, Token paramToken3, int paramInt, boolean paramBoolean)
  {
    if (paramToken1.getText().charAt(0) == '"')
      refStringLiteral(paramToken1, null, 1, paramBoolean);
    else
      _refToken(null, paramToken1, null, null, false, 1, paramBoolean);
    if (paramToken2.getText().charAt(0) == '"')
      _refStringLiteral(paramToken2, null, 1, paramBoolean);
    else
      _refToken(null, paramToken2, null, null, false, 1, paramBoolean);
  }

  public void refTreeSpecifier(Token paramToken)
  {
  }

  public void refWildcard(Token paramToken1, Token paramToken2, int paramInt)
  {
  }

  public void reset()
  {
    this.grammar = null;
  }

  public void setArgOfRuleRef(Token paramToken)
  {
  }

  public void setCharVocabulary(BitSet paramBitSet)
  {
    ((LexerGrammar)this.grammar).setCharVocabulary(paramBitSet);
  }

  public void setFileOption(Token paramToken1, Token paramToken2, String paramString)
  {
    if (paramToken1.getText().equals("language"))
    {
      if (paramToken2.getType() == 6)
        this.language = StringUtils.stripBack(StringUtils.stripFront(paramToken2.getText(), '"'), '"');
      else if ((paramToken2.getType() == 24) || (paramToken2.getType() == 41))
        this.language = paramToken2.getText();
      else
        this.tool.error("language option must be string or identifier", paramString, paramToken2.getLine(), paramToken2.getColumn());
    }
    else if (paramToken1.getText().equals("mangleLiteralPrefix"))
    {
      if (paramToken2.getType() == 6)
        this.tool.literalsPrefix = StringUtils.stripFrontBack(paramToken2.getText(), "\"", "\"");
      else
        this.tool.error("mangleLiteralPrefix option must be string", paramString, paramToken2.getLine(), paramToken2.getColumn());
    }
    else if (paramToken1.getText().equals("upperCaseMangledLiterals"))
    {
      if (paramToken2.getText().equals("true"))
        this.tool.upperCaseMangledLiterals = true;
      else if (paramToken2.getText().equals("false"))
        this.tool.upperCaseMangledLiterals = false;
      else
        this.grammar.antlrTool.error("Value for upperCaseMangledLiterals must be true or false", paramString, paramToken1.getLine(), paramToken1.getColumn());
    }
    else if ((paramToken1.getText().equals("namespaceStd")) || (paramToken1.getText().equals("namespaceAntlr")) || (paramToken1.getText().equals("genHashLines")))
    {
      if (!this.language.equals("Cpp"))
      {
        this.tool.error(paramToken1.getText() + " option only valid for C++", paramString, paramToken1.getLine(), paramToken1.getColumn());
      }
      else if (paramToken1.getText().equals("noConstructors"))
      {
        if ((!paramToken2.getText().equals("true")) && (!paramToken2.getText().equals("false")))
          this.tool.error("noConstructors option must be true or false", paramString, paramToken2.getLine(), paramToken2.getColumn());
        this.tool.noConstructors = paramToken2.getText().equals("true");
      }
      else if (paramToken1.getText().equals("genHashLines"))
      {
        if ((!paramToken2.getText().equals("true")) && (!paramToken2.getText().equals("false")))
          this.tool.error("genHashLines option must be true or false", paramString, paramToken2.getLine(), paramToken2.getColumn());
        this.tool.genHashLines = paramToken2.getText().equals("true");
      }
      else if (paramToken2.getType() != 6)
      {
        this.tool.error(paramToken1.getText() + " option must be a string", paramString, paramToken2.getLine(), paramToken2.getColumn());
      }
      else if (paramToken1.getText().equals("namespaceStd"))
      {
        this.tool.namespaceStd = paramToken2.getText();
      }
      else if (paramToken1.getText().equals("namespaceAntlr"))
      {
        this.tool.namespaceAntlr = paramToken2.getText();
      }
    }
    else if (paramToken1.getText().equals("namespace"))
    {
      if ((!this.language.equals("Cpp")) && (!this.language.equals("CSharp")))
        this.tool.error(paramToken1.getText() + " option only valid for C++ and C# (a.k.a CSharp)", paramString, paramToken1.getLine(), paramToken1.getColumn());
      else if (paramToken2.getType() != 6)
        this.tool.error(paramToken1.getText() + " option must be a string", paramString, paramToken2.getLine(), paramToken2.getColumn());
      else if (paramToken1.getText().equals("namespace"))
        this.tool.setNameSpace(paramToken2.getText());
    }
    else
      this.tool.error("Invalid file-level option: " + paramToken1.getText(), paramString, paramToken1.getLine(), paramToken2.getColumn());
  }

  public void setGrammarOption(Token paramToken1, Token paramToken2)
  {
    if ((paramToken1.getText().equals("tokdef")) || (paramToken1.getText().equals("tokenVocabulary")))
      this.tool.error("tokdef/tokenVocabulary options are invalid >= ANTLR 2.6.0.\n  Use importVocab/exportVocab instead.  Please see the documentation.\n  The previous options were so heinous that Terence changed the whole\n  vocabulary mechanism; it was better to change the names rather than\n  subtly change the functionality of the known options.  Sorry!", this.grammar.getFilename(), paramToken2.getLine(), paramToken2.getColumn());
    else if ((paramToken1.getText().equals("literal")) && ((this.grammar instanceof LexerGrammar)))
      this.tool.error("the literal option is invalid >= ANTLR 2.6.0.\n  Use the \"tokens {...}\" mechanism instead.", this.grammar.getFilename(), paramToken2.getLine(), paramToken2.getColumn());
    else if (paramToken1.getText().equals("exportVocab"))
    {
      if ((paramToken2.getType() == 41) || (paramToken2.getType() == 24))
        this.grammar.exportVocab = paramToken2.getText();
      else
        this.tool.error("exportVocab must be an identifier", this.grammar.getFilename(), paramToken2.getLine(), paramToken2.getColumn());
    }
    else if (paramToken1.getText().equals("importVocab"))
    {
      if ((paramToken2.getType() == 41) || (paramToken2.getType() == 24))
        this.grammar.importVocab = paramToken2.getText();
      else
        this.tool.error("importVocab must be an identifier", this.grammar.getFilename(), paramToken2.getLine(), paramToken2.getColumn());
    }
    else if (paramToken1.getText().equals("k"))
    {
      if (((this.grammar instanceof TreeWalkerGrammar)) && (!paramToken2.getText().equals("1")))
        this.tool.error("Treewalkers only support k=1", this.grammar.getFilename(), paramToken2.getLine(), paramToken2.getColumn());
      else
        this.grammar.setOption(paramToken1.getText(), paramToken2);
    }
    else
      this.grammar.setOption(paramToken1.getText(), paramToken2);
  }

  public void setRuleOption(Token paramToken1, Token paramToken2)
  {
  }

  public void setSubruleOption(Token paramToken1, Token paramToken2)
  {
  }

  public void startLexer(String paramString1, Token paramToken, String paramString2, String paramString3)
  {
    if (this.numLexers > 0)
      this.tool.panic("You may only have one lexer per grammar file: class " + paramToken.getText());
    this.numLexers += 1;
    reset();
    Grammar localGrammar = (Grammar)this.grammars.get(paramToken);
    if (localGrammar != null)
    {
      if (!(localGrammar instanceof LexerGrammar))
        this.tool.panic("'" + paramToken.getText() + "' is already defined as a non-lexer");
      else
        this.tool.panic("Lexer '" + paramToken.getText() + "' is already defined");
    }
    else
    {
      LexerGrammar localLexerGrammar = new LexerGrammar(paramToken.getText(), this.tool, paramString2);
      localLexerGrammar.comment = paramString3;
      localLexerGrammar.processArguments(this.args);
      localLexerGrammar.setFilename(paramString1);
      this.grammars.put(localLexerGrammar.getClassName(), localLexerGrammar);
      localLexerGrammar.preambleAction = this.thePreambleAction;
      this.thePreambleAction = new CommonToken(0, "");
      this.grammar = localLexerGrammar;
    }
  }

  public void startParser(String paramString1, Token paramToken, String paramString2, String paramString3)
  {
    if (this.numParsers > 0)
      this.tool.panic("You may only have one parser per grammar file: class " + paramToken.getText());
    this.numParsers += 1;
    reset();
    Grammar localGrammar = (Grammar)this.grammars.get(paramToken);
    if (localGrammar != null)
    {
      if (!(localGrammar instanceof ParserGrammar))
        this.tool.panic("'" + paramToken.getText() + "' is already defined as a non-parser");
      else
        this.tool.panic("Parser '" + paramToken.getText() + "' is already defined");
    }
    else
    {
      this.grammar = new ParserGrammar(paramToken.getText(), this.tool, paramString2);
      this.grammar.comment = paramString3;
      this.grammar.processArguments(this.args);
      this.grammar.setFilename(paramString1);
      this.grammars.put(this.grammar.getClassName(), this.grammar);
      this.grammar.preambleAction = this.thePreambleAction;
      this.thePreambleAction = new CommonToken(0, "");
    }
  }

  public void startTreeWalker(String paramString1, Token paramToken, String paramString2, String paramString3)
  {
    if (this.numTreeParsers > 0)
      this.tool.panic("You may only have one tree parser per grammar file: class " + paramToken.getText());
    this.numTreeParsers += 1;
    reset();
    Grammar localGrammar = (Grammar)this.grammars.get(paramToken);
    if (localGrammar != null)
    {
      if (!(localGrammar instanceof TreeWalkerGrammar))
        this.tool.panic("'" + paramToken.getText() + "' is already defined as a non-tree-walker");
      else
        this.tool.panic("Tree-walker '" + paramToken.getText() + "' is already defined");
    }
    else
    {
      this.grammar = new TreeWalkerGrammar(paramToken.getText(), this.tool, paramString2);
      this.grammar.comment = paramString3;
      this.grammar.processArguments(this.args);
      this.grammar.setFilename(paramString1);
      this.grammars.put(this.grammar.getClassName(), this.grammar);
      this.grammar.preambleAction = this.thePreambleAction;
      this.thePreambleAction = new CommonToken(0, "");
    }
  }

  public void synPred()
  {
  }

  public void zeroOrMoreSubRule()
  {
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.DefineGrammarSymbols
 * JD-Core Version:    0.6.0
 */