package antlr;

public abstract class InputBuffer
{
  protected int nMarkers = 0;
  protected int markerOffset = 0;
  protected int numToConsume = 0;
  protected CharQueue queue = new CharQueue(1);

  public void commit()
  {
    this.nMarkers -= 1;
  }

  public void consume()
  {
    this.numToConsume += 1;
  }

  public abstract void fill(int paramInt)
    throws CharStreamException;

  public String getLAChars()
  {
    StringBuffer localStringBuffer = new StringBuffer();
    for (int i = this.markerOffset; i < this.queue.nbrEntries; i++)
      localStringBuffer.append(this.queue.elementAt(i));
    return localStringBuffer.toString();
  }

  public String getMarkedChars()
  {
    StringBuffer localStringBuffer = new StringBuffer();
    for (int i = 0; i < this.markerOffset; i++)
      localStringBuffer.append(this.queue.elementAt(i));
    return localStringBuffer.toString();
  }

  public boolean isMarked()
  {
    return this.nMarkers != 0;
  }

  public char LA(int paramInt)
    throws CharStreamException
  {
    fill(paramInt);
    return this.queue.elementAt(this.markerOffset + paramInt - 1);
  }

  public int mark()
  {
    syncConsume();
    this.nMarkers += 1;
    return this.markerOffset;
  }

  public void rewind(int paramInt)
  {
    syncConsume();
    this.markerOffset = paramInt;
    this.nMarkers -= 1;
  }

  public void reset()
  {
    this.nMarkers = 0;
    this.markerOffset = 0;
    this.numToConsume = 0;
    this.queue.reset();
  }

  protected void syncConsume()
  {
    while (this.numToConsume > 0)
    {
      if (this.nMarkers > 0)
        this.markerOffset += 1;
      else
        this.queue.removeFirst();
      this.numToConsume -= 1;
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.InputBuffer
 * JD-Core Version:    0.6.0
 */