package antlr;

public class TokenBuffer
{
  protected TokenStream input;
  int nMarkers = 0;
  int markerOffset = 0;
  int numToConsume = 0;
  TokenQueue queue;

  public TokenBuffer(TokenStream paramTokenStream)
  {
    this.input = paramTokenStream;
    this.queue = new TokenQueue(1);
  }

  public final void reset()
  {
    this.nMarkers = 0;
    this.markerOffset = 0;
    this.numToConsume = 0;
    this.queue.reset();
  }

  public final void consume()
  {
    this.numToConsume += 1;
  }

  private final void fill(int paramInt)
    throws TokenStreamException
  {
    syncConsume();
    while (this.queue.nbrEntries < paramInt + this.markerOffset)
      this.queue.append(this.input.nextToken());
  }

  public TokenStream getInput()
  {
    return this.input;
  }

  public final int LA(int paramInt)
    throws TokenStreamException
  {
    fill(paramInt);
    return this.queue.elementAt(this.markerOffset + paramInt - 1).getType();
  }

  public final Token LT(int paramInt)
    throws TokenStreamException
  {
    fill(paramInt);
    return this.queue.elementAt(this.markerOffset + paramInt - 1);
  }

  public final int mark()
  {
    syncConsume();
    this.nMarkers += 1;
    return this.markerOffset;
  }

  public final void rewind(int paramInt)
  {
    syncConsume();
    this.markerOffset = paramInt;
    this.nMarkers -= 1;
  }

  private final void syncConsume()
  {
    while (this.numToConsume > 0)
    {
      if (this.nMarkers > 0)
        this.markerOffset += 1;
      else
        this.queue.removeFirst();
      this.numToConsume -= 1;
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.TokenBuffer
 * JD-Core Version:    0.6.0
 */