package antlr;

public class Utils
{
  private static boolean useSystemExit = true;
  private static boolean useDirectClassLoading = false;

  public static Class loadClass(String paramString)
    throws ClassNotFoundException
  {
    try
    {
      ClassLoader localClassLoader = Thread.currentThread().getContextClassLoader();
      if ((!useDirectClassLoading) && (localClassLoader != null))
        return localClassLoader.loadClass(paramString);
      return Class.forName(paramString);
    }
    catch (Exception localException)
    {
    }
    return Class.forName(paramString);
  }

  public static Object createInstanceOf(String paramString)
    throws ClassNotFoundException, InstantiationException, IllegalAccessException
  {
    return loadClass(paramString).newInstance();
  }

  public static void error(String paramString)
  {
    if (useSystemExit)
      System.exit(1);
    throw new RuntimeException("ANTLR Panic: " + paramString);
  }

  public static void error(String paramString, Throwable paramThrowable)
  {
    if (useSystemExit)
      System.exit(1);
    throw new RuntimeException("ANTLR Panic", paramThrowable);
  }

  static
  {
    if ("true".equalsIgnoreCase(System.getProperty("ANTLR_DO_NOT_EXIT", "false")))
      useSystemExit = false;
    if ("true".equalsIgnoreCase(System.getProperty("ANTLR_USE_DIRECT_CLASS_LOADING", "false")))
      useDirectClassLoading = true;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.Utils
 * JD-Core Version:    0.6.0
 */