package antlr.actions.python;

import antlr.ANTLRStringBuffer;
import antlr.ByteBuffer;
import antlr.CharBuffer;
import antlr.CharScanner;
import antlr.CharStreamException;
import antlr.CharStreamIOException;
import antlr.InputBuffer;
import antlr.LexerSharedInputState;
import antlr.NoViableAltForCharException;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.TokenStreamRecognitionException;
import antlr.Tool;
import antlr.collections.impl.BitSet;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;

public class CodeLexer extends CharScanner
  implements CodeLexerTokenTypes, TokenStream
{
  protected int lineOffset = 0;
  private Tool antlrTool;
  public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
  public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());

  public CodeLexer(String paramString1, String paramString2, int paramInt, Tool paramTool)
  {
    this(new StringReader(paramString1));
    setLine(paramInt);
    setFilename(paramString2);
    this.antlrTool = paramTool;
  }

  public void setLineOffset(int paramInt)
  {
    setLine(paramInt);
  }

  public void reportError(RecognitionException paramRecognitionException)
  {
    this.antlrTool.error("Syntax error in action: " + paramRecognitionException, getFilename(), getLine(), getColumn());
  }

  public void reportError(String paramString)
  {
    this.antlrTool.error(paramString, getFilename(), getLine(), getColumn());
  }

  public void reportWarning(String paramString)
  {
    if (getFilename() == null)
      this.antlrTool.warning(paramString);
    else
      this.antlrTool.warning(paramString, getFilename(), getLine(), getColumn());
  }

  public CodeLexer(InputStream paramInputStream)
  {
    this(new ByteBuffer(paramInputStream));
  }

  public CodeLexer(Reader paramReader)
  {
    this(new CharBuffer(paramReader));
  }

  public CodeLexer(InputBuffer paramInputBuffer)
  {
    this(new LexerSharedInputState(paramInputBuffer));
  }

  public CodeLexer(LexerSharedInputState paramLexerSharedInputState)
  {
    super(paramLexerSharedInputState);
    this.caseSensitiveLiterals = true;
    setCaseSensitive(true);
    this.literals = new Hashtable();
  }

  public Token nextToken()
    throws TokenStreamException
  {
    Token localToken = null;
    while (true)
    {
      Object localObject = null;
      int i = 0;
      resetText();
      try
      {
        mACTION(true);
        localToken = this._returnToken;
        if (this._returnToken == null)
          continue;
        i = this._returnToken.getType();
        this._returnToken.setType(i);
        return this._returnToken;
      }
      catch (RecognitionException localRecognitionException)
      {
        throw new TokenStreamRecognitionException(localRecognitionException);
      }
      catch (CharStreamException localCharStreamException)
      {
        if (!(localCharStreamException instanceof CharStreamIOException))
          break;
        throw new TokenStreamIOException(((CharStreamIOException)localCharStreamException).io);
      }
    }
    throw new TokenStreamException(localCharStreamException.getMessage());
  }

  public final void mACTION(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 4;
    while ((LA(1) >= '\003') && (LA(1) <= 'ÿ'))
      mSTUFF(false);
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mSTUFF(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 5;
    if ((LA(1) == '/') && ((LA(2) == '*') || (LA(2) == '/')))
    {
      mCOMMENT(false);
    }
    else if ((LA(1) == '\r') && (LA(2) == '\n'))
    {
      match("\r\n");
      newline();
    }
    else if ((LA(1) == '/') && (_tokenSet_0.member(LA(2))))
    {
      match('/');
      match(_tokenSet_0);
    }
    else if (LA(1) == '\r')
    {
      match('\r');
      newline();
    }
    else if (LA(1) == '\n')
    {
      match('\n');
      newline();
    }
    else if (_tokenSet_1.member(LA(1)))
    {
      match(_tokenSet_1);
    }
    else
    {
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mCOMMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 6;
    if ((LA(1) == '/') && (LA(2) == '/'))
      mSL_COMMENT(false);
    else if ((LA(1) == '/') && (LA(2) == '*'))
      mML_COMMENT(false);
    else
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mSL_COMMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 7;
    int k = this.text.length();
    match("//");
    this.text.setLength(k);
    this.text.append("#");
    while ((LA(1) != '\n') && (LA(1) != '\r') && (LA(1) >= '\003') && (LA(1) <= 'ÿ') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      matchNot(65535);
    if ((LA(1) == '\r') && (LA(2) == '\n'))
      match("\r\n");
    else if (LA(1) == '\n')
      match('\n');
    else if (LA(1) == '\r')
      match('\r');
    else
      throw new NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    newline();
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mML_COMMENT(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 9;
    int m = 0;
    int k = this.text.length();
    match("/*");
    this.text.setLength(k);
    this.text.append("#");
    while ((LA(1) != '*') || (LA(2) != '/'))
    {
      if ((LA(1) == '\r') && (LA(2) == '\n'))
      {
        match('\r');
        match('\n');
        k = this.text.length();
        mIGNWS(false);
        this.text.setLength(k);
        newline();
        this.text.append("# ");
        continue;
      }
      if ((LA(1) == '\r') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        match('\r');
        k = this.text.length();
        mIGNWS(false);
        this.text.setLength(k);
        newline();
        this.text.append("# ");
        continue;
      }
      if ((LA(1) == '\n') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        match('\n');
        k = this.text.length();
        mIGNWS(false);
        this.text.setLength(k);
        newline();
        this.text.append("# ");
        continue;
      }
      if ((LA(1) < '\003') || (LA(1) > 'ÿ') || (LA(2) < '\003') || (LA(2) > 'ÿ'))
        break;
      matchNot(65535);
    }
    this.text.append("\n");
    k = this.text.length();
    match("*/");
    this.text.setLength(k);
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  protected final void mIGNWS(boolean paramBoolean)
    throws RecognitionException, CharStreamException, TokenStreamException
  {
    Token localToken = null;
    int j = this.text.length();
    int i = 8;
    while (true)
    {
      if ((LA(1) == ' ') && (LA(2) >= '\003') && (LA(2) <= 'ÿ'))
      {
        match(' ');
        continue;
      }
      if ((LA(1) != '\t') || (LA(2) < '\003') || (LA(2) > 'ÿ'))
        break;
      match('\t');
    }
    if ((paramBoolean) && (localToken == null) && (i != -1))
    {
      localToken = makeToken(i);
      localToken.setText(new String(this.text.getBuffer(), j, this.text.length() - j));
    }
    this._returnToken = localToken;
  }

  private static final long[] mk_tokenSet_0()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -145135534866440L;
    for (int i = 1; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_1()
  {
    long[] arrayOfLong = new long[8];
    arrayOfLong[0] = -140737488364552L;
    for (int i = 1; i <= 3; i++)
      arrayOfLong[i] = -1L;
    return arrayOfLong;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.actions.python.CodeLexer
 * JD-Core Version:    0.6.0
 */