package antlr.debug;

import antlr.CharStreamException;
import antlr.InputBuffer;
import java.util.Vector;

public class DebuggingInputBuffer extends InputBuffer
{
  private InputBuffer buffer;
  private InputBufferEventSupport inputBufferEventSupport;
  private boolean debugMode = true;

  public DebuggingInputBuffer(InputBuffer paramInputBuffer)
  {
    this.buffer = paramInputBuffer;
    this.inputBufferEventSupport = new InputBufferEventSupport(this);
  }

  public void addInputBufferListener(InputBufferListener paramInputBufferListener)
  {
    this.inputBufferEventSupport.addInputBufferListener(paramInputBufferListener);
  }

  public void consume()
  {
    char c = ' ';
    try
    {
      c = this.buffer.LA(1);
    }
    catch (CharStreamException localCharStreamException)
    {
    }
    this.buffer.consume();
    if (this.debugMode)
      this.inputBufferEventSupport.fireConsume(c);
  }

  public void fill(int paramInt)
    throws CharStreamException
  {
    this.buffer.fill(paramInt);
  }

  public Vector getInputBufferListeners()
  {
    return this.inputBufferEventSupport.getInputBufferListeners();
  }

  public boolean isDebugMode()
  {
    return this.debugMode;
  }

  public boolean isMarked()
  {
    return this.buffer.isMarked();
  }

  public char LA(int paramInt)
    throws CharStreamException
  {
    char c = this.buffer.LA(paramInt);
    if (this.debugMode)
      this.inputBufferEventSupport.fireLA(c, paramInt);
    return c;
  }

  public int mark()
  {
    int i = this.buffer.mark();
    this.inputBufferEventSupport.fireMark(i);
    return i;
  }

  public void removeInputBufferListener(InputBufferListener paramInputBufferListener)
  {
    if (this.inputBufferEventSupport != null)
      this.inputBufferEventSupport.removeInputBufferListener(paramInputBufferListener);
  }

  public void rewind(int paramInt)
  {
    this.buffer.rewind(paramInt);
    this.inputBufferEventSupport.fireRewind(paramInt);
  }

  public void setDebugMode(boolean paramBoolean)
  {
    this.debugMode = paramBoolean;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.debug.DebuggingInputBuffer
 * JD-Core Version:    0.6.0
 */