/*     */ package com.sun.istack;
/*     */ 
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.stream.Location;
/*     */ import javax.xml.stream.XMLStreamException;
/*     */ import javax.xml.stream.XMLStreamReader;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.ContentHandler;
/*     */ import org.xml.sax.Locator;
/*     */ import org.xml.sax.SAXException;
/*     */ import org.xml.sax.helpers.AttributesImpl;
/*     */ 
/*     */ public class XMLStreamReaderToContentHandler
/*     */ {
/*     */   private final XMLStreamReader staxStreamReader;
/*     */   private final ContentHandler saxHandler;
/*     */   private boolean eagerQuit;
/*     */   private boolean fragment;
/*     */ 
/*     */   public XMLStreamReaderToContentHandler(XMLStreamReader staxCore, ContentHandler saxCore, boolean eagerQuit, boolean fragment)
/*     */   {
/*  50 */     this.staxStreamReader = staxCore;
/*  51 */     this.saxHandler = saxCore;
/*  52 */     this.eagerQuit = eagerQuit;
/*  53 */     this.fragment = fragment;
/*     */   }
/*     */ 
/*     */   public void bridge()
/*     */     throws XMLStreamException
/*     */   {
/*     */     try
/*     */     {
/*  63 */       int depth = 0;
/*     */ 
/*  66 */       int event = this.staxStreamReader.getEventType();
/*  67 */       if (event == 7)
/*     */       {
/*  69 */         while (!this.staxStreamReader.isStartElement()) {
/*  70 */           event = this.staxStreamReader.next();
/*     */         }
/*     */       }
/*     */ 
/*  74 */       if (event != 1) {
/*  75 */         throw new IllegalStateException("The current event is not START_ELEMENT\n but " + event);
/*     */       }
/*  77 */       handleStartDocument();
/*     */       do
/*     */       {
/*  84 */         switch (event) {
/*     */         case 1:
/*  86 */           depth++;
/*  87 */           handleStartElement();
/*  88 */           break;
/*     */         case 2:
/*  90 */           handleEndElement();
/*  91 */           depth--;
/*  92 */           if ((depth != 0) || (!this.eagerQuit)) break;
/*  93 */           break;
/*     */         case 4:
/*  96 */           handleCharacters();
/*  97 */           break;
/*     */         case 9:
/*  99 */           handleEntityReference();
/* 100 */           break;
/*     */         case 3:
/* 102 */           handlePI();
/* 103 */           break;
/*     */         case 5:
/* 105 */           handleComment();
/* 106 */           break;
/*     */         case 11:
/* 108 */           handleDTD();
/* 109 */           break;
/*     */         case 10:
/* 111 */           handleAttribute();
/* 112 */           break;
/*     */         case 13:
/* 114 */           handleNamespace();
/* 115 */           break;
/*     */         case 12:
/* 117 */           handleCDATA();
/* 118 */           break;
/*     */         case 15:
/* 120 */           handleEntityDecl();
/* 121 */           break;
/*     */         case 14:
/* 123 */           handleNotationDecl();
/* 124 */           break;
/*     */         case 6:
/* 126 */           handleSpace();
/* 127 */           break;
/*     */         case 7:
/*     */         case 8:
/*     */         default:
/* 129 */           throw new InternalError("processing event: " + event);
/*     */         }
/*     */ 
/* 132 */         event = this.staxStreamReader.next();
/* 133 */       }while (depth != 0);
/*     */ 
/* 135 */       handleEndDocument();
/*     */     } catch (SAXException e) {
/* 137 */       throw new XMLStreamException2(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void handleEndDocument() throws SAXException {
/* 142 */     if (this.fragment) {
/* 143 */       return;
/*     */     }
/* 145 */     this.saxHandler.endDocument();
/*     */   }
/*     */ 
/*     */   private void handleStartDocument() throws SAXException {
/* 149 */     if (this.fragment) {
/* 150 */       return;
/*     */     }
/* 152 */     this.saxHandler.setDocumentLocator(new Locator() {
/*     */       public int getColumnNumber() {
/* 154 */         return XMLStreamReaderToContentHandler.this.staxStreamReader.getLocation().getColumnNumber();
/*     */       }
/*     */       public int getLineNumber() {
/* 157 */         return XMLStreamReaderToContentHandler.this.staxStreamReader.getLocation().getLineNumber();
/*     */       }
/*     */       public String getPublicId() {
/* 160 */         return XMLStreamReaderToContentHandler.this.staxStreamReader.getLocation().getPublicId();
/*     */       }
/*     */       public String getSystemId() {
/* 163 */         return XMLStreamReaderToContentHandler.this.staxStreamReader.getLocation().getSystemId();
/*     */       }
/*     */     });
/* 166 */     this.saxHandler.startDocument();
/*     */   }
/*     */ 
/*     */   private void handlePI() throws XMLStreamException {
/*     */     try {
/* 171 */       this.saxHandler.processingInstruction(this.staxStreamReader.getPITarget(), this.staxStreamReader.getPIData());
/*     */     }
/*     */     catch (SAXException e)
/*     */     {
/* 175 */       throw new XMLStreamException2(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void handleCharacters() throws XMLStreamException {
/*     */     try {
/* 181 */       this.saxHandler.characters(this.staxStreamReader.getTextCharacters(), this.staxStreamReader.getTextStart(), this.staxStreamReader.getTextLength());
/*     */     }
/*     */     catch (SAXException e)
/*     */     {
/* 186 */       throw new XMLStreamException2(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void handleEndElement() throws XMLStreamException {
/* 191 */     QName qName = this.staxStreamReader.getName();
/*     */     try
/*     */     {
/* 194 */       String pfix = qName.getPrefix();
/* 195 */       String rawname = pfix + ':' + qName.getLocalPart();
/*     */ 
/* 199 */       this.saxHandler.endElement(qName.getNamespaceURI(), qName.getLocalPart(), rawname);
/*     */ 
/* 205 */       int nsCount = this.staxStreamReader.getNamespaceCount();
/* 206 */       for (int i = nsCount - 1; i >= 0; i--) {
/* 207 */         String prefix = this.staxStreamReader.getNamespacePrefix(i);
/* 208 */         if (prefix == null) {
/* 209 */           prefix = "";
/*     */         }
/* 211 */         this.saxHandler.endPrefixMapping(prefix);
/*     */       }
/*     */     } catch (SAXException e) {
/* 214 */       throw new XMLStreamException2(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void handleStartElement() throws XMLStreamException
/*     */   {
/*     */     try
/*     */     {
/* 222 */       int nsCount = this.staxStreamReader.getNamespaceCount();
/* 223 */       for (int i = 0; i < nsCount; i++) {
/* 224 */         this.saxHandler.startPrefixMapping(fixNull(this.staxStreamReader.getNamespacePrefix(i)), fixNull(this.staxStreamReader.getNamespaceURI(i)));
/*     */       }
/*     */ 
/* 230 */       QName qName = this.staxStreamReader.getName();
/* 231 */       String prefix = qName.getPrefix();
/*     */       String rawname;
/*     */       String rawname;
/* 233 */       if ((prefix == null) || (prefix.length() == 0))
/* 234 */         rawname = qName.getLocalPart();
/*     */       else
/* 236 */         rawname = prefix + ':' + qName.getLocalPart();
/* 237 */       Attributes attrs = getAttributes();
/* 238 */       this.saxHandler.startElement(qName.getNamespaceURI(), qName.getLocalPart(), rawname, attrs);
/*     */     }
/*     */     catch (SAXException e)
/*     */     {
/* 244 */       throw new XMLStreamException2(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static String fixNull(String s) {
/* 249 */     if (s == null) return "";
/* 250 */     return s;
/*     */   }
/*     */ 
/*     */   private Attributes getAttributes()
/*     */   {
/* 260 */     AttributesImpl attrs = new AttributesImpl();
/*     */ 
/* 262 */     int eventType = this.staxStreamReader.getEventType();
/* 263 */     if ((eventType != 10) && (eventType != 1))
/*     */     {
/* 265 */       throw new InternalError("getAttributes() attempting to process: " + eventType);
/*     */     }
/*     */ 
/* 274 */     for (int i = 0; i < this.staxStreamReader.getAttributeCount(); i++) {
/* 275 */       String uri = this.staxStreamReader.getAttributeNamespace(i);
/* 276 */       if (uri == null) uri = "";
/* 277 */       String localName = this.staxStreamReader.getAttributeLocalName(i);
/* 278 */       String prefix = this.staxStreamReader.getAttributePrefix(i);
/*     */       String qName;
/*     */       String qName;
/* 280 */       if ((prefix == null) || (prefix.length() == 0))
/* 281 */         qName = localName;
/*     */       else
/* 283 */         qName = prefix + ':' + localName;
/* 284 */       String type = this.staxStreamReader.getAttributeType(i);
/* 285 */       String value = this.staxStreamReader.getAttributeValue(i);
/*     */ 
/* 287 */       attrs.addAttribute(uri, localName, qName, type, value);
/*     */     }
/*     */ 
/* 290 */     return attrs;
/*     */   }
/*     */ 
/*     */   private void handleNamespace()
/*     */   {
/*     */   }
/*     */ 
/*     */   private void handleAttribute()
/*     */   {
/*     */   }
/*     */ 
/*     */   private void handleDTD()
/*     */   {
/*     */   }
/*     */ 
/*     */   private void handleComment()
/*     */   {
/*     */   }
/*     */ 
/*     */   private void handleEntityReference()
/*     */   {
/*     */   }
/*     */ 
/*     */   private void handleSpace()
/*     */   {
/*     */   }
/*     */ 
/*     */   private void handleNotationDecl()
/*     */   {
/*     */   }
/*     */ 
/*     */   private void handleEntityDecl()
/*     */   {
/*     */   }
/*     */ 
/*     */   private void handleCDATA()
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.istack.XMLStreamReaderToContentHandler
 * JD-Core Version:    0.6.0
 */