/*     */ package com.sun.xml.bind.unmarshaller;
/*     */ 
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.LocatorEx;
/*     */ import java.util.Enumeration;
/*     */ import javax.xml.bind.ValidationEventLocator;
/*     */ import javax.xml.bind.helpers.ValidationEventLocatorImpl;
/*     */ import org.w3c.dom.Attr;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.w3c.dom.ProcessingInstruction;
/*     */ import org.xml.sax.ContentHandler;
/*     */ import org.xml.sax.Locator;
/*     */ import org.xml.sax.SAXException;
/*     */ import org.xml.sax.helpers.AttributesImpl;
/*     */ import org.xml.sax.helpers.NamespaceSupport;
/*     */ 
/*     */ public class DOMScanner
/*     */   implements LocatorEx, InfosetScanner
/*     */ {
/*  76 */   private Node currentNode = null;
/*     */ 
/*  79 */   private final AttributesImpl atts = new AttributesImpl();
/*     */ 
/*  82 */   private ContentHandler receiver = null;
/*     */ 
/*  84 */   private Locator locator = this;
/*     */ 
/*     */   public void setLocator(Locator loc)
/*     */   {
/*  94 */     this.locator = loc;
/*     */   }
/*     */ 
/*     */   public void scan(Object node) throws SAXException {
/*  98 */     if ((node instanceof Document))
/*  99 */       scan((Document)node);
/*     */     else
/* 101 */       scan((Element)node);
/*     */   }
/*     */ 
/*     */   public void scan(Document doc) throws SAXException
/*     */   {
/* 106 */     scan(doc.getDocumentElement());
/*     */   }
/*     */ 
/*     */   public void scan(Element e) throws SAXException {
/* 110 */     setCurrentLocation(e);
/*     */ 
/* 112 */     this.receiver.setDocumentLocator(this.locator);
/* 113 */     this.receiver.startDocument();
/*     */ 
/* 115 */     NamespaceSupport nss = new NamespaceSupport();
/* 116 */     buildNamespaceSupport(nss, e.getParentNode());
/*     */ 
/* 118 */     for (Enumeration en = nss.getPrefixes(); en.hasMoreElements(); ) {
/* 119 */       String prefix = (String)en.nextElement();
/* 120 */       this.receiver.startPrefixMapping(prefix, nss.getURI(prefix));
/*     */     }
/*     */ 
/* 123 */     visit(e);
/*     */ 
/* 125 */     for (Enumeration en = nss.getPrefixes(); en.hasMoreElements(); ) {
/* 126 */       String prefix = (String)en.nextElement();
/* 127 */       this.receiver.endPrefixMapping(prefix);
/*     */     }
/*     */ 
/* 131 */     setCurrentLocation(e);
/* 132 */     this.receiver.endDocument();
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void parse(Element e, ContentHandler handler)
/*     */     throws SAXException
/*     */   {
/* 144 */     this.receiver = handler;
/*     */ 
/* 146 */     setCurrentLocation(e);
/* 147 */     this.receiver.startDocument();
/*     */ 
/* 149 */     this.receiver.setDocumentLocator(this.locator);
/* 150 */     visit(e);
/*     */ 
/* 152 */     setCurrentLocation(e);
/* 153 */     this.receiver.endDocument();
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void parseWithContext(Element e, ContentHandler handler)
/*     */     throws SAXException
/*     */   {
/* 164 */     setContentHandler(handler);
/* 165 */     scan(e);
/*     */   }
/*     */ 
/*     */   private void buildNamespaceSupport(NamespaceSupport nss, Node node)
/*     */   {
/* 172 */     if ((node == null) || (node.getNodeType() != 1)) {
/* 173 */       return;
/*     */     }
/* 175 */     buildNamespaceSupport(nss, node.getParentNode());
/*     */ 
/* 177 */     nss.pushContext();
/* 178 */     NamedNodeMap atts = node.getAttributes();
/* 179 */     for (int i = 0; i < atts.getLength(); i++) {
/* 180 */       Attr a = (Attr)atts.item(i);
/* 181 */       if ("xmlns".equals(a.getPrefix())) {
/* 182 */         nss.declarePrefix(a.getLocalName(), a.getValue());
/*     */       }
/* 185 */       else if ("xmlns".equals(a.getName()))
/* 186 */         nss.declarePrefix("", a.getValue());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void visit(Element e)
/*     */     throws SAXException
/*     */   {
/* 196 */     setCurrentLocation(e);
/* 197 */     NamedNodeMap attributes = e.getAttributes();
/*     */ 
/* 199 */     this.atts.clear();
/* 200 */     int len = attributes == null ? 0 : attributes.getLength();
/*     */ 
/* 202 */     for (int i = len - 1; i >= 0; i--) {
/* 203 */       Attr a = (Attr)attributes.item(i);
/* 204 */       String name = a.getName();
/*     */ 
/* 206 */       if (name.startsWith("xmlns")) {
/* 207 */         if (name.length() == 5) {
/* 208 */           this.receiver.startPrefixMapping("", a.getValue());
/*     */         } else {
/* 210 */           String localName = a.getLocalName();
/* 211 */           if (localName == null)
/*     */           {
/* 213 */             localName = name.substring(6);
/*     */           }
/* 215 */           this.receiver.startPrefixMapping(localName, a.getValue());
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 220 */         String uri = a.getNamespaceURI();
/* 221 */         if (uri == null) uri = "";
/*     */ 
/* 223 */         String local = a.getLocalName();
/* 224 */         if (local == null) local = a.getName();
/*     */ 
/* 227 */         this.atts.addAttribute(uri, local, a.getName(), "CDATA", a.getValue());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 235 */     String uri = e.getNamespaceURI();
/* 236 */     if (uri == null) uri = "";
/* 237 */     String local = e.getLocalName();
/* 238 */     String qname = e.getTagName();
/* 239 */     if (local == null) local = qname;
/* 240 */     this.receiver.startElement(uri, local, qname, this.atts);
/*     */ 
/* 243 */     NodeList children = e.getChildNodes();
/* 244 */     int clen = children.getLength();
/* 245 */     for (int i = 0; i < clen; i++) {
/* 246 */       visit(children.item(i));
/*     */     }
/*     */ 
/* 250 */     setCurrentLocation(e);
/* 251 */     this.receiver.endElement(uri, local, qname);
/*     */ 
/* 254 */     for (int i = len - 1; i >= 0; i--) {
/* 255 */       Attr a = (Attr)attributes.item(i);
/* 256 */       String name = a.getName();
/* 257 */       if (name.startsWith("xmlns"))
/* 258 */         if (name.length() == 5)
/* 259 */           this.receiver.endPrefixMapping("");
/*     */         else
/* 261 */           this.receiver.endPrefixMapping(a.getLocalName());
/*     */     }
/*     */   }
/*     */ 
/*     */   private void visit(Node n) throws SAXException
/*     */   {
/* 267 */     setCurrentLocation(n);
/*     */ 
/* 270 */     switch (n.getNodeType()) {
/*     */     case 3:
/*     */     case 4:
/* 273 */       String value = n.getNodeValue();
/* 274 */       this.receiver.characters(value.toCharArray(), 0, value.length());
/* 275 */       break;
/*     */     case 1:
/* 277 */       visit((Element)n);
/* 278 */       break;
/*     */     case 5:
/* 280 */       this.receiver.skippedEntity(n.getNodeName());
/* 281 */       break;
/*     */     case 7:
/* 283 */       ProcessingInstruction pi = (ProcessingInstruction)n;
/* 284 */       this.receiver.processingInstruction(pi.getTarget(), pi.getData());
/*     */     case 2:
/*     */     case 6:
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setCurrentLocation(Node currNode) {
/* 290 */     this.currentNode = currNode;
/*     */   }
/*     */ 
/*     */   public Node getCurrentLocation()
/*     */   {
/* 298 */     return this.currentNode;
/*     */   }
/*     */ 
/*     */   public Object getCurrentElement() {
/* 302 */     return this.currentNode;
/*     */   }
/*     */ 
/*     */   public LocatorEx getLocator() {
/* 306 */     return this;
/*     */   }
/*     */ 
/*     */   public void setContentHandler(ContentHandler handler) {
/* 310 */     this.receiver = handler;
/*     */   }
/*     */ 
/*     */   public ContentHandler getContentHandler() {
/* 314 */     return this.receiver;
/*     */   }
/*     */ 
/*     */   public String getPublicId()
/*     */   {
/* 319 */     return null; } 
/* 320 */   public String getSystemId() { return null; } 
/* 321 */   public int getLineNumber() { return -1; } 
/* 322 */   public int getColumnNumber() { return -1; }
/*     */ 
/*     */   public ValidationEventLocator getLocation() {
/* 325 */     return new ValidationEventLocatorImpl(getCurrentLocation());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.unmarshaller.DOMScanner
 * JD-Core Version:    0.6.0
 */