/*     */ package com.sun.xml.bind.v2.runtime.reflect;
/*     */ 
/*     */ import com.sun.xml.bind.api.AccessorException;
/*     */ import com.sun.xml.bind.v2.runtime.XMLSerializer;
/*     */ import java.util.Map;
/*     */ 
/*     */ final class PrimitiveArrayListerCharacter<BeanT> extends Lister<BeanT, char[], Character, CharacterArrayPack>
/*     */ {
/*     */   static void register()
/*     */   {
/*  55 */     Lister.primitiveArrayListers.put(Character.TYPE, new PrimitiveArrayListerCharacter());
/*     */   }
/*     */ 
/*     */   public ListIterator<Character> iterator(char[] objects, XMLSerializer context) {
/*  59 */     return new ListIterator(objects) {
/*  60 */       int idx = 0;
/*     */ 
/*  62 */       public boolean hasNext() { return this.idx < this.val$objects.length; }
/*     */ 
/*     */       public Character next()
/*     */       {
/*  66 */         return Character.valueOf(this.val$objects[(this.idx++)]);
/*     */       } } ;
/*     */   }
/*     */ 
/*     */   public CharacterArrayPack startPacking(BeanT current, Accessor<BeanT, char[]> acc) {
/*  72 */     return new CharacterArrayPack();
/*     */   }
/*     */ 
/*     */   public void addToPack(CharacterArrayPack objects, Character o) {
/*  76 */     objects.add(o);
/*     */   }
/*     */ 
/*     */   public void endPacking(CharacterArrayPack pack, BeanT bean, Accessor<BeanT, char[]> acc) throws AccessorException {
/*  80 */     acc.set(bean, pack.build());
/*     */   }
/*     */ 
/*     */   public void reset(BeanT o, Accessor<BeanT, char[]> acc) throws AccessorException {
/*  84 */     acc.set(o, new char[0]);
/*     */   }
/*  88 */   static final class CharacterArrayPack { char[] buf = new char[16];
/*     */     int size;
/*     */ 
/*     */     void add(Character b) {
/*  92 */       if (this.buf.length == this.size)
/*     */       {
/*  94 */         char[] nb = new char[this.buf.length * 2];
/*  95 */         System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
/*  96 */         this.buf = nb;
/*     */       }
/*  98 */       this.buf[(this.size++)] = b.charValue();
/*     */     }
/*     */ 
/*     */     char[] build() {
/* 102 */       if (this.buf.length == this.size)
/*     */       {
/* 104 */         return this.buf;
/*     */       }
/* 106 */       char[] r = new char[this.size];
/* 107 */       System.arraycopy(this.buf, 0, r, 0, this.size);
/* 108 */       return r;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerCharacter
 * JD-Core Version:    0.6.0
 */