/*     */ package com.sun.xml.bind.v2.runtime.reflect;
/*     */ 
/*     */ import com.sun.xml.bind.api.AccessorException;
/*     */ import com.sun.xml.bind.v2.runtime.XMLSerializer;
/*     */ import java.util.Map;
/*     */ 
/*     */ final class PrimitiveArrayListerInteger<BeanT> extends Lister<BeanT, int[], Integer, IntegerArrayPack>
/*     */ {
/*     */   static void register()
/*     */   {
/*  55 */     Lister.primitiveArrayListers.put(Integer.TYPE, new PrimitiveArrayListerInteger());
/*     */   }
/*     */ 
/*     */   public ListIterator<Integer> iterator(int[] objects, XMLSerializer context) {
/*  59 */     return new ListIterator(objects) {
/*  60 */       int idx = 0;
/*     */ 
/*  62 */       public boolean hasNext() { return this.idx < this.val$objects.length; }
/*     */ 
/*     */       public Integer next()
/*     */       {
/*  66 */         return Integer.valueOf(this.val$objects[(this.idx++)]);
/*     */       } } ;
/*     */   }
/*     */ 
/*     */   public IntegerArrayPack startPacking(BeanT current, Accessor<BeanT, int[]> acc) {
/*  72 */     return new IntegerArrayPack();
/*     */   }
/*     */ 
/*     */   public void addToPack(IntegerArrayPack objects, Integer o) {
/*  76 */     objects.add(o);
/*     */   }
/*     */ 
/*     */   public void endPacking(IntegerArrayPack pack, BeanT bean, Accessor<BeanT, int[]> acc) throws AccessorException {
/*  80 */     acc.set(bean, pack.build());
/*     */   }
/*     */ 
/*     */   public void reset(BeanT o, Accessor<BeanT, int[]> acc) throws AccessorException {
/*  84 */     acc.set(o, new int[0]);
/*     */   }
/*  88 */   static final class IntegerArrayPack { int[] buf = new int[16];
/*     */     int size;
/*     */ 
/*     */     void add(Integer b) {
/*  92 */       if (this.buf.length == this.size)
/*     */       {
/*  94 */         int[] nb = new int[this.buf.length * 2];
/*  95 */         System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
/*  96 */         this.buf = nb;
/*     */       }
/*  98 */       this.buf[(this.size++)] = b.intValue();
/*     */     }
/*     */ 
/*     */     int[] build() {
/* 102 */       if (this.buf.length == this.size)
/*     */       {
/* 104 */         return this.buf;
/*     */       }
/* 106 */       int[] r = new int[this.size];
/* 107 */       System.arraycopy(this.buf, 0, r, 0, this.size);
/* 108 */       return r;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerInteger
 * JD-Core Version:    0.6.0
 */