/*     */ package com.sun.xml.bind.v2.runtime.reflect.opt;
/*     */ 
/*     */ import com.sun.xml.bind.Util;
/*     */ import com.sun.xml.bind.v2.bytecode.ClassTailor;
/*     */ import com.sun.xml.bind.v2.runtime.reflect.Accessor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.logging.Level;
/*     */ import java.util.logging.Logger;
/*     */ 
/*     */ public abstract class OptimizedAccessorFactory
/*     */ {
/*  57 */   private static final Logger logger = Util.getClassLogger();
/*     */   private static final String fieldTemplateName;
/*     */   private static final String methodTemplateName;
/*     */ 
/*     */   public static final <B, V> Accessor<B, V> get(Method getter, Method setter)
/*     */   {
/*  79 */     if (getter.getParameterTypes().length != 0)
/*  80 */       return null;
/*  81 */     Class[] sparams = setter.getParameterTypes();
/*  82 */     if (sparams.length != 1)
/*  83 */       return null;
/*  84 */     if (sparams[0] != getter.getReturnType())
/*  85 */       return null;
/*  86 */     if (setter.getReturnType() != Void.TYPE)
/*  87 */       return null;
/*  88 */     if (getter.getDeclaringClass() != setter.getDeclaringClass())
/*  89 */       return null;
/*  90 */     if ((Modifier.isPrivate(getter.getModifiers())) || (Modifier.isPrivate(setter.getModifiers())))
/*     */     {
/*  92 */       return null;
/*     */     }
/*     */ 
/*  95 */     Class t = sparams[0];
/*  96 */     String typeName = t.getName().replace('.', '_');
/*     */ 
/*  98 */     String newClassName = ClassTailor.toVMClassName(getter.getDeclaringClass()) + "$JaxbAccessorM_" + getter.getName() + '_' + setter.getName() + '_' + typeName;
/*     */     Class opt;
/*     */     Class opt;
/* 102 */     if (t.isPrimitive()) {
/* 103 */       opt = AccessorInjector.prepare(getter.getDeclaringClass(), methodTemplateName + t.getName(), newClassName, new String[] { ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(getter.getDeclaringClass()), "get_" + t.getName(), getter.getName(), "set_" + t.getName(), setter.getName() });
/*     */     }
/*     */     else
/*     */     {
/* 113 */       opt = AccessorInjector.prepare(getter.getDeclaringClass(), methodTemplateName + "Ref", newClassName, new String[] { ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(getter.getDeclaringClass()), ClassTailor.toVMClassName(Ref.class), ClassTailor.toVMClassName(t), "()" + ClassTailor.toVMTypeName(Ref.class), "()" + ClassTailor.toVMTypeName(t), '(' + ClassTailor.toVMTypeName(Ref.class) + ")V", '(' + ClassTailor.toVMTypeName(t) + ")V", "get_ref", getter.getName(), "set_ref", setter.getName() });
/*     */     }
/*     */ 
/* 129 */     if (opt == null) {
/* 130 */       return null;
/*     */     }
/* 132 */     Accessor acc = instanciate(opt);
/* 133 */     if (acc != null)
/* 134 */       logger.log(Level.FINE, "Using optimized Accessor for " + getter + " and " + setter);
/* 135 */     return acc;
/*     */   }
/*     */ 
/*     */   public static final <B, V> Accessor<B, V> get(Field field)
/*     */   {
/* 146 */     int mods = field.getModifiers();
/* 147 */     if ((Modifier.isPrivate(mods)) || (Modifier.isFinal(mods)))
/*     */     {
/* 149 */       return null;
/*     */     }
/* 151 */     String newClassName = ClassTailor.toVMClassName(field.getDeclaringClass()) + "$JaxbAccessorF_" + field.getName();
/*     */     Class opt;
/*     */     Class opt;
/* 155 */     if (field.getType().isPrimitive()) {
/* 156 */       opt = AccessorInjector.prepare(field.getDeclaringClass(), fieldTemplateName + field.getType().getName(), newClassName, new String[] { ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(field.getDeclaringClass()), "f_" + field.getType().getName(), field.getName() });
/*     */     }
/*     */     else
/*     */     {
/* 164 */       opt = AccessorInjector.prepare(field.getDeclaringClass(), fieldTemplateName + "Ref", newClassName, new String[] { ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(field.getDeclaringClass()), ClassTailor.toVMClassName(Ref.class), ClassTailor.toVMClassName(field.getType()), ClassTailor.toVMTypeName(Ref.class), ClassTailor.toVMTypeName(field.getType()), "f_ref", field.getName() });
/*     */     }
/*     */ 
/* 176 */     if (opt == null) {
/* 177 */       return null;
/*     */     }
/* 179 */     Accessor acc = instanciate(opt);
/* 180 */     if (acc != null)
/* 181 */       logger.log(Level.FINE, "Using optimized Accessor for " + field);
/* 182 */     return acc;
/*     */   }
/*     */ 
/*     */   private static <B, V> Accessor<B, V> instanciate(Class opt) {
/*     */     try {
/* 187 */       return (Accessor)opt.newInstance();
/*     */     } catch (InstantiationException e) {
/* 189 */       logger.log(Level.INFO, "failed to load an optimized Accessor", e);
/*     */     } catch (IllegalAccessException e) {
/* 191 */       logger.log(Level.INFO, "failed to load an optimized Accessor", e);
/*     */     } catch (SecurityException e) {
/* 193 */       logger.log(Level.INFO, "failed to load an optimized Accessor", e);
/*     */     }
/* 195 */     return null;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  64 */     String s = FieldAccessor_Byte.class.getName();
/*  65 */     fieldTemplateName = s.substring(0, s.length() - "Byte".length()).replace('.', '/');
/*     */ 
/*  67 */     s = MethodAccessor_Byte.class.getName();
/*  68 */     methodTemplateName = s.substring(0, s.length() - "Byte".length()).replace('.', '/');
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.reflect.opt.OptimizedAccessorFactory
 * JD-Core Version:    0.6.0
 */