/*      */ package com.sun.xml.bind.v2.schemagen;
/*      */ 
/*      */ import com.sun.istack.NotNull;
/*      */ import com.sun.istack.Nullable;
/*      */ import com.sun.xml.bind.api.CompositeStructure;
/*      */ import com.sun.xml.bind.api.ErrorListener;
/*      */ import com.sun.xml.bind.v2.TODO;
/*      */ import com.sun.xml.bind.v2.model.core.Adapter;
/*      */ import com.sun.xml.bind.v2.model.core.ArrayInfo;
/*      */ import com.sun.xml.bind.v2.model.core.AttributePropertyInfo;
/*      */ import com.sun.xml.bind.v2.model.core.ClassInfo;
/*      */ import com.sun.xml.bind.v2.model.core.Element;
/*      */ import com.sun.xml.bind.v2.model.core.ElementInfo;
/*      */ import com.sun.xml.bind.v2.model.core.ElementPropertyInfo;
/*      */ import com.sun.xml.bind.v2.model.core.EnumConstant;
/*      */ import com.sun.xml.bind.v2.model.core.EnumLeafInfo;
/*      */ import com.sun.xml.bind.v2.model.core.ID;
/*      */ import com.sun.xml.bind.v2.model.core.MapPropertyInfo;
/*      */ import com.sun.xml.bind.v2.model.core.NonElement;
/*      */ import com.sun.xml.bind.v2.model.core.NonElementRef;
/*      */ import com.sun.xml.bind.v2.model.core.PropertyInfo;
/*      */ import com.sun.xml.bind.v2.model.core.PropertyKind;
/*      */ import com.sun.xml.bind.v2.model.core.ReferencePropertyInfo;
/*      */ import com.sun.xml.bind.v2.model.core.TypeInfo;
/*      */ import com.sun.xml.bind.v2.model.core.TypeInfoSet;
/*      */ import com.sun.xml.bind.v2.model.core.TypeRef;
/*      */ import com.sun.xml.bind.v2.model.core.ValuePropertyInfo;
/*      */ import com.sun.xml.bind.v2.model.core.WildcardMode;
/*      */ import com.sun.xml.bind.v2.model.nav.Navigator;
/*      */ import com.sun.xml.bind.v2.runtime.SwaRefAdapter;
/*      */ import com.sun.xml.bind.v2.schemagen.episode.Bindings;
/*      */ import com.sun.xml.bind.v2.schemagen.episode.Klass;
/*      */ import com.sun.xml.bind.v2.schemagen.episode.SchemaBindings;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.Any;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.AttrDecls;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.AttributeType;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.ComplexContent;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.ComplexExtension;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.ComplexType;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.ComplexTypeHost;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.ContentModelContainer;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.ExplicitGroup;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.Import;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.LocalAttribute;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.LocalElement;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.NoFixedFacet;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.Occurs;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.Schema;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.SimpleContent;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.SimpleExtension;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.SimpleRestrictionModel;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.SimpleType;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.SimpleTypeHost;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.TopLevelAttribute;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.TopLevelElement;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.TypeDefParticle;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.TypeHost;
/*      */ import com.sun.xml.bind.v2.schemagen.xmlschema.Wildcard;
/*      */ import com.sun.xml.bind.v2.util.CollisionCheckStack;
/*      */ import com.sun.xml.txw2.TXW;
/*      */ import com.sun.xml.txw2.TxwException;
/*      */ import com.sun.xml.txw2.TypedXmlWriter;
/*      */ import com.sun.xml.txw2.output.ResultFactory;
/*      */ import com.sun.xml.txw2.output.XmlSerializer;
/*      */ import java.io.File;
/*      */ import java.io.IOException;
/*      */ import java.io.OutputStream;
/*      */ import java.io.Writer;
/*      */ import java.net.URI;
/*      */ import java.net.URISyntaxException;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Comparator;
/*      */ import java.util.HashMap;
/*      */ import java.util.LinkedHashSet;
/*      */ import java.util.Map;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Set;
/*      */ import java.util.TreeMap;
/*      */ import java.util.logging.Level;
/*      */ import java.util.logging.Logger;
/*      */ import javax.activation.MimeType;
/*      */ import javax.xml.bind.SchemaOutputResolver;
/*      */ import javax.xml.namespace.QName;
/*      */ import javax.xml.transform.Result;
/*      */ import javax.xml.transform.stream.StreamResult;
/*      */ import org.xml.sax.SAXParseException;
/*      */ 
/*      */ public final class XmlSchemaGenerator<T, C, F, M>
/*      */ {
/*      */   private static final Logger logger;
/*  150 */   private final Map<String, XmlSchemaGenerator<T, C, F, M>.Namespace> namespaces = new TreeMap(NAMESPACE_COMPARATOR);
/*      */   private ErrorListener errorListener;
/*      */   private Navigator<T, C, F, M> navigator;
/*      */   private final TypeInfoSet<T, C, F, M> types;
/*      */   private final NonElement<T, C> stringType;
/*      */   private final NonElement<T, C> anyType;
/*  175 */   private final CollisionCheckStack<ClassInfo<T, C>> collisionChecker = new CollisionCheckStack();
/*      */   private static final Comparator<String> NAMESPACE_COMPARATOR;
/*      */   private static final String newline = "\n";
/*      */ 
/*      */   public XmlSchemaGenerator(Navigator<T, C, F, M> navigator, TypeInfoSet<T, C, F, M> types)
/*      */   {
/*  178 */     this.navigator = navigator;
/*  179 */     this.types = types;
/*      */ 
/*  181 */     this.stringType = types.getTypeInfo(navigator.ref(String.class));
/*  182 */     this.anyType = types.getAnyTypeInfo();
/*      */ 
/*  185 */     for (ClassInfo ci : types.beans().values())
/*  186 */       add(ci);
/*  187 */     for (ElementInfo ei1 : types.getElementMappings(null).values())
/*  188 */       add(ei1);
/*  189 */     for (EnumLeafInfo ei : types.enums().values())
/*  190 */       add(ei);
/*  191 */     for (ArrayInfo a : types.arrays().values())
/*  192 */       add(a);
/*      */   }
/*      */ 
/*      */   private XmlSchemaGenerator<T, C, F, M>.Namespace getNamespace(String uri) {
/*  196 */     Namespace n = (Namespace)this.namespaces.get(uri);
/*  197 */     if (n == null)
/*  198 */       this.namespaces.put(uri, n = new Namespace(uri));
/*  199 */     return n;
/*      */   }
/*      */ 
/*      */   public void add(ClassInfo<T, C> clazz)
/*      */   {
/*  211 */     assert (clazz != null);
/*      */ 
/*  213 */     String nsUri = null;
/*      */ 
/*  215 */     if (clazz.getClazz() == this.navigator.asDecl(CompositeStructure.class)) {
/*  216 */       return;
/*      */     }
/*  218 */     if (clazz.isElement())
/*      */     {
/*  220 */       nsUri = clazz.getElementName().getNamespaceURI();
/*  221 */       Namespace ns = getNamespace(nsUri);
/*  222 */       ns.classes.add(clazz);
/*  223 */       ns.addDependencyTo(clazz.getTypeName());
/*      */ 
/*  226 */       add(clazz.getElementName(), false, clazz);
/*      */     }
/*      */ 
/*  229 */     QName tn = clazz.getTypeName();
/*  230 */     if (tn != null) {
/*  231 */       nsUri = tn.getNamespaceURI();
/*      */     }
/*  234 */     else if (nsUri == null) {
/*  235 */       return;
/*      */     }
/*      */ 
/*  238 */     Namespace n = getNamespace(nsUri);
/*  239 */     n.classes.add(clazz);
/*      */ 
/*  242 */     for (PropertyInfo p : clazz.getProperties()) {
/*  243 */       n.processForeignNamespaces(p);
/*  244 */       if ((p instanceof AttributePropertyInfo)) {
/*  245 */         AttributePropertyInfo ap = (AttributePropertyInfo)p;
/*  246 */         String aUri = ap.getXmlName().getNamespaceURI();
/*  247 */         if (aUri.length() > 0)
/*      */         {
/*  249 */           getNamespace(aUri).addGlobalAttribute(ap);
/*  250 */           n.addDependencyTo(ap.getXmlName());
/*      */         }
/*      */       }
/*  253 */       if ((p instanceof ElementPropertyInfo)) {
/*  254 */         ElementPropertyInfo ep = (ElementPropertyInfo)p;
/*  255 */         for (TypeRef tref : ep.getTypes()) {
/*  256 */           String eUri = tref.getTagName().getNamespaceURI();
/*  257 */           if ((eUri.length() > 0) && (!eUri.equals(n.uri))) {
/*  258 */             getNamespace(eUri).addGlobalElement(tref);
/*  259 */             n.addDependencyTo(tref.getTagName());
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*  264 */       if (generateSwaRefAdapter(p)) {
/*  265 */         Namespace.access$302(n, true);
/*      */       }
/*      */     }
/*      */ 
/*  269 */     ClassInfo bc = clazz.getBaseClass();
/*  270 */     if (bc != null) {
/*  271 */       add(bc);
/*  272 */       n.addDependencyTo(bc.getTypeName());
/*      */     }
/*      */   }
/*      */ 
/*      */   public void add(ElementInfo<T, C> elem)
/*      */   {
/*  280 */     assert (elem != null);
/*      */ 
/*  282 */     QName name = elem.getElementName();
/*  283 */     Namespace n = getNamespace(name.getNamespaceURI());
/*      */     Namespace tmp47_46 = n; tmp47_46.getClass(); n.elementDecls.put(name.getLocalPart(), new XmlSchemaGenerator.Namespace.ElementWithType(tmp47_46, true, elem.getContentType()));
/*      */ 
/*  287 */     n.processForeignNamespaces(elem.getProperty());
/*      */   }
/*      */ 
/*      */   public void add(EnumLeafInfo<T, C> envm) {
/*  291 */     assert (envm != null);
/*      */ 
/*  293 */     String nsUri = null;
/*      */ 
/*  295 */     if (envm.isElement())
/*      */     {
/*  297 */       nsUri = envm.getElementName().getNamespaceURI();
/*  298 */       Namespace ns = getNamespace(nsUri);
/*  299 */       ns.enums.add(envm);
/*  300 */       ns.addDependencyTo(envm.getTypeName());
/*      */ 
/*  303 */       add(envm.getElementName(), false, envm);
/*      */     }
/*      */ 
/*  306 */     QName typeName = envm.getTypeName();
/*  307 */     if (typeName != null) {
/*  308 */       nsUri = typeName.getNamespaceURI();
/*      */     }
/*  310 */     else if (nsUri == null) {
/*  311 */       return;
/*      */     }
/*      */ 
/*  314 */     Namespace n = getNamespace(nsUri);
/*  315 */     n.enums.add(envm);
/*      */ 
/*  318 */     n.addDependencyTo(envm.getBaseType().getTypeName());
/*      */   }
/*      */ 
/*      */   public void add(ArrayInfo<T, C> a) {
/*  322 */     assert (a != null);
/*      */ 
/*  324 */     String namespaceURI = a.getTypeName().getNamespaceURI();
/*  325 */     Namespace n = getNamespace(namespaceURI);
/*  326 */     n.arrays.add(a);
/*      */ 
/*  329 */     n.addDependencyTo(a.getItemType().getTypeName());
/*      */   }
/*      */ 
/*      */   public void add(QName tagName, boolean isNillable, NonElement<T, C> type)
/*      */   {
/*  343 */     if ((type != null) && (type.getType() == this.navigator.ref(CompositeStructure.class))) {
/*  344 */       return;
/*      */     }
/*      */ 
/*  347 */     Namespace n = getNamespace(tagName.getNamespaceURI());
/*      */     Namespace tmp51_49 = n; tmp51_49.getClass(); n.elementDecls.put(tagName.getLocalPart(), new XmlSchemaGenerator.Namespace.ElementWithType(tmp51_49, isNillable, type));
/*      */ 
/*  351 */     if (type != null)
/*  352 */       n.addDependencyTo(type.getTypeName());
/*      */   }
/*      */ 
/*      */   public void writeEpisodeFile(XmlSerializer out)
/*      */   {
/*  359 */     Bindings root = (Bindings)TXW.create(Bindings.class, out);
/*      */ 
/*  361 */     if (this.namespaces.containsKey(""))
/*  362 */       root._namespace("http://java.sun.com/xml/ns/jaxb", "jaxb");
/*  363 */     root.version("2.1");
/*      */ 
/*  367 */     for (Map.Entry e : this.namespaces.entrySet()) {
/*  368 */       Bindings group = root.bindings();
/*      */ 
/*  371 */       String tns = (String)e.getKey();
/*      */       String prefix;
/*      */       String prefix;
/*  372 */       if (!tns.equals("")) {
/*  373 */         group._namespace(tns, "tns");
/*  374 */         prefix = "tns:";
/*      */       } else {
/*  376 */         prefix = "";
/*      */       }
/*      */ 
/*  379 */       group.scd("x-schema::" + (tns.equals("") ? "" : "tns"));
/*  380 */       group.schemaBindings().map(false);
/*      */ 
/*  382 */       for (ClassInfo ci : ((Namespace)e.getValue()).classes) {
/*  383 */         if (ci.getTypeName() == null)
/*      */           continue;
/*  385 */         if (ci.getTypeName().getNamespaceURI().equals(tns)) {
/*  386 */           Bindings child = group.bindings();
/*  387 */           child.scd('~' + prefix + ci.getTypeName().getLocalPart());
/*  388 */           child.klass().ref(ci.getName());
/*      */         }
/*      */ 
/*  391 */         if ((ci.isElement()) && (ci.getElementName().getNamespaceURI().equals(tns))) {
/*  392 */           Bindings child = group.bindings();
/*  393 */           child.scd(prefix + ci.getElementName().getLocalPart());
/*  394 */           child.klass().ref(ci.getName());
/*      */         }
/*      */       }
/*      */ 
/*  398 */       for (EnumLeafInfo en : ((Namespace)e.getValue()).enums) {
/*  399 */         if (en.getTypeName() == null)
/*      */           continue;
/*  401 */         Bindings child = group.bindings();
/*  402 */         child.scd('~' + prefix + en.getTypeName().getLocalPart());
/*  403 */         child.klass().ref(this.navigator.getClassName(en.getClazz()));
/*      */       }
/*      */ 
/*  406 */       group.commit(true);
/*      */     }
/*      */ 
/*  409 */     root.commit();
/*      */   }
/*      */ 
/*      */   public void write(SchemaOutputResolver resolver, ErrorListener errorListener)
/*      */     throws IOException
/*      */   {
/*  416 */     if (resolver == null) {
/*  417 */       throw new IllegalArgumentException();
/*      */     }
/*      */ 
/*  420 */     resolver = new FoolProofResolver(resolver);
/*  421 */     this.errorListener = errorListener;
/*      */ 
/*  423 */     Map schemaLocations = this.types.getSchemaLocations();
/*      */ 
/*  425 */     Map out = new HashMap();
/*  426 */     Map systemIds = new HashMap();
/*      */ 
/*  430 */     this.namespaces.remove("http://www.w3.org/2001/XMLSchema");
/*      */ 
/*  434 */     for (Namespace n : this.namespaces.values()) {
/*  435 */       String schemaLocation = (String)schemaLocations.get(n.uri);
/*  436 */       if (schemaLocation != null) {
/*  437 */         systemIds.put(n, schemaLocation);
/*      */       } else {
/*  439 */         Result output = resolver.createOutput(n.uri, "schema" + (out.size() + 1) + ".xsd");
/*  440 */         if (output != null) {
/*  441 */           out.put(n, output);
/*  442 */           systemIds.put(n, output.getSystemId());
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  448 */     for (Map.Entry e : out.entrySet()) {
/*  449 */       Result result = (Result)e.getValue();
/*  450 */       ((Namespace)e.getKey()).writeTo(result, systemIds);
/*  451 */       if ((result instanceof StreamResult)) {
/*  452 */         OutputStream outputStream = ((StreamResult)result).getOutputStream();
/*  453 */         if (outputStream != null) {
/*  454 */           outputStream.close();
/*      */         } else {
/*  456 */           Writer writer = ((StreamResult)result).getWriter();
/*  457 */           if (writer != null) writer.close();
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean generateSwaRefAdapter(NonElementRef<T, C> typeRef)
/*      */   {
/* 1339 */     return generateSwaRefAdapter(typeRef.getSource());
/*      */   }
/*      */ 
/*      */   private boolean generateSwaRefAdapter(PropertyInfo<T, C> prop)
/*      */   {
/* 1346 */     Adapter adapter = prop.getAdapter();
/* 1347 */     if (adapter == null) return false;
/* 1348 */     Object o = this.navigator.asDecl(SwaRefAdapter.class);
/* 1349 */     if (o == null) return false;
/* 1350 */     return o.equals(adapter.adapterType);
/*      */   }
/*      */ 
/*      */   private static String getProcessContentsModeName(WildcardMode wc)
/*      */   {
/* 1359 */     switch (2.$SwitchMap$com$sun$xml$bind$v2$model$core$WildcardMode[wc.ordinal()]) {
/*      */     case 1:
/*      */     case 2:
/* 1362 */       return wc.name().toLowerCase();
/*      */     case 3:
/* 1364 */       return null;
/*      */     }
/* 1366 */     throw new IllegalStateException();
/*      */   }
/*      */ 
/*      */   protected static String relativize(String uri, String baseUri)
/*      */   {
/*      */     try
/*      */     {
/* 1391 */       assert (uri != null);
/*      */ 
/* 1393 */       if (baseUri == null) return uri;
/*      */ 
/* 1395 */       URI theUri = new URI(Util.escapeURI(uri));
/* 1396 */       URI theBaseUri = new URI(Util.escapeURI(baseUri));
/*      */ 
/* 1398 */       if ((theUri.isOpaque()) || (theBaseUri.isOpaque())) {
/* 1399 */         return uri;
/*      */       }
/* 1401 */       if ((!Util.equalsIgnoreCase(theUri.getScheme(), theBaseUri.getScheme())) || (!Util.equal(theUri.getAuthority(), theBaseUri.getAuthority())))
/*      */       {
/* 1403 */         return uri;
/*      */       }
/* 1405 */       String uriPath = theUri.getPath();
/* 1406 */       String basePath = theBaseUri.getPath();
/*      */ 
/* 1409 */       if (!basePath.endsWith("/")) {
/* 1410 */         basePath = Util.normalizeUriPath(basePath);
/*      */       }
/*      */ 
/* 1413 */       if (uriPath.equals(basePath)) {
/* 1414 */         return ".";
/*      */       }
/* 1416 */       String relPath = calculateRelativePath(uriPath, basePath, fixNull(theUri.getScheme()).equals("file"));
/*      */ 
/* 1418 */       if (relPath == null)
/* 1419 */         return uri;
/* 1420 */       StringBuffer relUri = new StringBuffer();
/* 1421 */       relUri.append(relPath);
/* 1422 */       if (theUri.getQuery() != null)
/* 1423 */         relUri.append('?').append(theUri.getQuery());
/* 1424 */       if (theUri.getFragment() != null) {
/* 1425 */         relUri.append('#').append(theUri.getFragment());
/*      */       }
/* 1427 */       return relUri.toString(); } catch (URISyntaxException e) {
/*      */     }
/* 1429 */     throw new InternalError("Error escaping one of these uris:\n\t" + uri + "\n\t" + baseUri);
/*      */   }
/*      */ 
/*      */   private static String fixNull(String s)
/*      */   {
/* 1434 */     if (s == null) return "";
/* 1435 */     return s;
/*      */   }
/*      */ 
/*      */   private static String calculateRelativePath(String uri, String base, boolean fileUrl)
/*      */   {
/* 1441 */     boolean onWindows = File.pathSeparatorChar == ';';
/*      */ 
/* 1443 */     if (base == null) {
/* 1444 */       return null;
/*      */     }
/* 1446 */     if (((fileUrl) && (onWindows) && (startsWithIgnoreCase(uri, base))) || (uri.startsWith(base))) {
/* 1447 */       return uri.substring(base.length());
/*      */     }
/* 1449 */     return "../" + calculateRelativePath(uri, Util.getParentUriPath(base), fileUrl);
/*      */   }
/*      */ 
/*      */   private static boolean startsWithIgnoreCase(String s, String t)
/*      */   {
/* 1454 */     return s.toUpperCase().startsWith(t.toUpperCase());
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*  139 */     logger = com.sun.xml.bind.Util.getClassLogger();
/*      */ 
/* 1461 */     NAMESPACE_COMPARATOR = new Comparator() {
/*      */       public int compare(String lhs, String rhs) {
/* 1463 */         return -lhs.compareTo(rhs);
/*      */       }
/*      */     };
/*      */   }
/*      */ 
/*      */   private class Namespace
/*      */   {
/*      */ 
/*      */     @NotNull
/*      */     final String uri;
/*  474 */     private final Set<XmlSchemaGenerator<T, C, F, M>.Namespace> depends = new LinkedHashSet();
/*      */     private boolean selfReference;
/*  484 */     private final Set<ClassInfo<T, C>> classes = new LinkedHashSet();
/*      */ 
/*  489 */     private final Set<EnumLeafInfo<T, C>> enums = new LinkedHashSet();
/*      */ 
/*  494 */     private final Set<ArrayInfo<T, C>> arrays = new LinkedHashSet();
/*      */ 
/*  499 */     private final MultiMap<String, AttributePropertyInfo<T, C>> attributeDecls = new MultiMap(null);
/*      */ 
/*  504 */     private final MultiMap<String, XmlSchemaGenerator<T, C, F, M>.Namespace.ElementDeclaration> elementDecls = new MultiMap(new ElementWithType(true, XmlSchemaGenerator.this.anyType));
/*      */     private Form attributeFormDefault;
/*      */     private Form elementFormDefault;
/*      */     private boolean useSwaRef;
/*      */ 
/*      */     public Namespace(String uri)
/*      */     {
/*  517 */       this.uri = uri;
/*  518 */       assert (!XmlSchemaGenerator.this.namespaces.containsKey(uri));
/*  519 */       XmlSchemaGenerator.this.namespaces.put(uri, this);
/*      */     }
/*      */ 
/*      */     private void processForeignNamespaces(PropertyInfo<T, C> p)
/*      */     {
/*  533 */       for (TypeInfo t : p.ref()) {
/*  534 */         if ((t instanceof Element)) {
/*  535 */           addDependencyTo(((Element)t).getElementName());
/*      */         }
/*  537 */         if ((t instanceof NonElement))
/*  538 */           addDependencyTo(((NonElement)t).getTypeName());
/*      */       }
/*      */     }
/*      */ 
/*      */     private void addDependencyTo(@Nullable QName qname)
/*      */     {
/*  547 */       if (qname == null) return;
/*      */ 
/*  549 */       String nsUri = qname.getNamespaceURI();
/*      */ 
/*  551 */       if (nsUri.equals("http://www.w3.org/2001/XMLSchema"))
/*      */       {
/*  553 */         return;
/*      */       }
/*  555 */       if (nsUri.equals(this.uri)) {
/*  556 */         this.selfReference = true;
/*  557 */         return;
/*      */       }
/*      */ 
/*  561 */       this.depends.add(XmlSchemaGenerator.this.getNamespace(nsUri));
/*      */     }
/*      */ 
/*      */     private void writeTo(Result result, Map<XmlSchemaGenerator<T, C, F, M>.Namespace, String> systemIds)
/*      */       throws IOException
/*      */     {
/*      */       try
/*      */       {
/*  572 */         Schema schema = (Schema)TXW.create(Schema.class, ResultFactory.createSerializer(result));
/*      */ 
/*  575 */         Map xmlNs = XmlSchemaGenerator.this.types.getXmlNs(this.uri);
/*      */ 
/*  577 */         for (Map.Entry e : xmlNs.entrySet()) {
/*  578 */           schema._namespace((String)e.getValue(), (String)e.getKey());
/*      */         }
/*      */ 
/*  581 */         if (this.useSwaRef) {
/*  582 */           schema._namespace("http://ws-i.org/profiles/basic/1.1/xsd", "swaRef");
/*      */         }
/*  584 */         this.attributeFormDefault = Form.get(XmlSchemaGenerator.this.types.getAttributeFormDefault(this.uri));
/*  585 */         this.attributeFormDefault.declare("attributeFormDefault", schema);
/*      */ 
/*  587 */         this.elementFormDefault = Form.get(XmlSchemaGenerator.this.types.getElementFormDefault(this.uri));
/*      */ 
/*  589 */         this.elementFormDefault.declare("elementFormDefault", schema);
/*      */ 
/*  594 */         if ((!xmlNs.containsValue("http://www.w3.org/2001/XMLSchema")) && (!xmlNs.containsKey("xs")))
/*      */         {
/*  596 */           schema._namespace("http://www.w3.org/2001/XMLSchema", "xs");
/*  597 */         }schema.version("1.0");
/*      */ 
/*  599 */         if (this.uri.length() != 0) {
/*  600 */           schema.targetNamespace(this.uri);
/*      */         }
/*      */ 
/*  604 */         for (Namespace ns : this.depends) {
/*  605 */           schema._namespace(ns.uri);
/*      */         }
/*      */ 
/*  608 */         if ((this.selfReference) && (this.uri.length() != 0))
/*      */         {
/*  611 */           schema._namespace(this.uri, "tns");
/*      */         }
/*      */ 
/*  614 */         schema._pcdata("\n");
/*      */ 
/*  617 */         for (Namespace n : this.depends) {
/*  618 */           Import imp = schema._import();
/*  619 */           if (n.uri.length() != 0)
/*  620 */             imp.namespace(n.uri);
/*  621 */           String refSystemId = (String)systemIds.get(n);
/*  622 */           if ((refSystemId != null) && (!refSystemId.equals("")))
/*      */           {
/*  624 */             imp.schemaLocation(XmlSchemaGenerator.relativize(refSystemId, result.getSystemId()));
/*      */           }
/*  626 */           schema._pcdata("\n");
/*      */         }
/*  628 */         if (this.useSwaRef) {
/*  629 */           schema._import().namespace("http://ws-i.org/profiles/basic/1.1/xsd").schemaLocation("http://ws-i.org/profiles/basic/1.1/swaref.xsd");
/*      */         }
/*      */ 
/*  633 */         for (Map.Entry e : this.elementDecls.entrySet()) {
/*  634 */           ((ElementDeclaration)e.getValue()).writeTo((String)e.getKey(), schema);
/*  635 */           schema._pcdata("\n");
/*      */         }
/*  637 */         for (ClassInfo c : this.classes) {
/*  638 */           if (c.getTypeName() == null)
/*      */           {
/*      */             continue;
/*      */           }
/*  642 */           if (this.uri.equals(c.getTypeName().getNamespaceURI()))
/*  643 */             writeClass(c, schema);
/*  644 */           schema._pcdata("\n");
/*      */         }
/*  646 */         for (EnumLeafInfo e : this.enums) {
/*  647 */           if (e.getTypeName() == null)
/*      */           {
/*      */             continue;
/*      */           }
/*  651 */           if (this.uri.equals(e.getTypeName().getNamespaceURI()))
/*  652 */             writeEnum(e, schema);
/*  653 */           schema._pcdata("\n");
/*      */         }
/*  655 */         for (ArrayInfo a : this.arrays) {
/*  656 */           writeArray(a, schema);
/*  657 */           schema._pcdata("\n");
/*      */         }
/*  659 */         for (Map.Entry e : this.attributeDecls.entrySet()) {
/*  660 */           TopLevelAttribute a = schema.attribute();
/*  661 */           a.name((String)e.getKey());
/*  662 */           if (e.getValue() == null)
/*  663 */             writeTypeRef(a, XmlSchemaGenerator.this.stringType, "type");
/*      */           else
/*  665 */             writeAttributeTypeRef((AttributePropertyInfo)e.getValue(), a);
/*  666 */           schema._pcdata("\n");
/*      */         }
/*      */ 
/*  670 */         schema.commit();
/*      */       } catch (TxwException e) {
/*  672 */         XmlSchemaGenerator.logger.log(Level.INFO, e.getMessage(), e);
/*  673 */         throw new IOException(e.getMessage());
/*      */       }
/*      */     }
/*      */ 
/*      */     private void writeTypeRef(TypeHost th, NonElementRef<T, C> typeRef, String refAttName)
/*      */     {
/*  690 */       switch (XmlSchemaGenerator.2.$SwitchMap$com$sun$xml$bind$v2$model$core$ID[typeRef.getSource().id().ordinal()]) {
/*      */       case 1:
/*  692 */         th._attribute(refAttName, new QName("http://www.w3.org/2001/XMLSchema", "ID"));
/*  693 */         return;
/*      */       case 2:
/*  695 */         th._attribute(refAttName, new QName("http://www.w3.org/2001/XMLSchema", "IDREF"));
/*  696 */         return;
/*      */       case 3:
/*  699 */         break;
/*      */       default:
/*  701 */         throw new IllegalStateException();
/*      */       }
/*      */ 
/*  705 */       MimeType mimeType = typeRef.getSource().getExpectedMimeType();
/*  706 */       if (mimeType != null) {
/*  707 */         th._attribute(new QName("http://www.w3.org/2005/05/xmlmime", "expectedContentTypes", "xmime"), mimeType.toString());
/*      */       }
/*      */ 
/*  711 */       if (XmlSchemaGenerator.this.generateSwaRefAdapter(typeRef)) {
/*  712 */         th._attribute(refAttName, new QName("http://ws-i.org/profiles/basic/1.1/xsd", "swaRef", "ref"));
/*  713 */         return;
/*      */       }
/*      */ 
/*  717 */       if (typeRef.getSource().getSchemaType() != null) {
/*  718 */         th._attribute(refAttName, typeRef.getSource().getSchemaType());
/*  719 */         return;
/*      */       }
/*      */ 
/*  724 */       writeTypeRef(th, typeRef.getTarget(), refAttName);
/*      */     }
/*      */ 
/*      */     private void writeTypeRef(TypeHost th, NonElement<T, C> type, String refAttName)
/*      */     {
/*  740 */       if (type.getTypeName() == null)
/*      */       {
/*  742 */         th.block();
/*  743 */         if ((type instanceof ClassInfo)) {
/*  744 */           if (XmlSchemaGenerator.this.collisionChecker.push((ClassInfo)type)) {
/*  745 */             XmlSchemaGenerator.this.errorListener.error(new SAXParseException(Messages.ANONYMOUS_TYPE_CYCLE.format(new Object[] { XmlSchemaGenerator.access$1500(XmlSchemaGenerator.this).getCycleString() }), null));
/*      */           }
/*      */           else
/*      */           {
/*  750 */             writeClass((ClassInfo)type, th);
/*      */           }
/*  752 */           XmlSchemaGenerator.this.collisionChecker.pop();
/*      */         } else {
/*  754 */           writeEnum((EnumLeafInfo)type, (SimpleTypeHost)th);
/*      */         }
/*      */       } else {
/*  757 */         th._attribute(refAttName, type.getTypeName());
/*      */       }
/*      */     }
/*      */ 
/*      */     private void writeArray(ArrayInfo<T, C> a, Schema schema)
/*      */     {
/*  765 */       ComplexType ct = schema.complexType().name(a.getTypeName().getLocalPart());
/*  766 */       ct._final("#all");
/*  767 */       LocalElement le = ct.sequence().element().name("item");
/*  768 */       le.type(a.getItemType().getTypeName());
/*  769 */       le.minOccurs(0).maxOccurs("unbounded");
/*  770 */       le.nillable(true);
/*  771 */       ct.commit();
/*      */     }
/*      */ 
/*      */     private void writeEnum(EnumLeafInfo<T, C> e, SimpleTypeHost th)
/*      */     {
/*  778 */       SimpleType st = th.simpleType();
/*  779 */       writeName(e, st);
/*      */ 
/*  781 */       SimpleRestrictionModel base = st.restriction();
/*  782 */       writeTypeRef(base, e.getBaseType(), "base");
/*      */ 
/*  784 */       for (EnumConstant c : e.getConstants()) {
/*  785 */         base.enumeration().value(c.getLexicalValue());
/*      */       }
/*  787 */       st.commit();
/*      */     }
/*      */ 
/*      */     private void writeClass(ClassInfo<T, C> c, TypeHost parent)
/*      */     {
/*  798 */       if (containsValueProp(c)) {
/*  799 */         if (c.getProperties().size() == 1)
/*      */         {
/*  805 */           ValuePropertyInfo vp = (ValuePropertyInfo)c.getProperties().get(0);
/*  806 */           SimpleType st = ((SimpleTypeHost)parent).simpleType();
/*  807 */           writeName(c, st);
/*  808 */           if (vp.isCollection())
/*  809 */             writeTypeRef(st.list(), vp.getTarget(), "itemType");
/*      */           else {
/*  811 */             writeTypeRef(st.restriction(), vp.getTarget(), "base");
/*      */           }
/*  813 */           return;
/*      */         }
/*      */ 
/*  827 */         ComplexType ct = ((ComplexTypeHost)parent).complexType();
/*  828 */         writeName(c, ct);
/*  829 */         if (c.isFinal()) {
/*  830 */           ct._final("extension restriction");
/*      */         }
/*  832 */         SimpleExtension se = ct.simpleContent().extension();
/*  833 */         se.block();
/*  834 */         for (PropertyInfo p : c.getProperties()) {
/*  835 */           switch (XmlSchemaGenerator.2.$SwitchMap$com$sun$xml$bind$v2$model$core$PropertyKind[p.kind().ordinal()]) {
/*      */           case 1:
/*  837 */             handleAttributeProp((AttributePropertyInfo)p, se);
/*  838 */             break;
/*      */           case 2:
/*  840 */             TODO.checkSpec("what if vp.isCollection() == true?");
/*  841 */             ValuePropertyInfo vp = (ValuePropertyInfo)p;
/*  842 */             se.base(vp.getTarget().getTypeName());
/*  843 */             break;
/*      */           case 3:
/*      */           case 4:
/*      */           default:
/*  847 */             if (!$assertionsDisabled) throw new AssertionError();
/*  848 */             throw new IllegalStateException();
/*      */           }
/*      */         }
/*  851 */         se.commit();
/*      */ 
/*  853 */         TODO.schemaGenerator("figure out what to do if bc != null");
/*  854 */         TODO.checkSpec("handle sec 8.9.5.2, bullet #4");
/*      */ 
/*  858 */         return;
/*      */       }
/*      */ 
/*  864 */       ComplexType ct = ((ComplexTypeHost)parent).complexType();
/*  865 */       writeName(c, ct);
/*  866 */       if (c.isFinal())
/*  867 */         ct._final("extension restriction");
/*  868 */       if (c.isAbstract()) {
/*  869 */         ct._abstract(true);
/*      */       }
/*      */ 
/*  872 */       AttrDecls contentModel = ct;
/*  873 */       TypeDefParticle contentModelOwner = ct;
/*      */ 
/*  876 */       ClassInfo bc = c.getBaseClass();
/*  877 */       if (bc != null) {
/*  878 */         if (bc.hasValueProperty())
/*      */         {
/*  880 */           SimpleExtension se = ct.simpleContent().extension();
/*  881 */           contentModel = se;
/*  882 */           contentModelOwner = null;
/*  883 */           se.base(bc.getTypeName());
/*      */         } else {
/*  885 */           ComplexExtension ce = ct.complexContent().extension();
/*  886 */           contentModel = ce;
/*  887 */           contentModelOwner = ce;
/*      */ 
/*  889 */           ce.base(bc.getTypeName());
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  894 */       if (contentModelOwner != null)
/*      */       {
/*  896 */         ArrayList children = new ArrayList();
/*  897 */         for (PropertyInfo p : c.getProperties())
/*      */         {
/*  899 */           if (((p instanceof ReferencePropertyInfo)) && (((ReferencePropertyInfo)p).isMixed())) {
/*  900 */             ct.mixed(true);
/*      */           }
/*  902 */           Tree t = buildPropertyContentModel(p);
/*  903 */           if (t != null) {
/*  904 */             children.add(t);
/*      */           }
/*      */         }
/*  907 */         Tree top = Tree.makeGroup(c.isOrdered() ? GroupKind.SEQUENCE : GroupKind.ALL, children);
/*      */ 
/*  910 */         top.write(contentModelOwner);
/*      */       }
/*      */ 
/*  914 */       for (PropertyInfo p : c.getProperties()) {
/*  915 */         if ((p instanceof AttributePropertyInfo)) {
/*  916 */           handleAttributeProp((AttributePropertyInfo)p, contentModel);
/*      */         }
/*      */       }
/*  919 */       if (c.hasAttributeWildcard()) {
/*  920 */         contentModel.anyAttribute().namespace("##other").processContents("skip");
/*      */       }
/*  922 */       ct.commit();
/*      */     }
/*      */ 
/*      */     private void writeName(NonElement<T, C> c, TypedXmlWriter xw)
/*      */     {
/*  929 */       QName tn = c.getTypeName();
/*  930 */       if (tn != null)
/*  931 */         xw._attribute("name", tn.getLocalPart());
/*      */     }
/*      */ 
/*      */     private boolean containsValueProp(ClassInfo<T, C> c) {
/*  935 */       for (PropertyInfo p : c.getProperties()) {
/*  936 */         if ((p instanceof ValuePropertyInfo)) return true;
/*      */       }
/*  938 */       return false;
/*      */     }
/*      */ 
/*      */     private Tree buildPropertyContentModel(PropertyInfo<T, C> p)
/*      */     {
/*  945 */       switch (XmlSchemaGenerator.2.$SwitchMap$com$sun$xml$bind$v2$model$core$PropertyKind[p.kind().ordinal()]) {
/*      */       case 3:
/*  947 */         return handleElementProp((ElementPropertyInfo)p);
/*      */       case 1:
/*  950 */         return null;
/*      */       case 4:
/*  952 */         return handleReferenceProp((ReferencePropertyInfo)p);
/*      */       case 5:
/*  954 */         return handleMapProp((MapPropertyInfo)p);
/*      */       case 2:
/*  957 */         if (!$assertionsDisabled) throw new AssertionError();
/*  958 */         throw new IllegalStateException();
/*      */       }
/*  960 */       if (!$assertionsDisabled) throw new AssertionError();
/*  961 */       throw new IllegalStateException();
/*      */     }
/*      */ 
/*      */     private Tree handleElementProp(ElementPropertyInfo<T, C> ep)
/*      */     {
/*  975 */       if (ep.isValueList()) {
/*  976 */         return new Tree.Term(ep) {
/*      */           protected void write(ContentModelContainer parent, boolean isOptional, boolean repeated) {
/*  978 */             TypeRef t = (TypeRef)this.val$ep.getTypes().get(0);
/*  979 */             LocalElement e = parent.element();
/*  980 */             e.block();
/*  981 */             QName tn = t.getTagName();
/*  982 */             e.name(tn.getLocalPart());
/*  983 */             com.sun.xml.bind.v2.schemagen.xmlschema.List lst = e.simpleType().list();
/*  984 */             XmlSchemaGenerator.Namespace.this.writeTypeRef(lst, t, "itemType");
/*  985 */             XmlSchemaGenerator.Namespace.this.elementFormDefault.writeForm(e, tn);
/*  986 */             writeOccurs(e, (isOptional) || (!this.val$ep.isRequired()), repeated);
/*      */           }
/*      */         };
/*      */       }
/*  991 */       ArrayList children = new ArrayList();
/*  992 */       for (TypeRef t : ep.getTypes()) {
/*  993 */         children.add(new Tree.Term(t) {
/*      */           protected void write(ContentModelContainer parent, boolean isOptional, boolean repeated) {
/*  995 */             LocalElement e = parent.element();
/*      */ 
/*  997 */             QName tn = this.val$t.getTagName();
/*      */ 
/*  999 */             if ((XmlSchemaGenerator.Namespace.this.canBeDirectElementRef(this.val$t, tn)) || ((!tn.getNamespaceURI().equals(XmlSchemaGenerator.Namespace.this.uri)) && (tn.getNamespaceURI().length() > 0))) {
/* 1000 */               e.ref(tn);
/*      */             } else {
/* 1002 */               e.name(tn.getLocalPart());
/* 1003 */               XmlSchemaGenerator.Namespace.this.writeTypeRef(e, this.val$t, "type");
/* 1004 */               XmlSchemaGenerator.Namespace.this.elementFormDefault.writeForm(e, tn);
/*      */             }
/*      */ 
/* 1007 */             if (this.val$t.isNillable()) {
/* 1008 */               e.nillable(true);
/*      */             }
/* 1010 */             if (this.val$t.getDefaultValue() != null)
/* 1011 */               e._default(this.val$t.getDefaultValue());
/* 1012 */             writeOccurs(e, isOptional, repeated);
/*      */           }
/*      */         });
/*      */       }
/* 1017 */       Tree choice = Tree.makeGroup(GroupKind.CHOICE, children).makeOptional(!ep.isRequired()).makeRepeated(ep.isCollection());
/*      */ 
/* 1022 */       QName ename = ep.getXmlName();
/* 1023 */       if (ename != null)
/* 1024 */         return new Tree.Term(ename, ep, choice) {
/*      */           protected void write(ContentModelContainer parent, boolean isOptional, boolean repeated) {
/* 1026 */             LocalElement e = parent.element();
/* 1027 */             if ((this.val$ename.getNamespaceURI().length() > 0) && 
/* 1028 */               (!this.val$ename.getNamespaceURI().equals(XmlSchemaGenerator.Namespace.this.uri)))
/*      */             {
/* 1031 */               e.ref(new QName(this.val$ename.getNamespaceURI(), this.val$ename.getLocalPart()));
/* 1032 */               return;
/*      */             }
/*      */ 
/* 1035 */             e.name(this.val$ename.getLocalPart());
/* 1036 */             XmlSchemaGenerator.Namespace.this.elementFormDefault.writeForm(e, this.val$ename);
/*      */ 
/* 1038 */             if (this.val$ep.isCollectionNillable()) {
/* 1039 */               e.nillable(true);
/*      */             }
/* 1041 */             writeOccurs(e, !this.val$ep.isCollectionRequired(), repeated);
/*      */ 
/* 1043 */             ComplexType p = e.complexType();
/* 1044 */             this.val$choice.write(p);
/*      */           }
/*      */         };
/* 1048 */       return choice;
/*      */     }
/*      */ 
/*      */     private boolean canBeDirectElementRef(TypeRef<T, C> t, QName tn)
/*      */     {
/* 1059 */       if ((t.isNillable()) || (t.getDefaultValue() != null))
/*      */       {
/* 1061 */         return false;
/*      */       }
/* 1063 */       if ((t.getTarget() instanceof Element)) {
/* 1064 */         Element te = (Element)t.getTarget();
/* 1065 */         QName targetTagName = te.getElementName();
/* 1066 */         return (targetTagName != null) && (targetTagName.equals(tn));
/*      */       }
/*      */ 
/* 1069 */       return false;
/*      */     }
/*      */ 
/*      */     private void handleAttributeProp(AttributePropertyInfo<T, C> ap, AttrDecls attr)
/*      */     {
/* 1102 */       LocalAttribute localAttribute = attr.attribute();
/*      */ 
/* 1104 */       String attrURI = ap.getXmlName().getNamespaceURI();
/* 1105 */       if (attrURI.equals("")) {
/* 1106 */         localAttribute.name(ap.getXmlName().getLocalPart());
/*      */ 
/* 1108 */         writeAttributeTypeRef(ap, localAttribute);
/*      */ 
/* 1110 */         this.attributeFormDefault.writeForm(localAttribute, ap.getXmlName());
/*      */       } else {
/* 1112 */         localAttribute.ref(ap.getXmlName());
/*      */       }
/*      */ 
/* 1115 */       if (ap.isRequired())
/*      */       {
/* 1117 */         localAttribute.use("required");
/*      */       }
/*      */     }
/*      */ 
/*      */     private void writeAttributeTypeRef(AttributePropertyInfo<T, C> ap, AttributeType a) {
/* 1122 */       if (ap.isCollection())
/* 1123 */         writeTypeRef(a.simpleType().list(), ap, "itemType");
/*      */       else
/* 1125 */         writeTypeRef(a, ap, "type");
/*      */     }
/*      */ 
/*      */     private Tree handleReferenceProp(ReferencePropertyInfo<T, C> rp)
/*      */     {
/* 1137 */       ArrayList children = new ArrayList();
/*      */ 
/* 1139 */       for (Element e : rp.getElements()) {
/* 1140 */         children.add(new Tree.Term(e) {
/*      */           protected void write(ContentModelContainer parent, boolean isOptional, boolean repeated) {
/* 1142 */             LocalElement eref = parent.element();
/*      */ 
/* 1144 */             boolean local = false;
/*      */ 
/* 1146 */             QName en = this.val$e.getElementName();
/* 1147 */             if (this.val$e.getScope() != null)
/*      */             {
/* 1149 */               boolean qualified = en.getNamespaceURI().equals(XmlSchemaGenerator.Namespace.this.uri);
/* 1150 */               boolean unqualified = en.getNamespaceURI().equals("");
/* 1151 */               if ((qualified) || (unqualified))
/*      */               {
/* 1155 */                 if (unqualified) {
/* 1156 */                   if (XmlSchemaGenerator.Namespace.this.elementFormDefault.isEffectivelyQualified)
/* 1157 */                     eref.form("unqualified");
/*      */                 }
/* 1159 */                 else if (!XmlSchemaGenerator.Namespace.this.elementFormDefault.isEffectivelyQualified) {
/* 1160 */                   eref.form("qualified");
/*      */                 }
/*      */ 
/* 1163 */                 local = true;
/* 1164 */                 eref.name(en.getLocalPart());
/*      */ 
/* 1167 */                 if ((this.val$e instanceof ClassInfo))
/* 1168 */                   XmlSchemaGenerator.Namespace.this.writeTypeRef(eref, (ClassInfo)this.val$e, "type");
/*      */                 else {
/* 1170 */                   XmlSchemaGenerator.Namespace.this.writeTypeRef(eref, ((ElementInfo)this.val$e).getContentType(), "type");
/*      */                 }
/*      */               }
/*      */             }
/* 1174 */             if (!local)
/* 1175 */               eref.ref(en);
/* 1176 */             writeOccurs(eref, isOptional, repeated);
/*      */           }
/*      */         });
/*      */       }
/* 1181 */       WildcardMode wc = rp.getWildcard();
/* 1182 */       if (wc != null) {
/* 1183 */         children.add(new Tree.Term(wc) {
/*      */           protected void write(ContentModelContainer parent, boolean isOptional, boolean repeated) {
/* 1185 */             Any any = parent.any();
/* 1186 */             String pcmode = XmlSchemaGenerator.access$2100(this.val$wc);
/* 1187 */             if (pcmode != null) any.processContents(pcmode);
/* 1188 */             any.namespace("##other");
/* 1189 */             writeOccurs(any, isOptional, repeated);
/*      */           }
/*      */         });
/*      */       }
/*      */ 
/* 1195 */       Tree choice = Tree.makeGroup(GroupKind.CHOICE, children).makeRepeated(rp.isCollection()).makeOptional(rp.isCollection());
/*      */ 
/* 1200 */       QName ename = rp.getXmlName();
/*      */ 
/* 1202 */       if (ename != null)
/* 1203 */         return new Tree.Term(ename, rp, choice) {
/*      */           protected void write(ContentModelContainer parent, boolean isOptional, boolean repeated) {
/* 1205 */             LocalElement e = parent.element().name(this.val$ename.getLocalPart());
/* 1206 */             XmlSchemaGenerator.Namespace.this.elementFormDefault.writeForm(e, this.val$ename);
/* 1207 */             if (this.val$rp.isCollectionNillable())
/* 1208 */               e.nillable(true);
/* 1209 */             writeOccurs(e, true, repeated);
/*      */ 
/* 1211 */             ComplexType p = e.complexType();
/* 1212 */             this.val$choice.write(p);
/*      */           }
/*      */         };
/* 1216 */       return choice;
/*      */     }
/*      */ 
/*      */     private Tree handleMapProp(MapPropertyInfo<T, C> mp)
/*      */     {
/* 1227 */       return new Tree.Term(mp) {
/*      */         protected void write(ContentModelContainer parent, boolean isOptional, boolean repeated) {
/* 1229 */           QName ename = this.val$mp.getXmlName();
/*      */ 
/* 1231 */           LocalElement e = parent.element();
/* 1232 */           XmlSchemaGenerator.Namespace.this.elementFormDefault.writeForm(e, ename);
/* 1233 */           if (this.val$mp.isCollectionNillable()) {
/* 1234 */             e.nillable(true);
/*      */           }
/* 1236 */           e = e.name(ename.getLocalPart());
/* 1237 */           writeOccurs(e, isOptional, repeated);
/* 1238 */           ComplexType p = e.complexType();
/*      */ 
/* 1242 */           e = p.sequence().element();
/* 1243 */           e.name("entry").minOccurs(0).maxOccurs("unbounded");
/*      */ 
/* 1245 */           ExplicitGroup seq = e.complexType().sequence();
/* 1246 */           XmlSchemaGenerator.Namespace.this.writeKeyOrValue(seq, "key", this.val$mp.getKeyType());
/* 1247 */           XmlSchemaGenerator.Namespace.this.writeKeyOrValue(seq, "value", this.val$mp.getValueType());
/*      */         } } ;
/*      */     }
/*      */ 
/*      */     private void writeKeyOrValue(ExplicitGroup seq, String tagName, NonElement<T, C> typeRef) {
/* 1253 */       LocalElement key = seq.element().name(tagName);
/* 1254 */       key.minOccurs(0);
/* 1255 */       writeTypeRef(key, typeRef, "type");
/*      */     }
/*      */ 
/*      */     public void addGlobalAttribute(AttributePropertyInfo<T, C> ap) {
/* 1259 */       this.attributeDecls.put(ap.getXmlName().getLocalPart(), ap);
/* 1260 */       addDependencyTo(ap.getTarget().getTypeName());
/*      */     }
/*      */ 
/*      */     public void addGlobalElement(TypeRef<T, C> tref) {
/* 1264 */       this.elementDecls.put(tref.getTagName().getLocalPart(), new ElementWithType(false, tref.getTarget()));
/* 1265 */       addDependencyTo(tref.getTarget().getTypeName());
/*      */     }
/*      */ 
/*      */     class ElementWithType extends XmlSchemaGenerator.Namespace.ElementDeclaration
/*      */     {
/*      */       private final boolean nillable;
/*      */       private final NonElement<T, C> type;
/*      */ 
/*      */       public ElementWithType(NonElement<T, C> nillable)
/*      */       {
/* 1303 */         super();
/* 1304 */         this.type = type;
/* 1305 */         this.nillable = nillable;
/*      */       }
/*      */ 
/*      */       public void writeTo(String localName, Schema schema) {
/* 1309 */         TopLevelElement e = schema.element().name(localName);
/* 1310 */         if (this.nillable)
/* 1311 */           e.nillable(true);
/* 1312 */         if (this.type != null)
/* 1313 */           XmlSchemaGenerator.Namespace.this.writeTypeRef(e, this.type, "type");
/*      */         else {
/* 1315 */           e.complexType();
/*      */         }
/* 1317 */         e.commit();
/*      */       }
/*      */ 
/*      */       public boolean equals(Object o) {
/* 1321 */         if (this == o) return true;
/* 1322 */         if ((o == null) || (getClass() != o.getClass())) return false;
/*      */ 
/* 1324 */         ElementWithType that = (ElementWithType)o;
/* 1325 */         return this.type.equals(that.type);
/*      */       }
/*      */ 
/*      */       public int hashCode() {
/* 1329 */         return this.type.hashCode();
/*      */       }
/*      */     }
/*      */ 
/*      */     abstract class ElementDeclaration
/*      */     {
/*      */       ElementDeclaration()
/*      */       {
/*      */       }
/*      */ 
/*      */       public abstract boolean equals(Object paramObject);
/*      */ 
/*      */       public abstract int hashCode();
/*      */ 
/*      */       public abstract void writeTo(String paramString, Schema paramSchema);
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.schemagen.XmlSchemaGenerator
 * JD-Core Version:    0.6.0
 */