/*     */ package gnu.trove;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class TDoubleObjectHashMap extends TDoubleHash
/*     */   implements Serializable
/*     */ {
/*     */   protected transient Object[] _values;
/*     */ 
/*     */   public TDoubleObjectHashMap()
/*     */   {
/*     */   }
/*     */ 
/*     */   public TDoubleObjectHashMap(int initialCapacity)
/*     */   {
/*  55 */     super(initialCapacity);
/*     */   }
/*     */ 
/*     */   public TDoubleObjectHashMap(int initialCapacity, float loadFactor)
/*     */   {
/*  67 */     super(initialCapacity, loadFactor);
/*     */   }
/*     */ 
/*     */   public TDoubleObjectHashMap(TDoubleHashingStrategy strategy)
/*     */   {
/*  76 */     super(strategy);
/*     */   }
/*     */ 
/*     */   public TDoubleObjectHashMap(int initialCapacity, TDoubleHashingStrategy strategy)
/*     */   {
/*  88 */     super(initialCapacity, strategy);
/*     */   }
/*     */ 
/*     */   public TDoubleObjectHashMap(int initialCapacity, float loadFactor, TDoubleHashingStrategy strategy)
/*     */   {
/* 101 */     super(initialCapacity, loadFactor, strategy);
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/* 108 */     TDoubleObjectHashMap m = (TDoubleObjectHashMap)super.clone();
/* 109 */     m._values = ((Object[])this._values.clone());
/* 110 */     return m;
/*     */   }
/*     */ 
/*     */   public TDoubleObjectIterator iterator()
/*     */   {
/* 117 */     return new TDoubleObjectIterator(this);
/*     */   }
/*     */ 
/*     */   protected int setUp(int initialCapacity)
/*     */   {
/* 130 */     int capacity = super.setUp(initialCapacity);
/* 131 */     this._values = new Object[capacity];
/* 132 */     return capacity;
/*     */   }
/*     */ 
/*     */   public Object put(double key, Object value)
/*     */   {
/* 145 */     Object previous = null;
/* 146 */     int index = insertionIndex(key);
/* 147 */     boolean isNewMapping = true;
/* 148 */     if (index < 0) {
/* 149 */       index = -index - 1;
/* 150 */       previous = this._values[index];
/* 151 */       isNewMapping = false;
/*     */     }
/* 153 */     byte previousState = this._states[index];
/* 154 */     this._set[index] = key;
/* 155 */     this._states[index] = 1;
/* 156 */     this._values[index] = value;
/* 157 */     if (isNewMapping) {
/* 158 */       postInsertHook(previousState == 0);
/*     */     }
/*     */ 
/* 161 */     return previous;
/*     */   }
/*     */ 
/*     */   protected void rehash(int newCapacity)
/*     */   {
/* 170 */     int oldCapacity = this._set.length;
/* 171 */     double[] oldKeys = this._set;
/* 172 */     Object[] oldVals = this._values;
/* 173 */     byte[] oldStates = this._states;
/*     */ 
/* 175 */     this._set = new double[newCapacity];
/* 176 */     this._values = new Object[newCapacity];
/* 177 */     this._states = new byte[newCapacity];
/*     */ 
/* 179 */     for (int i = oldCapacity; i-- > 0; )
/* 180 */       if (oldStates[i] == 1) {
/* 181 */         double o = oldKeys[i];
/* 182 */         int index = insertionIndex(o);
/* 183 */         this._set[index] = o;
/* 184 */         this._values[index] = oldVals[i];
/* 185 */         this._states[index] = 1;
/*     */       }
/*     */   }
/*     */ 
/*     */   public Object get(double key)
/*     */   {
/* 197 */     int index = index(key);
/* 198 */     return index < 0 ? null : this._values[index];
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 206 */     super.clear();
/* 207 */     double[] keys = this._set;
/* 208 */     Object[] vals = this._values;
/* 209 */     byte[] states = this._states;
/*     */ 
/* 211 */     for (int i = keys.length; i-- > 0; ) {
/* 212 */       keys[i] = 0.0D;
/* 213 */       vals[i] = null;
/* 214 */       states[i] = 0;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object remove(double key)
/*     */   {
/* 225 */     Object prev = null;
/* 226 */     int index = index(key);
/* 227 */     if (index >= 0) {
/* 228 */       prev = this._values[index];
/* 229 */       removeAt(index);
/*     */     }
/* 231 */     return prev;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/* 242 */     if (!(other instanceof TDoubleObjectHashMap)) {
/* 243 */       return false;
/*     */     }
/* 245 */     TDoubleObjectHashMap that = (TDoubleObjectHashMap)other;
/* 246 */     if (that.size() != size()) {
/* 247 */       return false;
/*     */     }
/* 249 */     return forEachEntry(new EqProcedure(that));
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 253 */     HashProcedure p = new HashProcedure(null);
/* 254 */     forEachEntry(p);
/* 255 */     return p.getHashCode();
/*     */   }
/*     */ 
/*     */   protected void removeAt(int index)
/*     */   {
/* 301 */     super.removeAt(index);
/* 302 */     this._values[index] = null;
/*     */   }
/*     */ 
/*     */   public Object[] getValues()
/*     */   {
/* 311 */     Object[] vals = new Object[size()];
/* 312 */     Object[] v = this._values;
/* 313 */     byte[] states = this._states;
/*     */ 
/* 315 */     int i = v.length; for (int j = 0; i-- > 0; ) {
/* 316 */       if (states[i] == 1) {
/* 317 */         vals[(j++)] = v[i];
/*     */       }
/*     */     }
/* 320 */     return vals;
/*     */   }
/*     */ 
/*     */   public double[] keys()
/*     */   {
/* 329 */     double[] keys = new double[size()];
/* 330 */     double[] k = this._set;
/* 331 */     byte[] states = this._states;
/*     */ 
/* 333 */     int i = k.length; for (int j = 0; i-- > 0; ) {
/* 334 */       if (states[i] == 1) {
/* 335 */         keys[(j++)] = k[i];
/*     */       }
/*     */     }
/* 338 */     return keys;
/*     */   }
/*     */ 
/*     */   public boolean containsValue(Object val)
/*     */   {
/* 348 */     byte[] states = this._states;
/* 349 */     Object[] vals = this._values;
/*     */     int i;
/*     */     int i;
/* 353 */     if (null == val) {
/* 354 */       for (i = vals.length; i-- > 0; )
/* 355 */         if ((states[i] == 1) && (val == vals[i]))
/*     */         {
/* 357 */           return true;
/*     */         }
/*     */     }
/*     */     else {
/* 361 */       for (i = vals.length; i-- > 0; ) {
/* 362 */         if ((states[i] == 1) && ((val == vals[i]) || (val.equals(vals[i]))))
/*     */         {
/* 364 */           return true;
/*     */         }
/*     */       }
/*     */     }
/* 368 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean containsKey(double key)
/*     */   {
/* 379 */     return contains(key);
/*     */   }
/*     */ 
/*     */   public boolean forEachKey(TDoubleProcedure procedure)
/*     */   {
/* 390 */     return forEach(procedure);
/*     */   }
/*     */ 
/*     */   public boolean forEachValue(TObjectProcedure procedure)
/*     */   {
/* 401 */     byte[] states = this._states;
/* 402 */     Object[] values = this._values;
/* 403 */     for (int i = values.length; i-- > 0; ) {
/* 404 */       if ((states[i] == 1) && (!procedure.execute(values[i]))) {
/* 405 */         return false;
/*     */       }
/*     */     }
/* 408 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean forEachEntry(TDoubleObjectProcedure procedure)
/*     */   {
/* 420 */     byte[] states = this._states;
/* 421 */     double[] keys = this._set;
/* 422 */     Object[] values = this._values;
/* 423 */     for (int i = keys.length; i-- > 0; ) {
/* 424 */       if ((states[i] == 1) && (!procedure.execute(keys[i], values[i]))) {
/* 425 */         return false;
/*     */       }
/*     */     }
/* 428 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean retainEntries(TDoubleObjectProcedure procedure)
/*     */   {
/* 439 */     boolean modified = false;
/* 440 */     byte[] states = this._states;
/* 441 */     double[] keys = this._set;
/* 442 */     Object[] values = this._values;
/* 443 */     for (int i = keys.length; i-- > 0; ) {
/* 444 */       if ((states[i] == 1) && (!procedure.execute(keys[i], values[i]))) {
/* 445 */         removeAt(i);
/* 446 */         modified = true;
/*     */       }
/*     */     }
/* 449 */     return modified;
/*     */   }
/*     */ 
/*     */   public void transformValues(TObjectFunction function)
/*     */   {
/* 458 */     byte[] states = this._states;
/* 459 */     Object[] values = this._values;
/* 460 */     for (int i = values.length; i-- > 0; )
/* 461 */       if (states[i] == 1)
/* 462 */         values[i] = function.execute(values[i]);
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream stream)
/*     */     throws IOException
/*     */   {
/* 471 */     stream.defaultWriteObject();
/*     */ 
/* 474 */     stream.writeInt(this._size);
/*     */ 
/* 476 */     SerializationProcedure writeProcedure = new SerializationProcedure(stream);
/* 477 */     if (!forEachEntry(writeProcedure))
/* 478 */       throw writeProcedure.exception;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream stream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 484 */     stream.defaultReadObject();
/*     */ 
/* 486 */     int size = stream.readInt();
/* 487 */     setUp(size);
/* 488 */     while (size-- > 0) {
/* 489 */       double key = stream.readDouble();
/* 490 */       Object val = stream.readObject();
/* 491 */       put(key, val);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class EqProcedure
/*     */     implements TDoubleObjectProcedure
/*     */   {
/*     */     private final TDoubleObjectHashMap _otherMap;
/*     */ 
/*     */     EqProcedure(TDoubleObjectHashMap otherMap)
/*     */     {
/* 275 */       this._otherMap = otherMap;
/*     */     }
/*     */ 
/*     */     public final boolean execute(double key, Object value) {
/* 279 */       int index = this._otherMap.index(key);
/*     */ 
/* 281 */       return (index >= 0) && (eq(value, this._otherMap.get(key)));
/*     */     }
/*     */ 
/*     */     private final boolean eq(Object o1, Object o2)
/*     */     {
/* 290 */       return (o1 == o2) || ((o1 != null) && (o1.equals(o2)));
/*     */     }
/*     */   }
/*     */ 
/*     */   private final class HashProcedure
/*     */     implements TDoubleObjectProcedure
/*     */   {
/*     */     private int h;
/*     */     private final TDoubleObjectHashMap this$0;
/*     */ 
/*     */     private HashProcedure()
/*     */     {
/* 258 */       this.this$0 = this$0;
/* 259 */       this.h = 0;
/*     */     }
/*     */     public int getHashCode() {
/* 262 */       return this.h;
/*     */     }
/*     */ 
/*     */     public final boolean execute(double key, Object value) {
/* 266 */       this.h += (this.this$0._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value));
/* 267 */       return true;
/*     */     }
/*     */ 
/*     */     HashProcedure(TDoubleObjectHashMap.1 x1)
/*     */     {
/* 258 */       this();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.TDoubleObjectHashMap
 * JD-Core Version:    0.6.0
 */