/*     */ package gnu.trove;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class TFloatIntHashMap extends TFloatHash
/*     */   implements Serializable
/*     */ {
/*     */   protected transient int[] _values;
/*     */ 
/*     */   public TFloatIntHashMap()
/*     */   {
/*     */   }
/*     */ 
/*     */   public TFloatIntHashMap(int initialCapacity)
/*     */   {
/*  55 */     super(initialCapacity);
/*     */   }
/*     */ 
/*     */   public TFloatIntHashMap(int initialCapacity, float loadFactor)
/*     */   {
/*  67 */     super(initialCapacity, loadFactor);
/*     */   }
/*     */ 
/*     */   public TFloatIntHashMap(TFloatHashingStrategy strategy)
/*     */   {
/*  76 */     super(strategy);
/*     */   }
/*     */ 
/*     */   public TFloatIntHashMap(int initialCapacity, TFloatHashingStrategy strategy)
/*     */   {
/*  88 */     super(initialCapacity, strategy);
/*     */   }
/*     */ 
/*     */   public TFloatIntHashMap(int initialCapacity, float loadFactor, TFloatHashingStrategy strategy)
/*     */   {
/* 101 */     super(initialCapacity, loadFactor, strategy);
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/* 108 */     TFloatIntHashMap m = (TFloatIntHashMap)super.clone();
/* 109 */     m._values = ((int[])this._values.clone());
/* 110 */     return m;
/*     */   }
/*     */ 
/*     */   public TFloatIntIterator iterator()
/*     */   {
/* 117 */     return new TFloatIntIterator(this);
/*     */   }
/*     */ 
/*     */   protected int setUp(int initialCapacity)
/*     */   {
/* 130 */     int capacity = super.setUp(initialCapacity);
/* 131 */     this._values = new int[capacity];
/* 132 */     return capacity;
/*     */   }
/*     */ 
/*     */   public int put(float key, int value)
/*     */   {
/* 145 */     int previous = 0;
/* 146 */     int index = insertionIndex(key);
/* 147 */     boolean isNewMapping = true;
/* 148 */     if (index < 0) {
/* 149 */       index = -index - 1;
/* 150 */       previous = this._values[index];
/* 151 */       isNewMapping = false;
/*     */     }
/* 153 */     byte previousState = this._states[index];
/* 154 */     this._set[index] = key;
/* 155 */     this._states[index] = 1;
/* 156 */     this._values[index] = value;
/* 157 */     if (isNewMapping) {
/* 158 */       postInsertHook(previousState == 0);
/*     */     }
/*     */ 
/* 161 */     return previous;
/*     */   }
/*     */ 
/*     */   protected void rehash(int newCapacity)
/*     */   {
/* 170 */     int oldCapacity = this._set.length;
/* 171 */     float[] oldKeys = this._set;
/* 172 */     int[] oldVals = this._values;
/* 173 */     byte[] oldStates = this._states;
/*     */ 
/* 175 */     this._set = new float[newCapacity];
/* 176 */     this._values = new int[newCapacity];
/* 177 */     this._states = new byte[newCapacity];
/*     */ 
/* 179 */     for (int i = oldCapacity; i-- > 0; )
/* 180 */       if (oldStates[i] == 1) {
/* 181 */         float o = oldKeys[i];
/* 182 */         int index = insertionIndex(o);
/* 183 */         this._set[index] = o;
/* 184 */         this._values[index] = oldVals[i];
/* 185 */         this._states[index] = 1;
/*     */       }
/*     */   }
/*     */ 
/*     */   public int get(float key)
/*     */   {
/* 197 */     int index = index(key);
/* 198 */     return index < 0 ? 0 : this._values[index];
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 206 */     super.clear();
/* 207 */     float[] keys = this._set;
/* 208 */     int[] vals = this._values;
/* 209 */     byte[] states = this._states;
/*     */ 
/* 211 */     for (int i = keys.length; i-- > 0; ) {
/* 212 */       keys[i] = 0.0F;
/* 213 */       vals[i] = 0;
/* 214 */       states[i] = 0;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int remove(float key)
/*     */   {
/* 225 */     int prev = 0;
/* 226 */     int index = index(key);
/* 227 */     if (index >= 0) {
/* 228 */       prev = this._values[index];
/* 229 */       removeAt(index);
/*     */     }
/* 231 */     return prev;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/* 242 */     if (!(other instanceof TFloatIntHashMap)) {
/* 243 */       return false;
/*     */     }
/* 245 */     TFloatIntHashMap that = (TFloatIntHashMap)other;
/* 246 */     if (that.size() != size()) {
/* 247 */       return false;
/*     */     }
/* 249 */     return forEachEntry(new EqProcedure(that));
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 253 */     HashProcedure p = new HashProcedure(null);
/* 254 */     forEachEntry(p);
/* 255 */     return p.getHashCode();
/*     */   }
/*     */ 
/*     */   protected void removeAt(int index)
/*     */   {
/* 301 */     super.removeAt(index);
/* 302 */     this._values[index] = 0;
/*     */   }
/*     */ 
/*     */   public int[] getValues()
/*     */   {
/* 311 */     int[] vals = new int[size()];
/* 312 */     int[] v = this._values;
/* 313 */     byte[] states = this._states;
/*     */ 
/* 315 */     int i = v.length; for (int j = 0; i-- > 0; ) {
/* 316 */       if (states[i] == 1) {
/* 317 */         vals[(j++)] = v[i];
/*     */       }
/*     */     }
/* 320 */     return vals;
/*     */   }
/*     */ 
/*     */   public float[] keys()
/*     */   {
/* 329 */     float[] keys = new float[size()];
/* 330 */     float[] k = this._set;
/* 331 */     byte[] states = this._states;
/*     */ 
/* 333 */     int i = k.length; for (int j = 0; i-- > 0; ) {
/* 334 */       if (states[i] == 1) {
/* 335 */         keys[(j++)] = k[i];
/*     */       }
/*     */     }
/* 338 */     return keys;
/*     */   }
/*     */ 
/*     */   public boolean containsValue(int val)
/*     */   {
/* 348 */     byte[] states = this._states;
/* 349 */     int[] vals = this._values;
/*     */ 
/* 351 */     for (int i = vals.length; i-- > 0; ) {
/* 352 */       if ((states[i] == 1) && (val == vals[i])) {
/* 353 */         return true;
/*     */       }
/*     */     }
/* 356 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean containsKey(float key)
/*     */   {
/* 367 */     return contains(key);
/*     */   }
/*     */ 
/*     */   public boolean forEachKey(TFloatProcedure procedure)
/*     */   {
/* 378 */     return forEach(procedure);
/*     */   }
/*     */ 
/*     */   public boolean forEachValue(TIntProcedure procedure)
/*     */   {
/* 389 */     byte[] states = this._states;
/* 390 */     int[] values = this._values;
/* 391 */     for (int i = values.length; i-- > 0; ) {
/* 392 */       if ((states[i] == 1) && (!procedure.execute(values[i]))) {
/* 393 */         return false;
/*     */       }
/*     */     }
/* 396 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean forEachEntry(TFloatIntProcedure procedure)
/*     */   {
/* 408 */     byte[] states = this._states;
/* 409 */     float[] keys = this._set;
/* 410 */     int[] values = this._values;
/* 411 */     for (int i = keys.length; i-- > 0; ) {
/* 412 */       if ((states[i] == 1) && (!procedure.execute(keys[i], values[i]))) {
/* 413 */         return false;
/*     */       }
/*     */     }
/* 416 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean retainEntries(TFloatIntProcedure procedure)
/*     */   {
/* 427 */     boolean modified = false;
/* 428 */     byte[] states = this._states;
/* 429 */     float[] keys = this._set;
/* 430 */     int[] values = this._values;
/* 431 */     for (int i = keys.length; i-- > 0; ) {
/* 432 */       if ((states[i] == 1) && (!procedure.execute(keys[i], values[i]))) {
/* 433 */         removeAt(i);
/* 434 */         modified = true;
/*     */       }
/*     */     }
/* 437 */     return modified;
/*     */   }
/*     */ 
/*     */   public void transformValues(TIntFunction function)
/*     */   {
/* 446 */     byte[] states = this._states;
/* 447 */     int[] values = this._values;
/* 448 */     for (int i = values.length; i-- > 0; )
/* 449 */       if (states[i] == 1)
/* 450 */         values[i] = function.execute(values[i]);
/*     */   }
/*     */ 
/*     */   public boolean increment(float key)
/*     */   {
/* 462 */     return adjustValue(key, 1);
/*     */   }
/*     */ 
/*     */   public boolean adjustValue(float key, int amount)
/*     */   {
/* 473 */     int index = index(key);
/* 474 */     if (index < 0) {
/* 475 */       return false;
/*     */     }
/* 477 */     this._values[index] += amount;
/* 478 */     return true;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream stream)
/*     */     throws IOException
/*     */   {
/* 485 */     stream.defaultWriteObject();
/*     */ 
/* 488 */     stream.writeInt(this._size);
/*     */ 
/* 490 */     SerializationProcedure writeProcedure = new SerializationProcedure(stream);
/* 491 */     if (!forEachEntry(writeProcedure))
/* 492 */       throw writeProcedure.exception;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream stream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 498 */     stream.defaultReadObject();
/*     */ 
/* 500 */     int size = stream.readInt();
/* 501 */     setUp(size);
/* 502 */     while (size-- > 0) {
/* 503 */       float key = stream.readFloat();
/* 504 */       int val = stream.readInt();
/* 505 */       put(key, val);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class EqProcedure
/*     */     implements TFloatIntProcedure
/*     */   {
/*     */     private final TFloatIntHashMap _otherMap;
/*     */ 
/*     */     EqProcedure(TFloatIntHashMap otherMap)
/*     */     {
/* 275 */       this._otherMap = otherMap;
/*     */     }
/*     */ 
/*     */     public final boolean execute(float key, int value) {
/* 279 */       int index = this._otherMap.index(key);
/*     */ 
/* 281 */       return (index >= 0) && (eq(value, this._otherMap.get(key)));
/*     */     }
/*     */ 
/*     */     private final boolean eq(int v1, int v2)
/*     */     {
/* 290 */       return v1 == v2;
/*     */     }
/*     */   }
/*     */ 
/*     */   private final class HashProcedure
/*     */     implements TFloatIntProcedure
/*     */   {
/*     */     private int h;
/*     */     private final TFloatIntHashMap this$0;
/*     */ 
/*     */     private HashProcedure()
/*     */     {
/* 258 */       this.this$0 = this$0;
/* 259 */       this.h = 0;
/*     */     }
/*     */     public int getHashCode() {
/* 262 */       return this.h;
/*     */     }
/*     */ 
/*     */     public final boolean execute(float key, int value) {
/* 266 */       this.h += (this.this$0._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value));
/* 267 */       return true;
/*     */     }
/*     */ 
/*     */     HashProcedure(TFloatIntHashMap.1 x1)
/*     */     {
/* 258 */       this();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.TFloatIntHashMap
 * JD-Core Version:    0.6.0
 */