/*     */ package gnu.trove.benchmark;
/*     */ 
/*     */ import gnu.trove.THashMap;
/*     */ import gnu.trove.THashSet;
/*     */ import gnu.trove.TIntArrayList;
/*     */ import gnu.trove.TLinkableAdaptor;
/*     */ import gnu.trove.TLinkedList;
/*     */ import java.io.PrintStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.LinkedList;
/*     */ 
/*     */ public class MemoryUsage
/*     */ {
/*     */   public static long sizeOf(Creator c)
/*     */   {
/*  26 */     long size = 0L;
/*  27 */     Object[] objects = new Object[100];
/*     */     try {
/*  29 */       Object primer = c.create();
/*  30 */       long startingMemoryUse = getUsedMemory();
/*  31 */       for (int i = 0; i < objects.length; i++) {
/*  32 */         objects[i] = c.create();
/*     */       }
/*  34 */       long endingMemoryUse = getUsedMemory();
/*  35 */       float approxSize = (float)(endingMemoryUse - startingMemoryUse) / 100.0F;
/*     */ 
/*  37 */       size = Math.round(approxSize);
/*     */     } catch (Exception e) {
/*  39 */       e.printStackTrace();
/*     */     }
/*  41 */     return size;
/*     */   }
/*     */ 
/*     */   private static long getUsedMemory() {
/*  45 */     gc();
/*  46 */     long totalMemory = Runtime.getRuntime().totalMemory();
/*  47 */     gc();
/*  48 */     long freeMemory = Runtime.getRuntime().freeMemory();
/*  49 */     long usedMemory = totalMemory - freeMemory;
/*  50 */     return usedMemory;
/*     */   }
/*     */ 
/*     */   private static void gc() {
/*     */     try {
/*  55 */       System.gc();
/*  56 */       Thread.currentThread(); Thread.sleep(100L);
/*  57 */       System.runFinalization();
/*  58 */       Thread.currentThread(); Thread.sleep(100L);
/*  59 */       System.gc();
/*  60 */       Thread.currentThread(); Thread.sleep(100L);
/*  61 */       System.runFinalization();
/*  62 */       Thread.currentThread(); Thread.sleep(100L);
/*     */     } catch (Exception e) {
/*  64 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void main(String[] args) {
/*     */     try {
/*  70 */       MemoryComparator set = new MemoryComparator(new TroveSetCreator(), new JavasoftSetCreator(), "Compare size of Set implementation: 1,000 Integer objects measured in bytes");
/*     */ 
/*  74 */       set.compare();
/*  75 */       set = null;
/*  76 */       MemoryComparator list = new MemoryComparator(new TroveListCreator(), new JavasoftListCreator(), "Compare size of LinkedList implementation: 1,000 TLinkableAdaptor objects measured in bytes");
/*     */ 
/*  80 */       list.compare();
/*  81 */       list = null;
/*  82 */       MemoryComparator list2 = new MemoryComparator(new TroveIntArrayListCreator(), new JavasoftIntegerArrayListCreator(), "Compare size of int/IntegerArrayList implementation: 1,000 ints measured in bytes");
/*     */ 
/*  86 */       list2.compare();
/*  87 */       list2 = null;
/*     */ 
/*  89 */       MemoryComparator map = new MemoryComparator(new TroveMapCreator(), new JavasoftMapCreator(), "Compare size of Map implementation: 1,000 Integer->Integer mappings measured in bytes");
/*     */ 
/*  93 */       map.compare();
/*     */     } catch (Exception e) {
/*  95 */       e.printStackTrace();
/*     */     }
/*  97 */     System.exit(0);
/*     */   }
/*     */ 
/*     */   static class JavasoftListCreator
/*     */     implements MemoryUsage.Creator
/*     */   {
/*     */     public Object create()
/*     */     {
/* 211 */       LinkedList list = new LinkedList();
/* 212 */       for (int i = 0; i < 1000; i++) {
/* 213 */         TLinkableAdaptor a = new TLinkableAdaptor();
/* 214 */         list.add(a);
/*     */       }
/* 216 */       return list;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class TroveListCreator
/*     */     implements MemoryUsage.Creator
/*     */   {
/*     */     public Object create()
/*     */     {
/* 200 */       TLinkedList list = new TLinkedList();
/* 201 */       for (int i = 0; i < 1000; i++) {
/* 202 */         TLinkableAdaptor a = new TLinkableAdaptor();
/* 203 */         list.add(a);
/*     */       }
/* 205 */       return list;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class JavasoftSetCreator
/*     */     implements MemoryUsage.Creator
/*     */   {
/*     */     public Object create()
/*     */     {
/* 189 */       HashSet map = new HashSet();
/* 190 */       for (int i = 0; i < 1000; i++) {
/* 191 */         Integer x = new Integer(i);
/* 192 */         map.add(x);
/*     */       }
/* 194 */       return map;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class TroveSetCreator
/*     */     implements MemoryUsage.Creator
/*     */   {
/*     */     public Object create()
/*     */     {
/* 178 */       THashSet map = new THashSet();
/* 179 */       for (int i = 0; i < 1000; i++) {
/* 180 */         Integer x = new Integer(i);
/* 181 */         map.add(x);
/*     */       }
/* 183 */       return map;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class JavasoftMapCreator
/*     */     implements MemoryUsage.Creator
/*     */   {
/*     */     public Object create()
/*     */     {
/* 167 */       HashMap map = new HashMap();
/* 168 */       for (int i = 0; i < 1000; i++) {
/* 169 */         Integer x = new Integer(i);
/* 170 */         map.put(x, x);
/*     */       }
/* 172 */       return map;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class TroveMapCreator
/*     */     implements MemoryUsage.Creator
/*     */   {
/*     */     public Object create()
/*     */     {
/* 156 */       THashMap map = new THashMap();
/* 157 */       for (int i = 0; i < 1000; i++) {
/* 158 */         Integer x = new Integer(i);
/* 159 */         map.put(x, x);
/*     */       }
/* 161 */       return map;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class JavasoftIntegerArrayListCreator
/*     */     implements MemoryUsage.Creator
/*     */   {
/*     */     public Object create()
/*     */     {
/* 144 */       ArrayList list = new ArrayList();
/* 145 */       for (int i = 0; i < 1000; i++) {
/* 146 */         Integer x = new Integer(i);
/* 147 */         list.add(x);
/*     */       }
/* 149 */       list.trimToSize();
/* 150 */       return list;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class TroveIntArrayListCreator
/*     */     implements MemoryUsage.Creator
/*     */   {
/*     */     public Object create()
/*     */     {
/* 133 */       TIntArrayList list = new TIntArrayList();
/* 134 */       for (int i = 0; i < 1000; i++) {
/* 135 */         list.add(i);
/*     */       }
/* 137 */       list.trimToSize();
/* 138 */       return list;
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface Creator
/*     */   {
/*     */     public abstract Object create();
/*     */   }
/*     */ 
/*     */   static class MemoryComparator
/*     */   {
/*     */     MemoryUsage.Creator trove;
/*     */     MemoryUsage.Creator javasoft;
/*     */     String description;
/*     */ 
/*     */     MemoryComparator(MemoryUsage.Creator trove, MemoryUsage.Creator javasoft, String description)
/*     */     {
/* 106 */       this.trove = trove;
/* 107 */       this.javasoft = javasoft;
/* 108 */       this.description = description;
/*     */     }
/*     */ 
/*     */     public void compare() {
/* 112 */       MemoryUsage.access$000();
/* 113 */       long j = MemoryUsage.sizeOf(this.javasoft);
/* 114 */       MemoryUsage.access$000();
/* 115 */       long t = MemoryUsage.sizeOf(this.trove);
/*     */ 
/* 117 */       long p = Math.round((float)(t * 100L / j * 100L)) / 100;
/*     */ 
/* 119 */       System.out.println("--------------------------");
/* 120 */       System.out.println(this.description);
/* 121 */       System.out.println("javasoft: " + j);
/* 122 */       System.out.println("trove: " + t);
/* 123 */       System.out.println("trove's collection requires " + p + "% of the memory needed by javasoft's collection");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.benchmark.MemoryUsage
 * JD-Core Version:    0.6.0
 */