/*     */ package gnu.trove.decorator;
/*     */ 
/*     */ import gnu.trove.TDoubleObjectHashMap;
/*     */ import java.util.AbstractMap;
/*     */ import java.util.AbstractSet;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class TDoubleObjectHashMapDecorator extends AbstractMap
/*     */   implements Map
/*     */ {
/*     */   protected final TDoubleObjectHashMap _map;
/*     */ 
/*     */   public TDoubleObjectHashMapDecorator(TDoubleObjectHashMap map)
/*     */   {
/*  57 */     this._map = map;
/*     */   }
/*     */ 
/*     */   public Object put(Object key, Object value)
/*     */   {
/*  69 */     return wrapValue(this._map.put(unwrapKey(key), unwrapValue(value)));
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/*  80 */     if (this._map.equals(other))
/*  81 */       return true;
/*  82 */     if ((other instanceof Map)) {
/*  83 */       Map that = (Map)other;
/*  84 */       if (that.size() != this._map.size()) {
/*  85 */         return false;
/*     */       }
/*  87 */       Iterator it = that.entrySet().iterator();
/*  88 */       for (int i = that.size(); i-- > 0; ) {
/*  89 */         Map.Entry e = (Map.Entry)it.next();
/*  90 */         Object key = e.getKey();
/*  91 */         Object val = e.getValue();
/*  92 */         if (((key instanceof Integer)) && ((val instanceof Integer))) {
/*  93 */           double k = unwrapKey(key);
/*  94 */           Object v = unwrapValue(val);
/*  95 */           if ((!this._map.containsKey(k)) || (v != this._map.get(k)))
/*     */           {
/*  98 */             return false;
/*     */           }
/*     */         } else {
/* 101 */           return false;
/*     */         }
/*     */       }
/* 104 */       return true;
/*     */     }
/*     */ 
/* 107 */     return false;
/*     */   }
/*     */ 
/*     */   public Object get(Object key)
/*     */   {
/* 118 */     return this._map.get(unwrapKey(key));
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 126 */     this._map.clear();
/*     */   }
/*     */ 
/*     */   public Object remove(Object key)
/*     */   {
/* 136 */     return wrapValue(this._map.remove(unwrapKey(key)));
/*     */   }
/*     */ 
/*     */   public Set entrySet()
/*     */   {
/* 145 */     return new AbstractSet() {
/*     */       public int size() {
/* 147 */         return TDoubleObjectHashMapDecorator.this._map.size();
/*     */       }
/*     */       public boolean isEmpty() {
/* 150 */         return TDoubleObjectHashMapDecorator.this.isEmpty();
/*     */       }
/*     */       public boolean contains(Object o) {
/* 153 */         if ((o instanceof Map.Entry)) {
/* 154 */           Object k = ((Map.Entry)o).getKey();
/* 155 */           Object v = ((Map.Entry)o).getValue();
/* 156 */           return (TDoubleObjectHashMapDecorator.this.containsKey(k)) && (TDoubleObjectHashMapDecorator.this.get(k).equals(v));
/*     */         }
/*     */ 
/* 159 */         return false;
/*     */       }
/*     */ 
/*     */       public Iterator iterator() {
/* 163 */         return new TDoubleObjectHashMapDecorator.2(this);
/*     */       }
/*     */ 
/*     */       public boolean add(Object o)
/*     */       {
/* 203 */         throw new UnsupportedOperationException();
/*     */       }
/*     */       public boolean remove(Object o) {
/* 206 */         throw new UnsupportedOperationException();
/*     */       }
/*     */       public boolean addAll(Collection c) {
/* 209 */         throw new UnsupportedOperationException();
/*     */       }
/*     */       public boolean retainAll(Collection c) {
/* 212 */         throw new UnsupportedOperationException();
/*     */       }
/*     */       public boolean removeAll(Collection c) {
/* 215 */         throw new UnsupportedOperationException();
/*     */       }
/*     */       public void clear() {
/* 218 */         TDoubleObjectHashMapDecorator.this.clear();
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   public boolean containsValue(Object val)
/*     */   {
/* 230 */     return this._map.containsValue(unwrapValue(val));
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object key)
/*     */   {
/* 240 */     return this._map.containsKey(unwrapKey(key));
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 248 */     return this._map.size();
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 256 */     return size() == 0;
/*     */   }
/*     */ 
/*     */   public void putAll(Map map)
/*     */   {
/* 267 */     Iterator it = map.entrySet().iterator();
/* 268 */     for (int i = map.size(); i-- > 0; ) {
/* 269 */       Map.Entry e = (Map.Entry)it.next();
/* 270 */       put(e.getKey(), e.getValue());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Double wrapKey(double k)
/*     */   {
/* 281 */     return new Double(k);
/*     */   }
/*     */ 
/*     */   protected double unwrapKey(Object key)
/*     */   {
/* 291 */     return ((Double)key).doubleValue();
/*     */   }
/*     */ 
/*     */   protected final Object wrapValue(Object o)
/*     */   {
/* 300 */     return o;
/*     */   }
/*     */ 
/*     */   protected final Object unwrapValue(Object value)
/*     */   {
/* 310 */     return value;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.decorator.TDoubleObjectHashMapDecorator
 * JD-Core Version:    0.6.0
 */