/*      */ package javassist.bytecode;
/*      */ 
/*      */ import java.io.DataInputStream;
/*      */ import java.io.DataOutputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.PrintWriter;
/*      */ import java.util.Map;
/*      */ 
/*      */ class DoubleInfo extends ConstInfo
/*      */ {
/*      */   static final int tag = 6;
/*      */   double value;
/*      */ 
/*      */   public DoubleInfo(double d)
/*      */   {
/* 1448 */     this.value = d;
/*      */   }
/*      */ 
/*      */   public DoubleInfo(DataInputStream in) throws IOException {
/* 1452 */     this.value = in.readDouble();
/*      */   }
/*      */   public int getTag() {
/* 1455 */     return 6;
/*      */   }
/*      */   public int copy(ConstPool src, ConstPool dest, Map map) {
/* 1458 */     return dest.addDoubleInfo(this.value);
/*      */   }
/*      */ 
/*      */   public void write(DataOutputStream out) throws IOException {
/* 1462 */     out.writeByte(6);
/* 1463 */     out.writeDouble(this.value);
/*      */   }
/*      */ 
/*      */   public void print(PrintWriter out) {
/* 1467 */     out.print("Double ");
/* 1468 */     out.println(this.value);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.bytecode.DoubleInfo
 * JD-Core Version:    0.6.0
 */