/*      */ package javassist.bytecode;
/*      */ 
/*      */ import java.io.DataInputStream;
/*      */ import java.io.DataOutputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.PrintWriter;
/*      */ import java.util.Map;
/*      */ 
/*      */ abstract class MemberrefInfo extends ConstInfo
/*      */ {
/*      */   int classIndex;
/*      */   int nameAndTypeIndex;
/*      */ 
/*      */   public MemberrefInfo(int cindex, int ntindex)
/*      */   {
/* 1234 */     this.classIndex = cindex;
/* 1235 */     this.nameAndTypeIndex = ntindex;
/*      */   }
/*      */ 
/*      */   public MemberrefInfo(DataInputStream in) throws IOException {
/* 1239 */     this.classIndex = in.readUnsignedShort();
/* 1240 */     this.nameAndTypeIndex = in.readUnsignedShort();
/*      */   }
/*      */ 
/*      */   public int copy(ConstPool src, ConstPool dest, Map map) {
/* 1244 */     int classIndex2 = src.getItem(this.classIndex).copy(src, dest, map);
/* 1245 */     int ntIndex2 = src.getItem(this.nameAndTypeIndex).copy(src, dest, map);
/* 1246 */     return copy2(dest, classIndex2, ntIndex2);
/*      */   }
/*      */   protected abstract int copy2(ConstPool paramConstPool, int paramInt1, int paramInt2);
/*      */ 
/*      */   public void write(DataOutputStream out) throws IOException {
/* 1252 */     out.writeByte(getTag());
/* 1253 */     out.writeShort(this.classIndex);
/* 1254 */     out.writeShort(this.nameAndTypeIndex);
/*      */   }
/*      */ 
/*      */   public void print(PrintWriter out) {
/* 1258 */     out.print(getTagName() + " #");
/* 1259 */     out.print(this.classIndex);
/* 1260 */     out.print(", name&type #");
/* 1261 */     out.println(this.nameAndTypeIndex);
/*      */   }
/*      */ 
/*      */   public abstract String getTagName();
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.bytecode.MemberrefInfo
 * JD-Core Version:    0.6.0
 */