/*      */ package javassist.bytecode;
/*      */ 
/*      */ import java.io.DataInputStream;
/*      */ import java.io.DataOutputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.PrintWriter;
/*      */ import java.util.Map;
/*      */ 
/*      */ class NameAndTypeInfo extends ConstInfo
/*      */ {
/*      */   static final int tag = 12;
/*      */   int memberName;
/*      */   int typeDescriptor;
/*      */ 
/*      */   public NameAndTypeInfo(int name, int type)
/*      */   {
/* 1182 */     this.memberName = name;
/* 1183 */     this.typeDescriptor = type;
/*      */   }
/*      */ 
/*      */   public NameAndTypeInfo(DataInputStream in) throws IOException {
/* 1187 */     this.memberName = in.readUnsignedShort();
/* 1188 */     this.typeDescriptor = in.readUnsignedShort();
/*      */   }
/*      */   public int getTag() {
/* 1191 */     return 12;
/*      */   }
/*      */   public void renameClass(ConstPool cp, String oldName, String newName) {
/* 1194 */     String type = cp.getUtf8Info(this.typeDescriptor);
/* 1195 */     String type2 = Descriptor.rename(type, oldName, newName);
/* 1196 */     if (type != type2)
/* 1197 */       this.typeDescriptor = cp.addUtf8Info(type2);
/*      */   }
/*      */ 
/*      */   public void renameClass(ConstPool cp, Map map) {
/* 1201 */     String type = cp.getUtf8Info(this.typeDescriptor);
/* 1202 */     String type2 = Descriptor.rename(type, map);
/* 1203 */     if (type != type2)
/* 1204 */       this.typeDescriptor = cp.addUtf8Info(type2);
/*      */   }
/*      */ 
/*      */   public int copy(ConstPool src, ConstPool dest, Map map) {
/* 1208 */     String mname = src.getUtf8Info(this.memberName);
/* 1209 */     String tdesc = src.getUtf8Info(this.typeDescriptor);
/* 1210 */     tdesc = Descriptor.rename(tdesc, map);
/* 1211 */     return dest.addNameAndTypeInfo(dest.addUtf8Info(mname), dest.addUtf8Info(tdesc));
/*      */   }
/*      */ 
/*      */   public void write(DataOutputStream out) throws IOException
/*      */   {
/* 1216 */     out.writeByte(12);
/* 1217 */     out.writeShort(this.memberName);
/* 1218 */     out.writeShort(this.typeDescriptor);
/*      */   }
/*      */ 
/*      */   public void print(PrintWriter out) {
/* 1222 */     out.print("NameAndType #");
/* 1223 */     out.print(this.memberName);
/* 1224 */     out.print(", type #");
/* 1225 */     out.println(this.typeDescriptor);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.bytecode.NameAndTypeInfo
 * JD-Core Version:    0.6.0
 */