/*     */ package javax.activation;
/*     */ 
/*     */ import java.awt.datatransfer.DataFlavor;
/*     */ import java.awt.datatransfer.UnsupportedFlavorException;
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ 
/*     */ class ObjectDataContentHandler
/*     */   implements DataContentHandler
/*     */ {
/* 815 */   private DataFlavor[] transferFlavors = null;
/*     */   private Object obj;
/*     */   private String mimeType;
/* 818 */   private DataContentHandler dch = null;
/*     */ 
/*     */   public ObjectDataContentHandler(DataContentHandler dch, Object obj, String mimeType)
/*     */   {
/* 825 */     this.obj = obj;
/* 826 */     this.mimeType = mimeType;
/* 827 */     this.dch = dch;
/*     */   }
/*     */ 
/*     */   public DataContentHandler getDCH()
/*     */   {
/* 835 */     return this.dch;
/*     */   }
/*     */ 
/*     */   public DataFlavor[] getTransferDataFlavors()
/*     */   {
/* 843 */     if (this.transferFlavors == null) {
/* 844 */       if (this.dch != null) {
/* 845 */         this.transferFlavors = this.dch.getTransferDataFlavors();
/*     */       } else {
/* 847 */         this.transferFlavors = new DataFlavor[1];
/* 848 */         this.transferFlavors[0] = new ActivationDataFlavor(this.obj.getClass(), this.mimeType, this.mimeType);
/*     */       }
/*     */     }
/*     */ 
/* 852 */     return this.transferFlavors;
/*     */   }
/*     */ 
/*     */   public Object getTransferData(DataFlavor df, DataSource ds)
/*     */     throws UnsupportedFlavorException, IOException
/*     */   {
/* 864 */     if (this.dch != null)
/* 865 */       return this.dch.getTransferData(df, ds);
/* 866 */     if (df.equals(this.transferFlavors[0])) {
/* 867 */       return this.obj;
/*     */     }
/* 869 */     throw new UnsupportedFlavorException(df);
/*     */   }
/*     */ 
/*     */   public Object getContent(DataSource ds)
/*     */   {
/* 874 */     return this.obj;
/*     */   }
/*     */ 
/*     */   public void writeTo(Object obj, String mimeType, OutputStream os)
/*     */     throws IOException
/*     */   {
/* 882 */     if (this.dch != null)
/* 883 */       this.dch.writeTo(obj, mimeType, os);
/*     */     else
/* 885 */       throw new UnsupportedDataTypeException("no object DCH for MIME type " + this.mimeType);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javax.activation.ObjectDataContentHandler
 * JD-Core Version:    0.6.0
 */