/*     */ package net.sf.cglib.proxy;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import net.sf.cglib.asm.ClassVisitor;
/*     */ import net.sf.cglib.asm.Type;
/*     */ import net.sf.cglib.core.AbstractClassGenerator;
/*     */ import net.sf.cglib.core.AbstractClassGenerator.Source;
/*     */ import net.sf.cglib.core.ClassEmitter;
/*     */ import net.sf.cglib.core.CodeEmitter;
/*     */ import net.sf.cglib.core.ReflectUtils;
/*     */ import net.sf.cglib.core.Signature;
/*     */ 
/*     */ public class InterfaceMaker extends AbstractClassGenerator
/*     */ {
/*  34 */   private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(InterfaceMaker.class.getName());
/*  35 */   private Map signatures = new HashMap();
/*     */ 
/*     */   public InterfaceMaker()
/*     */   {
/*  43 */     super(SOURCE);
/*     */   }
/*     */ 
/*     */   public void add(Signature sig, Type[] exceptions)
/*     */   {
/*  52 */     this.signatures.put(sig, exceptions);
/*     */   }
/*     */ 
/*     */   public void add(Method method)
/*     */   {
/*  61 */     add(ReflectUtils.getSignature(method), ReflectUtils.getExceptionTypes(method));
/*     */   }
/*     */ 
/*     */   public void add(Class clazz)
/*     */   {
/*  72 */     Method[] methods = clazz.getMethods();
/*  73 */     for (int i = 0; i < methods.length; i++) {
/*  74 */       Method m = methods[i];
/*  75 */       if (!m.getDeclaringClass().getName().equals("java.lang.Object"))
/*  76 */         add(m);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Class create()
/*     */   {
/*  85 */     setUseCache(false);
/*  86 */     return (Class)super.create(this);
/*     */   }
/*     */ 
/*     */   protected ClassLoader getDefaultClassLoader() {
/*  90 */     return null;
/*     */   }
/*     */ 
/*     */   protected Object firstInstance(Class type) {
/*  94 */     return type;
/*     */   }
/*     */ 
/*     */   protected Object nextInstance(Object instance) {
/*  98 */     throw new IllegalStateException("InterfaceMaker does not cache");
/*     */   }
/*     */ 
/*     */   public void generateClass(ClassVisitor v) throws Exception {
/* 102 */     ClassEmitter ce = new ClassEmitter(v);
/* 103 */     ce.begin_class(46, 513, getClassName(), null, null, "<generated>");
/*     */ 
/* 109 */     for (Iterator it = this.signatures.keySet().iterator(); it.hasNext(); ) {
/* 110 */       Signature sig = (Signature)it.next();
/* 111 */       Type[] exceptions = (Type[])this.signatures.get(sig);
/* 112 */       ce.begin_method(1025, sig, exceptions, null).end_method();
/*     */     }
/*     */ 
/* 117 */     ce.end_class();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     net.sf.cglib.proxy.InterfaceMaker
 * JD-Core Version:    0.6.0
 */