/*    */ package org.apache.commons.collections.functors;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import org.apache.commons.collections.Predicate;
/*    */ 
/*    */ public final class AndPredicate
/*    */   implements Predicate, PredicateDecorator, Serializable
/*    */ {
/*    */   static final long serialVersionUID = 4189014213763186912L;
/*    */   private final Predicate iPredicate1;
/*    */   private final Predicate iPredicate2;
/*    */ 
/*    */   public static Predicate getInstance(Predicate predicate1, Predicate predicate2)
/*    */   {
/* 49 */     if ((predicate1 == null) || (predicate2 == null)) {
/* 50 */       throw new IllegalArgumentException("Predicate must not be null");
/*    */     }
/* 52 */     return new AndPredicate(predicate1, predicate2);
/*    */   }
/*    */ 
/*    */   public AndPredicate(Predicate predicate1, Predicate predicate2)
/*    */   {
/* 64 */     this.iPredicate1 = predicate1;
/* 65 */     this.iPredicate2 = predicate2;
/*    */   }
/*    */ 
/*    */   public boolean evaluate(Object object)
/*    */   {
/* 75 */     return (this.iPredicate1.evaluate(object)) && (this.iPredicate2.evaluate(object));
/*    */   }
/*    */ 
/*    */   public Predicate[] getPredicates()
/*    */   {
/* 85 */     return new Serializable[] { this.iPredicate1, this.iPredicate2 };
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.functors.AndPredicate
 * JD-Core Version:    0.6.0
 */