/*    */ package org.apache.commons.collections.functors;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.util.Map;
/*    */ import org.apache.commons.collections.Transformer;
/*    */ 
/*    */ public final class MapTransformer
/*    */   implements Transformer, Serializable
/*    */ {
/*    */   static final long serialVersionUID = 862391807045468939L;
/*    */   private final Map iMap;
/*    */ 
/*    */   public static Transformer getInstance(Map map)
/*    */   {
/* 49 */     if (map == null) {
/* 50 */       return ConstantTransformer.NULL_INSTANCE;
/*    */     }
/* 52 */     return new MapTransformer(map);
/*    */   }
/*    */ 
/*    */   private MapTransformer(Map map)
/*    */   {
/* 63 */     this.iMap = map;
/*    */   }
/*    */ 
/*    */   public Object transform(Object input)
/*    */   {
/* 73 */     return this.iMap.get(input);
/*    */   }
/*    */ 
/*    */   public Map getMap()
/*    */   {
/* 83 */     return this.iMap;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.functors.MapTransformer
 * JD-Core Version:    0.6.0
 */