/*     */ package org.apache.commons.collections.map;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.lang.ref.Reference;
/*     */ 
/*     */ public class ReferenceIdentityMap extends AbstractReferenceMap
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -1266190134568365852L;
/*     */ 
/*     */   public ReferenceIdentityMap()
/*     */   {
/*  76 */     super(0, 1, 16, 0.75F, false);
/*     */   }
/*     */ 
/*     */   public ReferenceIdentityMap(int keyType, int valueType)
/*     */   {
/*  89 */     super(keyType, valueType, 16, 0.75F, false);
/*     */   }
/*     */ 
/*     */   public ReferenceIdentityMap(int keyType, int valueType, boolean purgeValues)
/*     */   {
/* 104 */     super(keyType, valueType, 16, 0.75F, purgeValues);
/*     */   }
/*     */ 
/*     */   public ReferenceIdentityMap(int keyType, int valueType, int capacity, float loadFactor)
/*     */   {
/* 119 */     super(keyType, valueType, capacity, loadFactor, false);
/*     */   }
/*     */ 
/*     */   public ReferenceIdentityMap(int keyType, int valueType, int capacity, float loadFactor, boolean purgeValues)
/*     */   {
/* 137 */     super(keyType, valueType, capacity, loadFactor, purgeValues);
/*     */   }
/*     */ 
/*     */   protected int hash(Object key)
/*     */   {
/* 150 */     return System.identityHashCode(key);
/*     */   }
/*     */ 
/*     */   protected int hashEntry(Object key, Object value)
/*     */   {
/* 163 */     return System.identityHashCode(key) ^ System.identityHashCode(value);
/*     */   }
/*     */ 
/*     */   protected boolean isEqualKey(Object key1, Object key2)
/*     */   {
/* 178 */     key2 = this.keyType > 0 ? ((Reference)key2).get() : key2;
/* 179 */     return key1 == key2;
/*     */   }
/*     */ 
/*     */   protected boolean isEqualValue(Object value1, Object value2)
/*     */   {
/* 192 */     return value1 == value2;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream out)
/*     */     throws IOException
/*     */   {
/* 200 */     out.defaultWriteObject();
/* 201 */     doWriteObject(out);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 208 */     in.defaultReadObject();
/* 209 */     doReadObject(in);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.map.ReferenceIdentityMap
 * JD-Core Version:    0.6.0
 */