package org.apache.html.dom;

import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.ParentNode;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.html.HTMLScriptElement;

public class HTMLScriptElementImpl extends HTMLElementImpl
  implements HTMLScriptElement
{
  private static final long serialVersionUID = 5090330049085326558L;

  public String getText()
  {
    StringBuffer localStringBuffer = new StringBuffer();
    for (Node localNode = getFirstChild(); localNode != null; localNode = localNode.getNextSibling())
    {
      if (!(localNode instanceof Text))
        continue;
      localStringBuffer.append(((Text)localNode).getData());
    }
    return localStringBuffer.toString();
  }

  public void setText(String paramString)
  {
    Node localNode;
    for (Object localObject = getFirstChild(); localObject != null; localObject = localNode)
    {
      localNode = ((Node)localObject).getNextSibling();
      removeChild((Node)localObject);
    }
    insertBefore(getOwnerDocument().createTextNode(paramString), getFirstChild());
  }

  public String getHtmlFor()
  {
    return getAttribute("for");
  }

  public void setHtmlFor(String paramString)
  {
    setAttribute("for", paramString);
  }

  public String getEvent()
  {
    return getAttribute("event");
  }

  public void setEvent(String paramString)
  {
    setAttribute("event", paramString);
  }

  public String getCharset()
  {
    return getAttribute("charset");
  }

  public void setCharset(String paramString)
  {
    setAttribute("charset", paramString);
  }

  public boolean getDefer()
  {
    return getBinary("defer");
  }

  public void setDefer(boolean paramBoolean)
  {
    setAttribute("defer", paramBoolean);
  }

  public String getSrc()
  {
    return getAttribute("src");
  }

  public void setSrc(String paramString)
  {
    setAttribute("src", paramString);
  }

  public String getType()
  {
    return getAttribute("type");
  }

  public void setType(String paramString)
  {
    setAttribute("type", paramString);
  }

  public HTMLScriptElementImpl(HTMLDocumentImpl paramHTMLDocumentImpl, String paramString)
  {
    super(paramHTMLDocumentImpl, paramString);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.html.dom.HTMLScriptElementImpl
 * JD-Core Version:    0.6.0
 */