/*    */ package org.apache.xml.resolver.readers;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.net.MalformedURLException;
/*    */ import java.util.Vector;
/*    */ import org.apache.xml.resolver.Catalog;
/*    */ import org.apache.xml.resolver.CatalogEntry;
/*    */ import org.apache.xml.resolver.CatalogException;
/*    */ import org.apache.xml.resolver.CatalogManager;
/*    */ import org.apache.xml.resolver.helpers.Debug;
/*    */ 
/*    */ public class TR9401CatalogReader extends TextCatalogReader
/*    */ {
/*    */   public void readCatalog(Catalog catalog, InputStream is)
/*    */     throws MalformedURLException, IOException
/*    */   {
/* 71 */     this.catfile = is;
/*    */ 
/* 73 */     if (this.catfile == null) {
/* 74 */       return;
/*    */     }
/*    */ 
/* 77 */     Vector unknownEntry = null;
/*    */     try
/*    */     {
/*    */       while (true) {
/* 81 */         String token = nextToken();
/*    */ 
/* 83 */         if (token == null) {
/* 84 */           if (unknownEntry != null) {
/* 85 */             catalog.unknownEntry(unknownEntry);
/* 86 */             unknownEntry = null;
/*    */           }
/* 88 */           this.catfile.close();
/* 89 */           this.catfile = null;
/* 90 */           return;
/*    */         }
/*    */ 
/* 93 */         String entryToken = null;
/* 94 */         if (this.caseSensitive)
/* 95 */           entryToken = token;
/*    */         else {
/* 97 */           entryToken = token.toUpperCase();
/*    */         }
/*    */ 
/* 100 */         if (entryToken.equals("DELEGATE")) {
/* 101 */           entryToken = "DELEGATE_PUBLIC";
/*    */         }
/*    */         try
/*    */         {
/* 105 */           int type = CatalogEntry.getEntryType(entryToken);
/* 106 */           int numArgs = CatalogEntry.getEntryArgCount(type);
/* 107 */           Vector args = new Vector();
/*    */ 
/* 109 */           if (unknownEntry != null) {
/* 110 */             catalog.unknownEntry(unknownEntry);
/* 111 */             unknownEntry = null;
/*    */           }
/*    */ 
/* 114 */           for (int count = 0; count < numArgs; count++) {
/* 115 */             args.addElement(nextToken());
/*    */           }
/*    */ 
/* 118 */           catalog.addEntry(new CatalogEntry(entryToken, args));
/*    */         } catch (CatalogException cex) {
/* 120 */           if (cex.getExceptionType() == 3) {
/* 121 */             if (unknownEntry == null) {
/* 122 */               unknownEntry = new Vector();
/*    */             }
/* 124 */             unknownEntry.addElement(token);
/* 125 */           } else if (cex.getExceptionType() == 2) {
/* 126 */             catalog.getCatalogManager().debug.message(1, "Invalid catalog entry", token);
/* 127 */             unknownEntry = null;
/* 128 */           } else if (cex.getExceptionType() == 8) {
/* 129 */             catalog.getCatalogManager().debug.message(1, cex.getMessage());
/*    */           }
/*    */         }
/*    */       }
/*    */     } catch (CatalogException cex2) {
/* 134 */       if (cex2.getExceptionType() == 8)
/* 135 */         catalog.getCatalogManager().debug.message(1, cex2.getMessage());
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xml.resolver.readers.TR9401CatalogReader
 * JD-Core Version:    0.6.0
 */