package org.hsqldb;

import java.io.IOException;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

class CachedDataRow extends CachedRow
{
  CachedDataRow(Table paramTable, Object[] paramArrayOfObject)
    throws HsqlException
  {
    super(paramTable, paramArrayOfObject);
    this.hasDataChanged = true;
  }

  CachedDataRow(Table paramTable, RowInputInterface paramRowInputInterface)
    throws IOException, HsqlException
  {
    this.tTable = paramTable;
    this.iPos = paramRowInputInterface.getPos();
    this.storageSize = paramRowInputInterface.getSize();
    this.oData = paramRowInputInterface.readData(this.tTable.getColumnTypes());
    this.hasDataChanged = false;
  }

  Row getUpdatedRow()
    throws HsqlException
  {
    return this.tTable.getRow(this.iPos, this.nPrimaryNode);
  }

  void setNewNodes()
  {
    int i = this.tTable.getIndexCount();
    this.nPrimaryNode = Node.newNode(this, 0, this.tTable);
    Node localNode = this.nPrimaryNode;
    for (int j = 1; j < i; j++)
    {
      localNode.nNext = Node.newNode(this, j, this.tTable);
      localNode = localNode.nNext;
    }
  }

  void setPrimaryNode(Node paramNode)
  {
    this.nPrimaryNode = paramNode;
  }

  public int getRealSize(RowOutputInterface paramRowOutputInterface)
  {
    return paramRowOutputInterface.getSize(this);
  }

  public void write(RowOutputInterface paramRowOutputInterface)
  {
    paramRowOutputInterface.writeSize(this.storageSize);
    paramRowOutputInterface.writeData(this.oData, this.tTable);
    paramRowOutputInterface.writeEnd();
    this.hasDataChanged = false;
  }

  public boolean hasChanged()
  {
    return this.hasDataChanged;
  }

  public void setPos(int paramInt)
  {
    this.iPos = paramInt;
    for (Node localNode = this.nPrimaryNode; localNode != null; localNode = localNode.nNext)
      ((PointerNode)localNode).iData = this.iPos;
  }

  public boolean equals(Object paramObject)
  {
    if (paramObject == this)
      return true;
    if ((paramObject instanceof CachedDataRow))
      return (((CachedDataRow)paramObject).iPos == this.iPos) && (((CachedDataRow)paramObject).tTable == this.tTable);
    return false;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.CachedDataRow
 * JD-Core Version:    0.6.0
 */