package org.hsqldb;

import java.io.IOException;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class CachedRow extends Row
{
  static final int NO_POS = -1;
  protected Table tTable;
  int storageSize;
  protected boolean hasDataChanged;
  boolean hasNodesChanged;

  CachedRow()
  {
  }

  public static CachedRow newCachedRow(Table paramTable, Object[] paramArrayOfObject)
    throws HsqlException
  {
    if (paramTable.isText)
      return new CachedDataRow(paramTable, paramArrayOfObject);
    return new CachedRow(paramTable, paramArrayOfObject);
  }

  CachedRow(Table paramTable, Object[] paramArrayOfObject)
    throws HsqlException
  {
    this.tTable = paramTable;
    int i = paramTable.getIndexCount();
    this.nPrimaryNode = Node.newNode(this, 0, paramTable);
    Node localNode = this.nPrimaryNode;
    for (int j = 1; j < i; j++)
    {
      localNode.nNext = Node.newNode(this, j, paramTable);
      localNode = localNode.nNext;
    }
    this.oData = paramArrayOfObject;
    this.hasDataChanged = (this.hasNodesChanged = 1);
  }

  public CachedRow(Table paramTable, RowInputInterface paramRowInputInterface)
    throws IOException, HsqlException
  {
    this.tTable = paramTable;
    this.iPos = paramRowInputInterface.getPos();
    this.storageSize = paramRowInputInterface.getSize();
    int i = paramTable.getIndexCount();
    this.nPrimaryNode = Node.newNode(this, paramRowInputInterface, 0, paramTable);
    Node localNode = this.nPrimaryNode;
    for (int j = 1; j < i; j++)
    {
      localNode.nNext = Node.newNode(this, paramRowInputInterface, j, paramTable);
      localNode = localNode.nNext;
    }
    this.oData = paramRowInputInterface.readData(this.tTable.getColumnTypes());
  }

  private void readRowInfo(RowInputInterface paramRowInputInterface)
    throws IOException, HsqlException
  {
  }

  public void delete()
    throws HsqlException
  {
    super.delete();
    this.hasNodesChanged = (this.hasDataChanged = 0);
    this.tTable = null;
  }

  public int getStorageSize()
  {
    return this.storageSize;
  }

  public void setPos(int paramInt)
  {
    this.iPos = paramInt;
  }

  void setChanged()
  {
    this.hasNodesChanged = true;
  }

  public boolean hasChanged()
  {
    return this.hasNodesChanged;
  }

  public Table getTable()
  {
    return this.tTable;
  }

  public int getRealSize(RowOutputInterface paramRowOutputInterface)
  {
    return this.tTable.getIndexCount() * 16 + paramRowOutputInterface.getSize(this);
  }

  public void setStorageSize(int paramInt)
  {
    this.storageSize = paramInt;
  }

  public synchronized boolean isKeepInMemory()
  {
    for (Node localNode = this.nPrimaryNode; localNode != null; localNode = localNode.nNext)
      if (localNode.isRoot())
        return true;
    return false;
  }

  synchronized Row getUpdatedRow()
    throws HsqlException
  {
    return this.tTable == null ? null : (CachedRow)this.tTable.rowStore.get(this.iPos);
  }

  void setNewNodes()
  {
  }

  public void write(RowOutputInterface paramRowOutputInterface)
  {
    try
    {
      writeNodes(paramRowOutputInterface);
      if (this.hasDataChanged)
      {
        paramRowOutputInterface.writeData(this.oData, this.tTable);
        paramRowOutputInterface.writeEnd();
        this.hasDataChanged = false;
      }
    }
    catch (IOException localIOException)
    {
    }
  }

  private void writeRowInfo(RowOutputInterface paramRowOutputInterface)
  {
  }

  public void write(RowOutputInterface paramRowOutputInterface, IntLookup paramIntLookup)
  {
    paramRowOutputInterface.writeSize(this.storageSize);
    for (Node localNode = this.nPrimaryNode; localNode != null; localNode = localNode.nNext)
      ((DiskNode)localNode).writeTranslate(paramRowOutputInterface, paramIntLookup);
    paramRowOutputInterface.writeData(getData(), getTable());
    paramRowOutputInterface.writeEnd();
  }

  private void writeNodes(RowOutputInterface paramRowOutputInterface)
    throws IOException
  {
    paramRowOutputInterface.writeSize(this.storageSize);
    for (Node localNode = this.nPrimaryNode; localNode != null; localNode = localNode.nNext)
      localNode.write(paramRowOutputInterface);
    this.hasNodesChanged = false;
  }

  public boolean equals(Object paramObject)
  {
    if (paramObject == this)
      return true;
    if ((paramObject instanceof CachedRow))
      return ((CachedRow)paramObject).iPos == this.iPos;
    return false;
  }

  public int hashCode()
  {
    return this.iPos;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.CachedRow
 * JD-Core Version:    0.6.0
 */