package org.hsqldb;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;

final class CompiledStatementManager
{
  private Database database;
  private IntKeyHashMap schemaMap;
  private IntKeyHashMap sqlLookup;
  private IntKeyHashMap csidMap;
  private IntKeyHashMap sessionUseMap;
  private IntKeyIntValueHashMap useMap;
  private int next_cs_id;

  CompiledStatementManager(Database paramDatabase)
  {
    this.database = paramDatabase;
    this.schemaMap = new IntKeyHashMap();
    this.sqlLookup = new IntKeyHashMap();
    this.csidMap = new IntKeyHashMap();
    this.sessionUseMap = new IntKeyHashMap();
    this.useMap = new IntKeyIntValueHashMap();
    this.next_cs_id = 0;
  }

  synchronized void reset()
  {
    this.schemaMap.clear();
    this.sqlLookup.clear();
    this.csidMap.clear();
    this.sessionUseMap.clear();
    this.useMap.clear();
    this.next_cs_id = 0;
  }

  synchronized void resetStatements()
  {
    Iterator localIterator = this.csidMap.values().iterator();
    while (localIterator.hasNext())
    {
      CompiledStatement localCompiledStatement = (CompiledStatement)localIterator.next();
      localCompiledStatement.clearVariables();
    }
  }

  private int nextID()
  {
    this.next_cs_id += 1;
    return this.next_cs_id;
  }

  private int getStatementID(HsqlNameManager.HsqlName paramHsqlName, String paramString)
  {
    IntValueHashMap localIntValueHashMap = (IntValueHashMap)this.schemaMap.get(paramHsqlName.hashCode());
    if (localIntValueHashMap == null)
      return -1;
    return localIntValueHashMap.get(paramString, -1);
  }

  synchronized CompiledStatement getStatement(Session paramSession, int paramInt)
  {
    CompiledStatement localCompiledStatement = (CompiledStatement)this.csidMap.get(paramInt);
    if (localCompiledStatement == null)
      return null;
    if (!localCompiledStatement.isValid)
    {
      String str = (String)this.sqlLookup.get(paramInt);
      try
      {
        localCompiledStatement = compileSql(paramSession, str, localCompiledStatement.schemaHsqlName.name);
        localCompiledStatement.id = paramInt;
        this.csidMap.put(paramInt, localCompiledStatement);
      }
      catch (Throwable localThrowable)
      {
        freeStatement(paramInt, paramSession.getId(), true);
        return null;
      }
    }
    return localCompiledStatement;
  }

  private void linkSession(int paramInt1, int paramInt2)
  {
    IntKeyIntValueHashMap localIntKeyIntValueHashMap = (IntKeyIntValueHashMap)this.sessionUseMap.get(paramInt2);
    if (localIntKeyIntValueHashMap == null)
    {
      localIntKeyIntValueHashMap = new IntKeyIntValueHashMap();
      this.sessionUseMap.put(paramInt2, localIntKeyIntValueHashMap);
    }
    int i = localIntKeyIntValueHashMap.get(paramInt1, 0);
    localIntKeyIntValueHashMap.put(paramInt1, i + 1);
    if (i == 0)
      this.useMap.put(paramInt1, this.useMap.get(paramInt1, 0) + 1);
  }

  private int registerStatement(int paramInt, CompiledStatement paramCompiledStatement)
  {
    if (paramInt < 0)
    {
      paramInt = nextID();
      int i = paramCompiledStatement.schemaHsqlName.hashCode();
      IntValueHashMap localIntValueHashMap = (IntValueHashMap)this.schemaMap.get(i);
      if (localIntValueHashMap == null)
      {
        localIntValueHashMap = new IntValueHashMap();
        this.schemaMap.put(i, localIntValueHashMap);
      }
      localIntValueHashMap.put(paramCompiledStatement.sql, paramInt);
      this.sqlLookup.put(paramInt, paramCompiledStatement.sql);
    }
    paramCompiledStatement.id = paramInt;
    this.csidMap.put(paramInt, paramCompiledStatement);
    return paramInt;
  }

  void freeStatement(int paramInt1, int paramInt2, boolean paramBoolean)
  {
    if (paramInt1 == -1)
      return;
    IntKeyIntValueHashMap localIntKeyIntValueHashMap = (IntKeyIntValueHashMap)this.sessionUseMap.get(paramInt2);
    if (localIntKeyIntValueHashMap == null)
      return;
    int i = localIntKeyIntValueHashMap.get(paramInt1, 0);
    if (i != 0)
      if ((i == 1) || (paramBoolean))
      {
        localIntKeyIntValueHashMap.remove(paramInt1);
        int j = this.useMap.get(paramInt1, 0);
        if (j != 0)
          if (j == 1)
          {
            CompiledStatement localCompiledStatement = (CompiledStatement)this.csidMap.remove(paramInt1);
            if (localCompiledStatement != null)
            {
              int k = localCompiledStatement.schemaHsqlName.hashCode();
              IntValueHashMap localIntValueHashMap = (IntValueHashMap)this.schemaMap.get(k);
              String str = (String)this.sqlLookup.remove(paramInt1);
              localIntValueHashMap.remove(str);
            }
            this.useMap.remove(paramInt1);
          }
          else
          {
            this.useMap.put(paramInt1, j - 1);
          }
      }
      else
      {
        localIntKeyIntValueHashMap.put(paramInt1, i - 1);
      }
  }

  synchronized void removeSession(int paramInt)
  {
    IntKeyIntValueHashMap localIntKeyIntValueHashMap = (IntKeyIntValueHashMap)this.sessionUseMap.remove(paramInt);
    if (localIntKeyIntValueHashMap == null)
      return;
    Iterator localIterator = localIntKeyIntValueHashMap.keySet().iterator();
    while (localIterator.hasNext())
    {
      int i = localIterator.nextInt();
      int j = this.useMap.get(i, 1) - 1;
      if (j == 0)
      {
        CompiledStatement localCompiledStatement = (CompiledStatement)this.csidMap.remove(i);
        if (localCompiledStatement != null)
        {
          int k = localCompiledStatement.schemaHsqlName.hashCode();
          IntValueHashMap localIntValueHashMap = (IntValueHashMap)this.schemaMap.get(k);
          String str = (String)this.sqlLookup.remove(i);
          localIntValueHashMap.remove(str);
        }
        this.useMap.remove(i);
        continue;
      }
      this.useMap.put(i, j);
    }
  }

  synchronized CompiledStatement compile(Session paramSession, String paramString)
    throws Throwable
  {
    int i = getStatementID(paramSession.currentSchema, paramString);
    CompiledStatement localCompiledStatement = (CompiledStatement)this.csidMap.get(i);
    if ((localCompiledStatement == null) || (!localCompiledStatement.isValid) || (!paramSession.isAdmin()))
    {
      localCompiledStatement = compileSql(paramSession, paramString, paramSession.currentSchema.name);
      i = registerStatement(i, localCompiledStatement);
    }
    linkSession(i, paramSession.getId());
    return localCompiledStatement;
  }

  private CompiledStatement compileSql(Session paramSession, String paramString1, String paramString2)
    throws Throwable
  {
    Session localSession = this.database.sessionManager.getSysSession(paramString2, paramSession.getUser());
    return localSession.sqlCompileStatement(paramString1);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.CompiledStatementManager
 * JD-Core Version:    0.6.0
 */