package org.hsqldb;

import java.util.Locale;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.store.ValuePool;

final class DITypeInfo
{
  static final int columnNoNulls = 0;
  static final int columnNullable = 1;
  static final int typePredNone = 0;
  static final int typePredChar = 1;
  static final int typePredBasic = 2;
  static final int typeSearchable = 3;
  private int hnd_create_params = -1;
  private int hnd_local_names = -1;
  private int hnd_remarks = -1;
  private int type = 0;
  private int typeSub = 1;
  boolean locale_set;

  Integer getCharOctLen()
  {
    return null;
  }

  Long getCharOctLenAct()
  {
    switch (this.type)
    {
    case -1:
    case 1:
    case 12:
      return ValuePool.getLong(4294967294L);
    case 2005:
      return ValuePool.getLong(9223372036854775807L);
    }
    return null;
  }

  String getColStClsName()
  {
    return Types.getColStClsName(this.type);
  }

  String getCreateParams()
  {
    if (!this.locale_set)
      setLocale(Locale.getDefault());
    String str;
    switch (this.type)
    {
    case 1:
    case 12:
      str = "LENGTH";
      break;
    case 2:
    case 3:
      str = "PRECISION,SCALE";
      break;
    case 6:
    case 93:
      str = "PRECISION";
      break;
    default:
      str = null;
    }
    return str;
  }

  String getCstMapClsName()
  {
    switch (this.type)
    {
    case 2003:
      return "org.hsqldb.jdbc.jdbcArray";
    case 2004:
      return "org.hsqldb.jdbc.jdbcBlob";
    case 2005:
      return "org.hsqldb.jdbc.jdbcClob";
    case 2001:
      return "org.hsqldb.jdbc.jdbcDistinct";
    case 2006:
      return "org.hsqldb.jdbc.jdbcRef";
    case 2002:
      return "org.hsqldb.jdbc.jdbcStruct";
    }
    return null;
  }

  int getMaxDisplaySize()
  {
    return Types.getMaxDisplaySize(this.type);
  }

  Integer getDataType()
  {
    return ValuePool.getInt(this.type);
  }

  Integer getDataTypeSub()
  {
    return ValuePool.getInt(this.typeSub);
  }

  Integer getDefaultScale()
  {
    switch (this.type)
    {
    case -6:
    case -5:
    case 4:
    case 5:
      return ValuePool.getInt(0);
    }
    return null;
  }

  Integer getIntervalPrecision()
  {
    return null;
  }

  String getLiteralPrefix()
  {
    switch (this.type)
    {
    case -4:
    case -3:
    case -2:
    case -1:
    case 1:
    case 12:
    case 2004:
    case 2005:
      return "'";
    case 70:
      return "'";
    case 91:
      return "'";
    case 1111:
      return "'";
    case 92:
      return "'";
    case 93:
      return "'";
    case 137:
      return "'";
    }
    return null;
  }

  String getLiteralSuffix()
  {
    switch (this.type)
    {
    case -4:
    case -3:
    case -2:
    case -1:
    case 1:
    case 12:
    case 2004:
    case 2005:
      return "'";
    case 70:
    case 91:
    case 92:
    case 93:
    case 137:
    case 1111:
      return "'";
    }
    return null;
  }

  String getLocalName()
  {
    if (!this.locale_set)
      setLocale(Locale.getDefault());
    String str = getTypeName();
    return BundleHandler.getString(this.hnd_local_names, str);
  }

  Integer getMaxScale()
  {
    switch (this.type)
    {
    case -6:
    case -5:
    case 4:
    case 5:
    case 91:
    case 92:
      return ValuePool.getInt(0);
    case 93:
      return ValuePool.getInt(6);
    case 2:
    case 3:
      return ValuePool.getInt(32767);
    case 6:
    case 7:
    case 8:
      return ValuePool.getInt(306);
    }
    return null;
  }

  Integer getMaxScaleAct()
  {
    switch (this.type)
    {
    case 2:
    case 3:
      return ValuePool.getInt(2147483647);
    }
    return getMaxScale();
  }

  Integer getMinScale()
  {
    switch (this.type)
    {
    case -6:
    case -5:
    case 2:
    case 3:
    case 4:
    case 5:
    case 91:
    case 92:
    case 93:
      return ValuePool.getInt(0);
    case 6:
    case 7:
    case 8:
      return ValuePool.getInt(-324);
    }
    return null;
  }

  Integer getMinScaleAct()
  {
    return getMinScale();
  }

  Integer getNullability()
  {
    return ValuePool.getInt(1);
  }

  Integer getNumPrecRadix()
  {
    switch (this.type)
    {
    case -6:
    case -5:
    case 2:
    case 3:
    case 4:
    case 5:
    case 7:
    case 8:
      return ValuePool.getInt(10);
    case 6:
      return ValuePool.getInt(2);
    case -4:
    case -3:
    case -2:
    case -1:
    case 0:
    case 1:
    }
    return null;
  }

  Integer getPrecision()
  {
    int i = Types.getPrecision(this.type);
    return i == 0 ? null : ValuePool.getInt(i);
  }

  Long getPrecisionAct()
  {
    Integer localInteger = getPrecision();
    if (localInteger == null)
      return ValuePool.getLong(9223372036854775807L);
    return ValuePool.getLong(localInteger.longValue());
  }

  String getRemarks()
  {
    if (!this.locale_set)
      setLocale(Locale.getDefault());
    String str = getTypeName();
    return BundleHandler.getString(this.hnd_remarks, str);
  }

  Integer getSearchability()
  {
    return Types.isSearchable(this.type) ? ValuePool.getInt(3) : ValuePool.getInt(0);
  }

  Integer getSqlDataType()
  {
    switch (this.type)
    {
    case 2003:
      return ValuePool.getInt(50);
    case -5:
      return ValuePool.getInt(25);
    case -2:
      return ValuePool.getInt(30);
    case 16:
      return ValuePool.getInt(16);
    case 2004:
      return ValuePool.getInt(30);
    case 1:
      return ValuePool.getInt(1);
    case 2005:
      return ValuePool.getInt(40);
    case 70:
      return ValuePool.getInt(70);
    case 91:
      return ValuePool.getInt(9);
    case 3:
      return ValuePool.getInt(3);
    case 2001:
      return ValuePool.getInt(17);
    case 8:
      return ValuePool.getInt(8);
    case 6:
      return ValuePool.getInt(6);
    case 4:
      return ValuePool.getInt(4);
    case 2000:
      return ValuePool.getInt(2000);
    case -4:
      return ValuePool.getInt(30);
    case -1:
      return ValuePool.getInt(40);
    case 0:
      return ValuePool.getInt(0);
    case 2:
      return ValuePool.getInt(2);
    case 1111:
      return ValuePool.getInt(1111);
    case 7:
      return ValuePool.getInt(7);
    case 2006:
      return ValuePool.getInt(20);
    case 5:
      return ValuePool.getInt(5);
    case 2002:
      return ValuePool.getInt(17);
    case 92:
      return ValuePool.getInt(9);
    case 93:
      return ValuePool.getInt(9);
    case -6:
      return ValuePool.getInt(-6);
    case -3:
      return ValuePool.getInt(30);
    case 12:
      return ValuePool.getInt(12);
    case 137:
      return ValuePool.getInt(137);
    }
    return null;
  }

  Integer getSqlDateTimeSub()
  {
    switch (this.type)
    {
    case 91:
      return ValuePool.getInt(1);
    case 92:
      return ValuePool.getInt(2);
    case 93:
      return ValuePool.getInt(3);
    }
    return null;
  }

  String getStdMapClsName()
  {
    switch (this.type)
    {
    case 2003:
      return "java.sql.Array";
    case -5:
      return "long";
    case -4:
    case -3:
    case -2:
      return "[B";
    case 16:
      return "boolean";
    case 2004:
      return "java.sql.Blob";
    case -1:
    case 1:
    case 12:
      return "java.lang.String";
    case 2005:
      return "java.sql.Clob";
    case 70:
      return "java.net.URL";
    case 91:
      return "java.sql.Date";
    case 2:
    case 3:
      return "java.math.BigDecimal";
    case 137:
    case 1111:
    case 2000:
    case 2001:
      return "java.lang.Object";
    case 7:
      return "float";
    case 6:
    case 8:
      return "double";
    case 4:
      return "int";
    case 0:
      return "null";
    case 2006:
      return "java.sql.Ref";
    case 5:
      return "short";
    case 2002:
      return "java.sql.Struct";
    case 92:
      return "java.sql.Time";
    case 93:
      return "java.sql.Timestamp";
    case -6:
      return "byte";
    }
    return null;
  }

  int getTypeCode()
  {
    return this.type;
  }

  String getTypeName()
  {
    return this.typeSub == 4 ? Types.getTypeName(100) : Types.getTypeName(this.type);
  }

  int getTypeSub()
  {
    return this.typeSub;
  }

  Boolean isAutoIncrement()
  {
    switch (this.type)
    {
    case -6:
    case 2:
    case 3:
    case 5:
    case 6:
    case 7:
    case 8:
      return Boolean.FALSE;
    case -5:
    case 4:
      return Boolean.TRUE;
    case -4:
    case -3:
    case -2:
    case -1:
    case 0:
    case 1:
    }
    return null;
  }

  Boolean isCaseSensitive()
  {
    return this.typeSub == 4 ? Boolean.FALSE : Types.isCaseSensitive(this.type);
  }

  Boolean isColStClsSupported()
  {
    return ValuePool.getBoolean(this.type == 0);
  }

  Boolean isFixedPrecisionScale()
  {
    switch (this.type)
    {
    case -6:
    case -5:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
      return Boolean.FALSE;
    case -4:
    case -3:
    case -2:
    case -1:
    case 0:
    case 1:
    }
    return null;
  }

  Boolean isStdMapClsSupported()
  {
    boolean bool = false;
    switch (this.type)
    {
    case 2003:
      try
      {
        Class.forName("java.sql.Array");
        bool = true;
      }
      catch (Exception localException1)
      {
        bool = false;
      }
    case 2004:
      try
      {
        Class.forName("java.sql.Blob");
        bool = true;
      }
      catch (Exception localException2)
      {
        bool = false;
      }
    case 2005:
      try
      {
        Class.forName("java.sql.Clob");
        bool = true;
      }
      catch (Exception localException3)
      {
        bool = false;
      }
    case 2001:
      bool = false;
      break;
    case 2006:
      try
      {
        Class.forName("java.sql.Ref");
        bool = true;
      }
      catch (Exception localException4)
      {
        bool = false;
      }
    case 2002:
      try
      {
        Class.forName("java.sql.Struct");
        bool = true;
      }
      catch (Exception localException5)
      {
        bool = false;
      }
    default:
      bool = getStdMapClsName() != null;
    }
    return ValuePool.getBoolean(bool);
  }

  Boolean isSupportedAsPCol()
  {
    switch (this.type)
    {
    case 0:
    case 2000:
    case 2003:
      return Boolean.TRUE;
    }
    return isSupportedAsTCol();
  }

  Boolean isSupportedAsTCol()
  {
    if (this.type == 0)
      return Boolean.FALSE;
    String str = Types.getTypeString(this.type);
    return ValuePool.getBoolean(str != null);
  }

  Boolean isUnsignedAttribute()
  {
    return Types.isUnsignedAttribute(this.type);
  }

  void setLocale(Locale paramLocale)
  {
    if (paramLocale == null)
    {
      this.hnd_create_params = (this.hnd_local_names = this.hnd_remarks = -1);
      this.locale_set = false;
      return;
    }
    synchronized (BundleHandler.class)
    {
      Locale localLocale = BundleHandler.getLocale();
      BundleHandler.setLocale(paramLocale);
      this.hnd_create_params = BundleHandler.getBundleHandle("data-type-create-parameters", null);
      this.hnd_local_names = BundleHandler.getBundleHandle("data-type-names", null);
      this.hnd_remarks = BundleHandler.getBundleHandle("data-type-remarks", null);
      BundleHandler.setLocale(localLocale);
      this.locale_set = true;
    }
  }

  void setTypeCode(int paramInt)
  {
    this.type = paramInt;
  }

  void setTypeSub(int paramInt)
  {
    this.typeSub = paramInt;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.DITypeInfo
 * JD-Core Version:    0.6.0
 */